/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.engine.task.impl.FAFSimpleDataSyncTask;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.GLVoucherHelper;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.stream.pipe.IExceptionListener;
import kd.macc.faf.util.CalculateCondition;

public class FAFGLVoucherDataSyncTask
extends FAFSimpleDataSyncTask {
    private static final String ALGO_KEY = "PAGLVoucherDataSyncTask.processQueryReader";

    public FAFGLVoucherDataSyncTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, MainEntityType outputDynEntity, RdbSQLSplitTaskIterator splitTaskIterator, Map<String, String> fieldMappings, Map<String, Object> defaultValueMap, int totalStatisticsPoints, Long analysisModelId, Map<String, CalculateCondition> conditionMap) {
        super(taskKey, version, exceptionListener, outputDynEntity, splitTaskIterator, fieldMappings, defaultValueMap, totalStatisticsPoints, analysisModelId, conditionMap);
    }

    @Override
    public void initializeTaskJob() {
        super.initializeTaskJob();
        final HashSet<String> flexFieldSet = new HashSet<String>(Arrays.asList(this.splitTaskIterator.getSelectFields().split(",")));
        this.flexProperty = EntityMetaHelper.matchFlexProperty("gl_voucher").stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return flexFieldSet.contains(s);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public long processQueryReader(QFilter[] qFilter, DataSet dataSet) {
        int saveCount = 0;
        String sourceNumber = this.splitTaskIterator.getEntityNumber();
        try (DataSet dssource = dataSet;
             DataSet dsglassist = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"gl_assist", (String)"id,assvals", null, null);
             DataSet dsjoin = this.leftJoinList(dssource, dsglassist, this.flexProperty);){
            Object[] writeDataBuffer = new DynamicObject[this.batchCount];
            long[] targetIds = DBServiceHelper.genLongIds((String)("t_" + this.outputDynEntity.getName()), (int)this.batchCount);
            boolean hasCreateTimeField = EntityMetadataCache.getDataEntityType((String)this.outputDynEntity.getName()).getProperty("createtime") != null;
            Date now = new Date();
            int rowCount = 0;
            DynamicObject dynObj = null;
            while (dsjoin.hasNext()) {
                Row row = dsjoin.next();
                Long entryId = row.getLong("entries.id");
                Long sourceId = row.getLong("id");
                writeDataBuffer[rowCount] = dynObj = new DynamicObject((DynamicObjectType)this.outputDynEntity);
                long targetId = targetIds[rowCount++];
                dynObj.set("id", (Object)targetId);
                if (hasCreateTimeField) {
                    dynObj.set("createtime", (Object)now);
                }
                for (Map.Entry entry : this.defaultValueMap.entrySet()) {
                    dynObj.set((String)entry.getKey(), entry.getValue());
                }
                for (int i = 0; i < this.outputDimDynProps.length; ++i) {
                    IDataEntityProperty property = this.outputDimDynProps[i];
                    String sourceFiledName = (String)this.sourceFieldNames.get(i);
                    boolean isFlexField = false;
                    for (String flexfield : this.flexProperty) {
                        if (!sourceFiledName.startsWith(flexfield)) continue;
                        String flexfieldVal = row.getString(flexfield + "assvals");
                        if (StringUtils.isNotEmpty((CharSequence)flexfieldVal)) {
                            Map flexfieldValMap = (Map)SerializationUtils.fromJsonString((String)flexfieldVal, Map.class);
                            String fieldName = GLVoucherHelper.delFlexFieldPrefix(sourceFiledName, flexfield);
                            property.setValueFast((Object)dynObj, flexfieldValMap.get(fieldName));
                        }
                        isFlexField = true;
                        break;
                    }
                    if (isFlexField) continue;
                    Object o = row.get(sourceFiledName);
                    property.setValueFast((Object)dynObj, o);
                }
                this.setConditionValue(row, dynObj);
                dynObj.set("sourceformid", (Object)sourceNumber);
                dynObj.set("sourcebillid", (Object)sourceId);
                dynObj.set("del", (Object)this.taskKey);
                dynObj.set("createstamp", (Object)System.currentTimeMillis());
                this.setRelationShipValue(dynObj);
                if (rowCount == writeDataBuffer.length) {
                    this.saveBufferRecords(writeDataBuffer);
                    writeDataBuffer = new DynamicObject[this.batchCount];
                    rowCount = 0;
                    targetIds = DBServiceHelper.genLongIds((String)("t_" + this.outputDynEntity.getName()), (int)this.batchCount);
                }
                ++saveCount;
            }
            if (rowCount > 0) {
                this.saveBufferRecords(Arrays.copyOf(writeDataBuffer, rowCount));
            }
        }
        return saveCount;
    }
}

