/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.AbstractRdbDataQueryTask;
import kd.macc.faf.engine.task.FAFAbstractWorkTask;
import kd.macc.faf.engine.task.impl.FAFDataSequenceWorkTaskGroup;
import kd.macc.faf.engine.task.impl.FAFOlapDataSyncTaskBuilder;
import kd.macc.faf.engine.task.impl.FAFWorkTaskFactory;
import kd.macc.faf.engine.task.impl.olap.AbstractOlapDataQueryTask;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFRdbSqlIteratorHelper;
import kd.macc.faf.helper.FAFSyncDataSchemeHelper;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.rdb.RdbSQLInfo;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.stream.pipe.IExceptionListener;

public class FAFLazyStatisticsTask
extends FAFAbstractWorkTask<Long> {
    private static final Log logger = LogFactory.getLog(FAFLazyStatisticsTask.class);
    protected FAFDataSequenceWorkTaskGroup sequenceWorkTaskGroup;
    protected IWorkTaskTransLog<Long> taskTransLog;

    protected FAFLazyStatisticsTask(Serializable taskKey, IExceptionListener exceptionListener) {
        super(taskKey, exceptionListener);
    }

    protected FAFLazyStatisticsTask(Serializable taskKey, FAFDataSequenceWorkTaskGroup sequenceWorkTaskGroup, IWorkTaskTransLog<Long> taskTransLog) {
        super(taskKey, sequenceWorkTaskGroup.getExceptionListener(), sequenceWorkTaskGroup.getTaskGroupCondition());
        this.workTaskStatusEvent = sequenceWorkTaskGroup.getWorkTaskStatusEvent();
        this.sequenceWorkTaskGroup = sequenceWorkTaskGroup;
        this.taskTransLog = taskTransLog;
    }

    @Override
    protected Long doTaskJob() {
        if (logger.isInfoEnabled()) {
            logger.info("\u5ef6\u65f6\u7edf\u8ba1,\u521d\u59cb\u5316\u4efb\u52a1\u5f00\u59cb");
        }
        if (this.taskTransLog instanceof FAFWorkTaskMeta) {
            try {
                FAFWorkTaskMeta meta = (FAFWorkTaskMeta)this.taskTransLog;
                Long analysisModelId = meta.getAnalysisModelId();
                if (!FAFAnalysisModelHelper.isModelNewVersion(analysisModelId)) {
                    return 0L;
                }
                QFilter qFilter = new QFilter("analysismodel", "=", (Object)analysisModelId);
                qFilter.and("enable", "=", (Object)"1");
                DynamicObjectCollection dataSchemeDynColl = QueryServiceHelper.query((String)"pa_syncdataschema", (String)"id, datasource.datasource_type, name", (QFilter[])new QFilter[]{qFilter});
                Integer totalCount = 0;
                StringBuilder unRelationParamTipSb = new StringBuilder();
                ArrayList<Object> olapDataQueryTasks = new ArrayList<Object>(dataSchemeDynColl.size());
                for (DynamicObject dynamicObject : dataSchemeDynColl) {
                    String dataSourceType = dynamicObject.getString("datasource.datasource_type");
                    if (DataSourceTypeEnum.EPM.getCode().equals(dataSourceType) || DataSourceTypeEnum.BCM.getCode().equals(dataSourceType)) {
                        OlapDataExtractingDTO extractingDTO;
                        DataExtractingDTO dto = meta.getDataExtractingDTO();
                        if (!TimeTypeEnum.PERIOD.getCode().equals(dto.getTimeType()) || (extractingDTO = FAFSyncDataSchemeHelper.buildOlapDataExtractingDTO(dynamicObject.getLong("id"), dto.getOrgIdSet(), dto.getPeriodIdSet())) == null) continue;
                        extractingDTO.buildExtractingValues();
                        logger.info("OlapDtoParam:" + extractingDTO.toString());
                        extractingDTO.setDataSourceTypeEnum(OlapFromServiceEnum.getEnum(dataSourceType));
                        String tips = this.checkUnRelationParamTips(extractingDTO, dto);
                        if (!StringUtils.isEmpty((Object)tips)) {
                            unRelationParamTipSb.append(dynamicObject.getString("name")).append(" : ").append(tips).append("\n\r");
                        }
                        if (!KdOlapServerHelper.checkExtractingOlapData(extractingDTO, dto)) continue;
                        FAFOlapDataSyncTaskBuilder fafOlapDataSyncTaskBuilder = new FAFOlapDataSyncTaskBuilder(extractingDTO);
                        HashMap<String, Long> param = new HashMap<String, Long>(1);
                        param.put("datasynctask", meta.getTaskId());
                        Object olapDataQueryTask = fafOlapDataSyncTaskBuilder.build(param, new Object[0]);
                        ((AbstractOlapDataQueryTask)olapDataQueryTask).setTaskMeta(meta);
                        olapDataQueryTasks.add(olapDataQueryTask);
                        totalCount = totalCount + fafOlapDataSyncTaskBuilder.getRecordCnt();
                        continue;
                    }
                    FAFWorkTaskMeta schemeMeta = meta.createOtherSchemeMeta(dynamicObject.getLong("id"), dynamicObject.getString("name"));
                    RdbSQLSplitTaskIterator splitIterator = FAFRdbSqlIteratorHelper.getRdbSqlIteratorByMeta(schemeMeta);
                    AbstractRdbDataQueryTask dataQueryTask = FAFWorkTaskFactory.createDataQueryTask(schemeMeta, DataSourceTypeEnum.getEnum(dynamicObject.getString("datasource.datasource_type")), splitIterator);
                    if (dataQueryTask == null) continue;
                    dataQueryTask.setTaskMeta(schemeMeta);
                    this.sequenceWorkTaskGroup.addSubTask(dataQueryTask);
                    totalCount = totalCount + splitIterator.getTotalCount();
                }
                if (!CollectionUtils.isEmpty(olapDataQueryTasks)) {
                    for (AbstractOlapDataQueryTask abstractOlapDataQueryTask : olapDataQueryTasks) {
                        this.sequenceWorkTaskGroup.addSubTask(abstractOlapDataQueryTask);
                    }
                }
                RdbSQLInfo rdbSQLInfo = FAFRdbSqlIteratorHelper.getRdbSqlInfoByMeta(meta);
                this.sequenceWorkTaskGroup.setEndingTask(FAFWorkTaskFactory.createDataEntityDataProcessTask(this.taskTransLog, false, rdbSQLInfo));
                if (logger.isInfoEnabled()) {
                    logger.info("\u7edf\u8ba1\u4efb\u52a1\u7ed3\u675f\uff0c\u66f4\u65b0\u4efb\u52a1\u72b6\u6001");
                }
                if (this.workTaskStatusEvent instanceof IDataSimpleWorkTaskStatisticStatus) {
                    IDataSimpleWorkTaskStatisticStatus iDataSimpleWorkTaskStatisticStatus = (IDataSimpleWorkTaskStatisticStatus)this.workTaskStatusEvent;
                    iDataSimpleWorkTaskStatisticStatus.updateSubTaskStartStatus(true);
                    iDataSimpleWorkTaskStatisticStatus.updateTaskTotalTaskPoint(totalCount);
                    iDataSimpleWorkTaskStatisticStatus.setUnRelationParamTips(unRelationParamTipSb.toString());
                }
                this.getWorkTaskStatusMgr().updateTaskStatus(this.workTaskStatusEvent);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return null;
    }

    protected String checkUnRelationParamTips(OlapDataExtractingDTO extractingDTO, DataExtractingDTO dto) {
        StringBuilder orgTips = new StringBuilder();
        StringBuilder periodTips = new StringBuilder();
        List<MappingRelationShipDTO> relationShipDTOS = extractingDTO.getMappingRelationShipDTOs();
        for (MappingRelationShipDTO relationShipDTO : relationShipDTOS) {
            if (relationShipDTO == null) continue;
            String targetDimensionNumber = relationShipDTO.getTargetDimensionNumber();
            if (targetDimensionNumber.equals(dto.getOrgDimNumber())) {
                Collection<Object> relationOrgSet = relationShipDTO.getDimMembersIdMapping().values();
                HashSet<Long> orgIdSet = new HashSet<Long>(dto.getOrgIdSet());
                HashSet relationOrgLongIdSet = new HashSet(orgIdSet.size());
                for (Object orgId : relationOrgSet) {
                    if (orgId instanceof Integer) {
                        relationOrgLongIdSet.add(Long.parseLong(orgId.toString()));
                        continue;
                    }
                    if (!(orgId instanceof Long)) continue;
                    relationOrgLongIdSet.add((Long)orgId);
                }
                orgIdSet.removeAll(relationOrgLongIdSet);
                if (orgIdSet.isEmpty()) continue;
                Map map = BusinessDataServiceHelper.loadFromCache((Object[])orgIdSet.toArray(), (String)"bos_org");
                orgTips.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"FAFLazyStatisticsTask_0", (String)"macc-faf-common", (Object[])new Object[0]));
                int i = 0;
                for (DynamicObject value : map.values()) {
                    if (i == map.size() - 1) {
                        orgTips.append(value.getString("name")).append("\u3002");
                    } else {
                        orgTips.append(value.getString("name")).append("\u3001");
                    }
                    ++i;
                }
                orgTips.append("\n\r");
                continue;
            }
            if (!targetDimensionNumber.equals(dto.getPeriodDimNumber())) continue;
            Collection<Object> relationPeriodSet = relationShipDTO.getDimMembersIdMapping().values();
            HashSet<Long> relationPeriodLongIdSet = new HashSet<Long>(relationPeriodSet.size());
            for (Object e : relationPeriodSet) {
                if (e instanceof Integer) {
                    relationPeriodLongIdSet.add(Long.parseLong(e.toString()));
                    continue;
                }
                if (!(e instanceof Long)) continue;
                relationPeriodLongIdSet.add((Long)e);
            }
            HashSet<Long> periodIdSet = new HashSet<Long>(dto.getPeriodIdSet());
            periodIdSet.removeAll(relationPeriodLongIdSet);
            if (periodIdSet.isEmpty()) continue;
            periodTips.append(ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"FAFLazyStatisticsTask_1", (String)"macc-faf-common", (Object[])new Object[0]));
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])periodIdSet.toArray(), (String)dto.getPeriodBaseData());
            int i = 0;
            for (DynamicObject value : map.values()) {
                if (i == map.size() - 1) {
                    periodTips.append(value.getString("name")).append("\u3002");
                } else {
                    periodTips.append(value.getString("name")).append("\u3001");
                }
                ++i;
            }
            periodTips.append("\n\r");
        }
        return orgTips.append((CharSequence)periodTips).toString();
    }
}

