/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.engine.model.FAFOlapDataStatisticsInfo;
import kd.macc.faf.engine.task.IBuilder;
import kd.macc.faf.engine.task.impl.olap.AbstractOlapDataQueryTask;
import kd.macc.faf.engine.task.impl.olap.FAFOlapDataSyncTask;
import kd.macc.faf.engine.task.impl.olap.FAFSimpleOlapDataSyncTask;
import kd.macc.faf.enums.FAFOlapSelectTypeEnum;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.olap.OlapMultipleSplitSQLBuilder;
import kd.macc.faf.olap.OlapSQLBuilder;

public class FAFOlapDataSyncTaskBuilder
implements IBuilder<AbstractOlapDataQueryTask> {
    private boolean needTransformField = true;
    private LinkedList<String> splitDimNames = new LinkedList();
    private int recordCnt;
    private OlapDataExtractingDTO olapDataExtDTO;

    public FAFOlapDataSyncTaskBuilder() {
    }

    public FAFOlapDataSyncTaskBuilder(OlapDataExtractingDTO olapDataExtDTO) {
        this();
        this.olapDataExtDTO = olapDataExtDTO;
    }

    protected OlapMultipleSplitSQLBuilder buildOlapSplitSQLBuilder(String cubeNumber, boolean ignoreMeasureNull, Long taskId) {
        int limitCount = 50000;
        Map<Integer, List<String>> selectDimensions = this.olapDataExtDTO.getSelectDimensionMap();
        HashSet measureDimensions = new HashSet(selectDimensions.get(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode()));
        Map<String, Set<String>> dimensionFilters = this.olapDataExtDTO.getDimFilters();
        Map<String, Set<String>> validateDimsFilters = KdOlapServerHelper.validateDimMemTasks(dimensionFilters, taskId, cubeNumber, this.olapDataExtDTO.getDataSourceTypeEnum());
        HashSet<String> changeRowKey = new HashSet<String>((Collection)selectDimensions.get(FAFOlapSelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode()));
        Map<String, Set<String>> usedDimMemberMap = KdOlapServerHelper.acquireUsedDimMemTasks(changeRowKey, validateDimsFilters, cubeNumber, this.olapDataExtDTO.getDataSourceTypeEnum());
        ArrayList<Map.Entry<String, Set<String>>> sortBufList = new ArrayList<Map.Entry<String, Set<String>>>(usedDimMemberMap.entrySet());
        Collections.sort(sortBufList, (src, target) -> ((Set)target.getValue()).size() - ((Set)src.getValue()).size());
        if (changeRowKey.contains("Entity")) {
            this.splitDimNames.add("Entity");
        }
        if (changeRowKey.contains("Account")) {
            this.splitDimNames.add("Account");
        }
        for (Map.Entry entry : sortBufList) {
            if (this.splitDimNames.contains(entry.getKey())) continue;
            this.splitDimNames.add((String)entry.getKey());
        }
        for (Map.Entry entry : dimensionFilters.entrySet()) {
            if (measureDimensions.contains(entry.getKey()) || this.splitDimNames.contains(entry.getKey())) continue;
            this.splitDimNames.add((String)entry.getKey());
        }
        FAFOlapDataStatisticsInfo olapDataStatisticsInfo = KdOlapServerHelper.queryDimMemComboStatistics(cubeNumber, this.splitDimNames.getFirst(), null, validateDimsFilters, ignoreMeasureNull, this.olapDataExtDTO.getDataSourceTypeEnum());
        OlapMultipleSplitSQLBuilder olapMultipleSplitSQLBuilder = new OlapMultipleSplitSQLBuilder(cubeNumber, validateDimsFilters, ignoreMeasureNull, olapDataStatisticsInfo, limitCount, this.splitDimNames, this.olapDataExtDTO.getDataSourceTypeEnum());
        olapMultipleSplitSQLBuilder.batchAddSelectDimensions(selectDimensions);
        this.setRecordCnt((int)olapDataStatisticsInfo.getTotalRecCnt());
        olapMultipleSplitSQLBuilder.startSplitTask();
        olapMultipleSplitSQLBuilder.setUsedDimMemberMap(usedDimMemberMap);
        return olapMultipleSplitSQLBuilder;
    }

    @Override
    public AbstractOlapDataQueryTask build(Map<String, Object> param, Object ... objects) {
        String cubeNumber = this.olapDataExtDTO.getCubeCatelog();
        if (StringUtils.isEmpty((String)cubeNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u4f20\u5165\u76ee\u6807OLAP\u7684\u5206\u7ec4\u540d\u79f0\u3002", (String)"FAFOlapDataSyncTaskBuilder_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        Map<String, Set<String>> dimensionFilters = this.olapDataExtDTO.getDimFilters();
        if (dimensionFilters == null || dimensionFilters.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff01", (String)"FAFOlapDataSyncTaskBuilder_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        Map<List<String>, String> transformFieldIndexMap = this.olapDataExtDTO.getTransformFieldIndexMap();
        if (this.needTransformField && (transformFieldIndexMap == null || transformFieldIndexMap.isEmpty())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u8fdb\u884c\u5217\u8f6c\u6362\u884c\uff0c\u5219\u7f3a\u5931\u8f6c\u6362\u7684\u6620\u5c04\u4fe1\u606f\uff01", (String)"FAFOlapDataSyncTaskBuilder_2", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        Long taskId = (Long)param.get("datasynctask");
        boolean allowDimNull = true;
        boolean ignoreMeasureNull = false;
        Map<Integer, List<String>> selectDimensions = this.olapDataExtDTO.getSelectDimensionMap();
        OlapMultipleSplitSQLBuilder multipleSQLBuilder = this.buildOlapSplitSQLBuilder(cubeNumber, ignoreMeasureNull, taskId);
        List<String> transDimsList = selectDimensions.get(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode());
        HashMap<String, Map<String, Long>> dimEntityNumberTransIdMap = new HashMap<String, Map<String, Long>>(10);
        Map<String, String> dimEntityMapping = this.olapDataExtDTO.getDimEntityMapping();
        Long moduleId = this.olapDataExtDTO.getModuleId();
        Map<String, Set<String>> dimFilters = multipleSQLBuilder.getDimFilters();
        for (Map.Entry<String, Set<String>> dimEntry : dimFilters.entrySet()) {
            if (transDimsList.contains(dimEntry.getKey())) continue;
            QFilter qFilter = new QFilter("number", "in", dimEntry.getValue());
            qFilter.and(new QFilter("model", "=", (Object)moduleId));
            String entity = dimEntityMapping.get(dimEntry.getKey());
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.engine.task.impl.FAFOlapDataSyncTaskBuilder.build", (String)entity, (String)"number, id", (QFilter[])qFilter.toArray(), null);
            Throwable throwable = null;
            try {
                HashMap<String, Long> numberIdMap = new HashMap<String, Long>(((Set)dimEntry.getValue()).size());
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    numberIdMap.put(next.getString("number"), next.getLong("id"));
                }
                dimEntityNumberTransIdMap.put((String)dimEntry.getKey(), (Map<String, Long>)numberIdMap);
            }
            catch (Throwable numberIdMap) {
                throwable = numberIdMap;
                throw numberIdMap;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable numberIdMap) {
                        throwable.addSuppressed(numberIdMap);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        Map<String, Set<String>> usedDimMemberMap = multipleSQLBuilder.getUsedDimMemberMap();
        for (Map.Entry entry : usedDimMemberMap.entrySet()) {
            String changeDimension = (String)entry.getKey();
            if (dimEntityNumberTransIdMap.get(changeDimension) != null) continue;
            Set olapDimMember = (Set)entry.getValue();
            String entity = dimEntityMapping.get(changeDimension);
            QFilter qFilter = new QFilter("number", "in", (Object)olapDimMember);
            qFilter.and(new QFilter("model", "=", (Object)moduleId));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.engine.task.impl.FAFOlapDataSyncTaskBuilder.build", (String)entity, (String)"number, id", (QFilter[])qFilter.toArray(), null);
            Throwable throwable = null;
            try {
                HashMap<String, Long> numberIdMap = new HashMap<String, Long>(olapDimMember.size());
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    numberIdMap.put(next.getString("number"), next.getLong("id"));
                }
                dimEntityNumberTransIdMap.put(changeDimension, numberIdMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        String outputTargetEntityName = this.olapDataExtDTO.getAnalysisModelDyObj();
        if (this.needTransformField && transformFieldIndexMap != null && !transformFieldIndexMap.isEmpty()) {
            return new FAFOlapDataSyncTask((long)taskId, (Long)0L, (OlapSQLBuilder)multipleSQLBuilder, outputTargetEntityName, transformFieldIndexMap, this.olapDataExtDTO.getFieldMappings(), allowDimNull, ignoreMeasureNull, this.recordCnt, this.olapDataExtDTO.getDefaultValueMap(), dimEntityNumberTransIdMap, this.olapDataExtDTO.getMappingRelationShipDTOs());
        }
        String string = transformFieldIndexMap == null ? "FMONEY" : transformFieldIndexMap.values().toArray(new String[0])[0];
        return new FAFSimpleOlapDataSyncTask(taskId, 0L, multipleSQLBuilder, outputTargetEntityName, this.olapDataExtDTO.getFieldMappings(), allowDimNull, ignoreMeasureNull, string, this.recordCnt, this.olapDataExtDTO.getDefaultValueMap(), dimEntityNumberTransIdMap, this.olapDataExtDTO.getMappingRelationShipDTOs());
    }

    public boolean validateCacheParam() {
        Map<String, Set<String>> dimensionFilters = this.olapDataExtDTO.getDimFilters();
        if (dimensionFilters == null || dimensionFilters.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"FAFOlapDataSyncTaskBuilder_3", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (this.needTransformField && (this.olapDataExtDTO.getTransformFieldIndexMap() == null || this.olapDataExtDTO.getTransformFieldIndexMap().isEmpty())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u8fdb\u884c\u5217\u8f6c\u6362\u884c\uff0c\u5219\u7f3a\u5931\u8f6c\u6362\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"FAFOlapDataSyncTaskBuilder_4", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)this.olapDataExtDTO.getAnalysisModelDyObj())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u8f93\u51fa\u7684\u5b9e\u4f53\u5bf9\u8c61\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"FAFOlapDataSyncTaskBuilder_5", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (this.olapDataExtDTO.getFieldMappings() == null || this.olapDataExtDTO.getFieldMappings().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u59cb\u7ef4\u5ea6\u7f16\u53f7\u4e0e\u5b9e\u4f53\u7ef4\u5ea6\u7f16\u53f7\u6620\u5c04\u4e3a\u7a7a\u3002", (String)"FAFOlapDataSyncTaskBuilder_6", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean isNeedTransformField() {
        return this.needTransformField;
    }

    public void setNeedTransformField(boolean needTransformField) {
        this.needTransformField = needTransformField;
    }

    public LinkedList<String> getSplitDimNames() {
        return this.splitDimNames;
    }

    public void setSplitDimNames(LinkedList<String> splitDimNames) {
        this.splitDimNames = splitDimNames;
    }

    public int getRecordCnt() {
        return this.recordCnt;
    }

    public void setRecordCnt(int recordCnt) {
        this.recordCnt = recordCnt;
    }
}

