/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.engine.task.AbstractRdbDataQueryTask;
import kd.macc.faf.engine.transformer.RelationShipWritePosTransformer;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.GLVoucherHelper;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.stream.pipe.IExceptionListener;
import kd.macc.faf.util.CalculateCondition;
import kd.macc.faf.util.ConditionExecutor;

public class FAFSimpleDataSyncTask
extends AbstractRdbDataQueryTask {
    private static final Log logger = LogFactory.getLog(FAFSimpleDataSyncTask.class);
    private static final String ALGO_KEY = "PASimpleDataSyncTask.processQueryReader";
    protected Map<String, String> fieldMappings;
    protected Map<String, Object> defaultValueMap;
    protected IDataEntityProperty[] outputDimDynProps;
    protected List<String> sourceFieldNames;
    protected int batchCount;
    protected Map<String, CalculateCondition> conditionMap;
    protected List<String> flexProperty;
    protected RelationShipWritePosTransformer relationShipWritePosLookupService;

    @Override
    public void initializeTaskJob() {
        LinkedList<DynamicProperty> dimPropList = new LinkedList<DynamicProperty>();
        this.sourceFieldNames = new ArrayList<String>(this.fieldMappings.size());
        boolean i = false;
        for (Map.Entry<String, String> entry : this.fieldMappings.entrySet()) {
            dimPropList.add(this.outputDynEntity.getProperty(entry.getKey()));
            this.sourceFieldNames.add(entry.getValue());
        }
        this.outputDimDynProps = dimPropList.toArray(new IDataEntityProperty[0]);
        final HashSet<String> flexFieldSet = new HashSet<String>(Arrays.asList(this.splitTaskIterator.getSelectFields().split(",")));
        this.flexProperty = EntityMetaHelper.matchFlexProperty(this.splitTaskIterator.getEntityNumber()).stream().filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return flexFieldSet.contains(s);
            }
        }).collect(Collectors.toList());
        if (this.relationShipWritePosLookupService == null) {
            this.relationShipWritePosLookupService = RelationShipWritePosTransformer.buildRelationShipWritePosTransformer(this.getOutputTargetEntityName(), this.mappingRelationShipDTOList);
        }
    }

    public FAFSimpleDataSyncTask(Serializable taskKey, Serializable version, IExceptionListener exceptionListener, MainEntityType outputDynEntity, RdbSQLSplitTaskIterator splitTaskIterator, Map<String, String> fieldMappings, Map<String, Object> defaultValueMap, int totalStatisticsPoints, Long analysisModelId, Map<String, CalculateCondition> conditionMap) {
        super(taskKey, version, exceptionListener, outputDynEntity, splitTaskIterator, analysisModelId);
        this.fieldMappings = fieldMappings;
        this.defaultValueMap = defaultValueMap;
        this.taskResult = 0L;
        this.totalStatisticsPoints = totalStatisticsPoints;
        this.conditionMap = conditionMap;
        this.batchCount = 1500;
    }

    @Override
    public long processQueryReader(QFilter[] qFilter, DataSet dataSet) {
        int saveCount = 0;
        String sourceNumber = this.splitTaskIterator.getEntityNumber();
        try (DataSet dssource = dataSet;
             DataSet dsglassist = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"gl_assist", (String)"id,assvals", null, null);
             DataSet dsjoin = this.leftJoinList(dssource, dsglassist, this.flexProperty);){
            Object[] writeDataBuffer = new DynamicObject[this.batchCount];
            int row = 0;
            long[] targetIds = DBServiceHelper.genLongIds((String)("t_" + this.outputDynEntity.getName()), (int)this.batchCount);
            boolean hasCreateTimeField = EntityMetadataCache.getDataEntityType((String)this.outputDynEntity.getName()).getProperty("createtime") != null;
            Date now = new Date();
            while (dsjoin.hasNext()) {
                Row next = dsjoin.next();
                ++saveCount;
                DynamicObject dynObj = new DynamicObject((DynamicObjectType)this.outputDynEntity);
                writeDataBuffer[row++] = dynObj;
                long targetId = targetIds[row];
                long sourceId = next.getLong("id");
                dynObj.set("id", (Object)targetId);
                if (hasCreateTimeField) {
                    dynObj.set("createtime", (Object)now);
                }
                for (Map.Entry<String, Object> entry : this.defaultValueMap.entrySet()) {
                    dynObj.set(entry.getKey(), entry.getValue());
                }
                for (int i = 0; i < this.outputDimDynProps.length; ++i) {
                    IDataEntityProperty property = this.outputDimDynProps[i];
                    String sourceFiledName = this.sourceFieldNames.get(i);
                    boolean isFlexField = false;
                    for (String flexfield : this.flexProperty) {
                        if (!sourceFiledName.startsWith(flexfield)) continue;
                        String flexfieldVal = next.getString(flexfield + "assvals");
                        if (StringUtils.isNotEmpty((CharSequence)flexfieldVal)) {
                            Map flexfieldValMap = (Map)SerializationUtils.fromJsonString((String)flexfieldVal, Map.class);
                            String fieldName = GLVoucherHelper.delFlexFieldPrefix(sourceFiledName, flexfield);
                            property.setValueFast((Object)dynObj, flexfieldValMap.get(fieldName));
                        }
                        isFlexField = true;
                        break;
                    }
                    if (isFlexField) continue;
                    Object o = next.get(sourceFiledName);
                    property.setValueFast((Object)dynObj, o);
                }
                this.setConditionValue(next, dynObj);
                dynObj.set("del", (Object)this.taskKey);
                this.setRelationShipValue(dynObj);
                dynObj.set("sourceformid", (Object)sourceNumber);
                dynObj.set("sourcebillid", (Object)sourceId);
                dynObj.set("createstamp", (Object)System.currentTimeMillis());
                if (row != writeDataBuffer.length) continue;
                this.saveBufferRecords(writeDataBuffer);
                writeDataBuffer = new DynamicObject[this.batchCount];
                targetIds = DBServiceHelper.genLongIds((String)("t_" + this.outputDynEntity.getName()), (int)this.batchCount);
                row = 0;
            }
            if (row > 0) {
                this.saveBufferRecords(Arrays.copyOf(writeDataBuffer, row));
            }
        }
        return saveCount;
    }

    protected void setConditionValue(Row row, DynamicObject dynObj) {
        for (Map.Entry<String, CalculateCondition> conditionEntry : this.conditionMap.entrySet()) {
            Object value = ConditionExecutor.exeMeasureCondition(row, conditionEntry.getValue());
            if (value == null) continue;
            dynObj.set(conditionEntry.getKey(), value);
        }
    }

    protected void setRelationShipValue(DynamicObject dynObj) {
        if (this.relationShipWritePosLookupService != null) {
            this.relationShipWritePosLookupService.convert(dynObj);
        }
    }

    protected void saveBufferRecords(Object[] srcDatas) {
        try {
            int writeCnt = BusinessDataWriter.save((IDataEntityType)this.outputDynEntity, (Object[])srcDatas).length;
            this.updateTaskStatistics(srcDatas.length, writeCnt, 0);
        }
        catch (Exception e) {
            this.onException(e);
            throw e;
        }
    }

    protected DataSet leftJoinList(DataSet dssource, DataSet dsglassist, List<String> list) {
        DataSet dsleft = dssource;
        DataSet dsright = dsglassist;
        for (String property : list) {
            dsleft = this.leftJoin(dsleft, dsright, property);
        }
        return dsleft;
    }

    protected DataSet leftJoin(DataSet dsleft, DataSet dsright, String property) {
        DataSet dsJoin = dsleft.leftJoin(dsright).on(property, "id").select(dsleft.getRowMeta().getFieldNames(), new String[]{"assvals as " + property + "assvals"}).finish();
        return dsJoin;
    }

    public Map<String, String> getFieldMappings() {
        return this.fieldMappings;
    }

    public Map<String, Object> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    public Map<String, CalculateCondition> getConditionMap() {
        return this.conditionMap;
    }

    public RelationShipWritePosTransformer getRelationShipWritePosLookupService() {
        return this.relationShipWritePosLookupService;
    }

    public void setRelationShipWritePosLookupService(RelationShipWritePosTransformer relationShipWritePosLookupService) {
        this.relationShipWritePosLookupService = relationShipWritePosLookupService;
    }
}

