/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.AbstractRdbDataQueryTask;
import kd.macc.faf.engine.task.FAFDataEntityDataProcessTask;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.impl.FAFCalculateWorkTaskGroup;
import kd.macc.faf.engine.task.impl.FAFDataEntityCreateTask;
import kd.macc.faf.engine.task.impl.FAFDataEntityDeleteTask;
import kd.macc.faf.engine.task.impl.FAFDataParallelWorkTaskGroup;
import kd.macc.faf.engine.task.impl.FAFDataSequenceInterruptWorkTaskGroup;
import kd.macc.faf.engine.task.impl.FAFDataSequenceWorkTaskGroup;
import kd.macc.faf.engine.task.impl.FAFDataSyncTaskBuilder;
import kd.macc.faf.engine.task.impl.FAFDataSyncWorkTaskWrapper;
import kd.macc.faf.engine.task.impl.FAFLazyStatisticsTask;
import kd.macc.faf.engine.task.impl.FAFLazySummaryCalculateWrapperTask;
import kd.macc.faf.engine.task.impl.FAFSummaryWorkTaskGroup;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.fas.dto.FAFComparisonDTO;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.handle.impl.FAFDataCalculateMeasureHandler;
import kd.macc.faf.handle.impl.FAFDataComplementHandler;
import kd.macc.faf.handle.impl.FAFDataSummaryHandler;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.rdb.RdbComplementIterator;
import kd.macc.faf.rdb.RdbSQLInfo;
import kd.macc.faf.rdb.RdbSQLPeriodMeasureIterator;
import kd.macc.faf.rdb.RdbSQLSingleCalMeasureIterator;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.rdb.RdbSQLSummaryIterator;
import kd.macc.faf.stream.pipe.IExceptionListener;

public class FAFWorkTaskFactory {
    private static final Log logger = LogFactory.getLog(FAFWorkTaskFactory.class);

    public static IDataAbstractWorkTask createPAWorkTask(Integer taskType, IWorkTaskTransLog<Long> taskTransLog, boolean needWrapper) {
        FAFWorkTaskTypeEnum workTaskType;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("createPAWorkTask: taskType:%s, taskTransLog=%s", taskType, taskTransLog));
        }
        if ((workTaskType = FAFWorkTaskTypeEnum.getEnum(taskType)) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f85\u521b\u5efa\u7684\u5de5\u4f5c\u4efb\u52a1\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\u6216\u4e3a\u7a7a\uff01WorkTaskType=%s", (String)"FAFWorkTaskFactory_0", (String)"macc-faf-common", (Object[])new Object[0]), taskType));
        }
        IDataAbstractWorkTask workTask = null;
        switch (workTaskType) {
            case Create_Table_Task: {
                workTask = FAFWorkTaskFactory.createDataEntityCreateTask(taskTransLog);
                break;
            }
            case Drop_Table_Task: {
                workTask = FAFWorkTaskFactory.createDataEntityDeleteTask(taskTransLog);
                break;
            }
            case Query_DB_Data_Task: {
                workTask = FAFWorkTaskFactory.createDataQueryTask(taskTransLog, null, null);
                break;
            }
            case Query_DB_Data_Sync_Group_Task: {
                workTask = FAFWorkTaskFactory.createDataQueryTaskGroup(taskTransLog);
                break;
            }
            case Mark_Delete_Status_Task: {
                workTask = FAFWorkTaskFactory.createDataEntityDataProcessTask(taskTransLog, true, null);
                break;
            }
            case Rollback_Delete_Status_Or_Delete_Data_Task: {
                workTask = FAFWorkTaskFactory.createDataEntityDataProcessTask(taskTransLog, false, null);
                break;
            }
            case SUMMARY_MODEL_TASK: {
                workTask = FAFWorkTaskFactory.createSummaryTaskGroup(taskTransLog);
                break;
            }
            case CALCULATE_MODEL_MEASURE_TASK: {
                workTask = FAFWorkTaskFactory.createCalculateTaskGroup(taskTransLog);
                break;
            }
            case SUMMARY_CALCULATE_MODEL_Group_Task: {
                workTask = FAFWorkTaskFactory.createSummaryCalculateTaskGroup(taskTransLog);
                break;
            }
            case SUMMARY_CALCULATE_MODEL_Task: {
                workTask = FAFWorkTaskFactory.createSummaryCalculateLazyTask(taskTransLog);
                break;
            }
            case QUERY_SUMMARY_CALCULATE_MODEL_Group_Task: {
                workTask = FAFWorkTaskFactory.createQuerySummaryCalculateTaskGroup(taskTransLog);
                break;
            }
            case CALCULATE_MODEL_LAZY_TASK: {
                workTask = FAFWorkTaskFactory.createCalculateLazyTask(taskTransLog);
                break;
            }
            case COMPLEMENT_MODEL_TASK: {
                workTask = FAFWorkTaskFactory.createComplementTaskGroup(taskTransLog);
                break;
            }
            case COMPLEMENT_CALCULATE_MODEL_LAZY_TASK: {
                workTask = FAFWorkTaskFactory.createComplementCalculateLazyTask(taskTransLog);
                break;
            }
            case COMPLEMENT_CALCULATE_MODEL_TASK: {
                workTask = FAFWorkTaskFactory.createComplementCalculateTaskGroup(taskTransLog);
                break;
            }
            case QUERY_SUMMARY_CALCULATE_MODEL_Group_Task_Schedule: {
                workTask = FAFWorkTaskFactory.createQuerySummaryCalculateTaskGroupSchedule(taskTransLog);
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u5de5\u4f5c\u4efb\u52a1\u7c7b\u578b\uff01WorkTaskType=%s", (String)"FAFWorkTaskFactory_1", (String)"macc-faf-common", (Object[])new Object[0]), taskType));
            }
        }
        return needWrapper ? FAFWorkTaskFactory.createWrapperTask(workTask, taskTransLog) : workTask;
    }

    public static FAFDataSyncWorkTaskWrapper createWrapperTask(IDataAbstractWorkTask srcTask, IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFDataSyncWorkTaskWrapper(srcTask, taskTransLog);
    }

    public static FAFDataEntityCreateTask createDataEntityCreateTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFDataEntityCreateTask(taskTransLog);
    }

    public static FAFDataEntityDeleteTask createDataEntityDeleteTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFDataEntityDeleteTask(taskTransLog);
    }

    public static FAFDataSequenceWorkTaskGroup createDataQueryTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            FAFDataSequenceWorkTaskGroup groupTask = new FAFDataSequenceWorkTaskGroup((Serializable)meta.getTaskId(), (Serializable)((Object)"999"), null);
            FAFLazyStatisticsTask lazyStatisticsTask = new FAFLazyStatisticsTask((Serializable)meta.getTaskId(), groupTask, meta);
            groupTask.addSubTask(lazyStatisticsTask);
            return groupTask;
        }
        return null;
    }

    public static FAFDataEntityDataProcessTask createDataEntityDataProcessTask(IWorkTaskTransLog<Long> taskTransLog, boolean markDelete, RdbSQLInfo rdbSQLInfo) {
        return new FAFDataEntityDataProcessTask(taskTransLog, markDelete, rdbSQLInfo);
    }

    public static AbstractRdbDataQueryTask createDataQueryTask(IWorkTaskTransLog<Long> taskTransLog, DataSourceTypeEnum dataSourceTypeEnum, RdbSQLSplitTaskIterator splitIterator) {
        Object result = null;
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            FAFDataSyncTaskBuilder FAFDataSyncTaskBuilder2 = new FAFDataSyncTaskBuilder();
            HashMap<String, Object> buildParam = new HashMap<String, Object>(2);
            buildParam.put("key_datasynctask", meta.getTaskId());
            buildParam.put("key_scheme_id", meta.getDataSchemeId());
            buildParam.put("entity_type", (Object)dataSourceTypeEnum);
            buildParam.put("rdb_iterator", splitIterator);
            result = FAFDataSyncTaskBuilder2.build(buildParam, new Object[0]);
        }
        return result;
    }

    public static FAFCalculateWorkTaskGroup createSummaryTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        FAFSummaryWorkTaskGroup result = null;
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            DynamicObject analysisModel = FAFAnalysisModelHelper.loadAnalysisModel(meta.getAnalysisModelId());
            FAFAnalysisModelModel analysisModelModel = new FAFAnalysisModelModel();
            analysisModelModel.loadFromDynamicObject(analysisModel, true);
            String selectField = FAFTableDataHelper.selectField(analysisModelModel, false);
            DataExtractingDTO dataExtractingDTO = meta.getDataExtractingDTO();
            RdbSQLSummaryIterator summaryIterator = dataExtractingDTO != null ? new RdbSQLSummaryIterator("fias", analysisModelModel.getDetailEntityNumber(), selectField, analysisModelModel.getOrgDim(), analysisModelModel.getPeriodDim(), dataExtractingDTO.getOrgIdSet(), dataExtractingDTO.getPeriodIdSet(), dataExtractingDTO.getStartDate(), dataExtractingDTO.getEndDate()) : new RdbSQLSummaryIterator("fias", analysisModelModel.getDetailEntityNumber(), selectField, analysisModelModel.getOrgDim(), analysisModelModel.getPeriodDim(), null, null, null, null);
            summaryIterator.splitFilter();
            FAFDataSummaryHandler handler = new FAFDataSummaryHandler(analysisModelModel);
            result = new FAFSummaryWorkTaskGroup((Serializable)meta.getTaskId(), (Serializable)((Object)"888"), summaryIterator, handler);
        }
        return result;
    }

    public static FAFDataParallelWorkTaskGroup createCalculateTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFDataParallelWorkTaskGroup parallelWorkTaskGroup;
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            DynamicObject analysisModel = FAFAnalysisModelHelper.loadAnalysisModel(meta.getAnalysisModelId());
            FAFAnalysisModelModel analysisModelModel = new FAFAnalysisModelModel();
            analysisModelModel.loadFromDynamicObject(analysisModel, true);
            List<FAFMeasureModel> calMeasures = analysisModelModel.getCalMeasure();
            String selectField = FAFTableDataHelper.selectField(analysisModelModel, true);
            FAFDimensionModel orgDim = analysisModelModel.getOrgDim();
            DataExtractingDTO dataExtractingDTO = meta.getDataExtractingDTO();
            IExceptionListener exceptionListener = meta.getExceptionListener();
            FAFDataParallelWorkTaskGroup fAFDataParallelWorkTaskGroup = parallelWorkTaskGroup = exceptionListener == null ? new FAFDataParallelWorkTaskGroup((Serializable)meta.getTaskGroupId(), (Serializable)((Object)"777"), null, analysisModelModel.getDetailEntityNumber()) : new FAFDataParallelWorkTaskGroup(meta.getTaskGroupId(), (Serializable)((Object)"777"), null, analysisModelModel.getDetailEntityNumber(), exceptionListener);
            if (calMeasures != null) {
                for (FAFMeasureModel measureModel : calMeasures) {
                    String sourceEntity = measureModel.getDimension().getSource().getNumber();
                    RdbSQLSingleCalMeasureIterator iterator = "pa_analysisperiod".equals(sourceEntity) ? new RdbSQLPeriodMeasureIterator("fias", analysisModelModel.getModelEntity(), selectField, measureModel, orgDim, dataExtractingDTO != null ? dataExtractingDTO.getOrgIdSet() : null) : new RdbSQLSingleCalMeasureIterator("fias", analysisModelModel.getModelEntity(), selectField, measureModel, orgDim, dataExtractingDTO != null ? dataExtractingDTO.getOrgIdSet() : null);
                    iterator.splitFilter();
                    FAFDataCalculateMeasureHandler handler = new FAFDataCalculateMeasureHandler(analysisModelModel, measureModel, row -> iterator.judge((Row)row));
                    FAFCalculateWorkTaskGroup calculateWorkTaskGroup = new FAFCalculateWorkTaskGroup(meta.getTaskId(), (Serializable)((Object)"777"), parallelWorkTaskGroup.getExceptionListener(), iterator, handler);
                    parallelWorkTaskGroup.addSubTask(calculateWorkTaskGroup, false);
                }
                return parallelWorkTaskGroup;
            }
        }
        return null;
    }

    public static FAFDataSequenceWorkTaskGroup createQuerySummaryCalculateTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            FAFDataSequenceInterruptWorkTaskGroup groupTask = new FAFDataSequenceInterruptWorkTaskGroup((Serializable)meta.getTaskId(), (Serializable)((Object)"555"), null, meta.getTotalCount());
            FAFDataSequenceWorkTaskGroup queryGroupTask = FAFWorkTaskFactory.createDataQueryTaskGroup(taskTransLog);
            groupTask.addSubTask(queryGroupTask);
            FAFLazySummaryCalculateWrapperTask summaryCalculateLazyTask = FAFWorkTaskFactory.createSummaryCalculateLazyTask(taskTransLog);
            summaryCalculateLazyTask.setExceptionListener(groupTask.getExceptionListener());
            summaryCalculateLazyTask.setTaskGroupCondition(groupTask.getTaskGroupCondition());
            groupTask.addSubTask(summaryCalculateLazyTask);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("returnGroupTask %s", groupTask));
            }
            return groupTask;
        }
        if (logger.isInfoEnabled()) {
            logger.info("taskIsNull");
        }
        return null;
    }

    public static FAFDataSequenceWorkTaskGroup createQuerySummaryCalculateTaskGroupSchedule(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            FAFDataSequenceInterruptWorkTaskGroup groupTask = new FAFDataSequenceInterruptWorkTaskGroup(meta.getTaskId(), (Serializable)((Object)"555"));
            FAFDataSequenceWorkTaskGroup queryGroupTask = FAFWorkTaskFactory.createDataQueryTaskGroup(taskTransLog);
            groupTask.addSubTask(queryGroupTask);
            FAFLazySummaryCalculateWrapperTask summaryCalculateLazyTask = FAFWorkTaskFactory.createSummaryCalculateLazyTask(taskTransLog);
            summaryCalculateLazyTask.setExceptionListener(groupTask.getExceptionListener());
            summaryCalculateLazyTask.setTaskGroupCondition(groupTask.getTaskGroupCondition());
            groupTask.addSubTask(summaryCalculateLazyTask);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("returnGroupTask %s", groupTask));
            }
            return groupTask;
        }
        if (logger.isInfoEnabled()) {
            logger.info("taskIsNull");
        }
        return null;
    }

    public static FAFDataSequenceWorkTaskGroup createSummaryCalculateTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            FAFDataSequenceInterruptWorkTaskGroup groupTask = new FAFDataSequenceInterruptWorkTaskGroup((Serializable)meta.getTaskGroupId(), (Serializable)((Object)"666"), null);
            FAFCalculateWorkTaskGroup summaryTask = FAFWorkTaskFactory.createSummaryTaskGroup(taskTransLog);
            if (summaryTask != null) {
                summaryTask.setExceptionListener(groupTask.getExceptionListener());
                summaryTask.setTaskGroupCondition(groupTask.getTaskGroupCondition());
                groupTask.addSubTask(summaryTask);
            }
            groupTask.addSubTask(FAFWorkTaskFactory.createComplementCalculateLazyTask(taskTransLog));
            return groupTask;
        }
        return null;
    }

    public static FAFLazySummaryCalculateWrapperTask createSummaryCalculateLazyTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFLazySummaryCalculateWrapperTask(taskTransLog, FAFWorkTaskTypeEnum.SUMMARY_CALCULATE_MODEL_Group_Task);
    }

    public static FAFLazySummaryCalculateWrapperTask createCalculateLazyTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFLazySummaryCalculateWrapperTask(taskTransLog, FAFWorkTaskTypeEnum.CALCULATE_MODEL_MEASURE_TASK);
    }

    public static FAFLazySummaryCalculateWrapperTask createComplementLazyTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFLazySummaryCalculateWrapperTask(taskTransLog, FAFWorkTaskTypeEnum.COMPLEMENT_MODEL_TASK);
    }

    public static FAFLazySummaryCalculateWrapperTask createComplementCalculateLazyTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FAFLazySummaryCalculateWrapperTask(taskTransLog, FAFWorkTaskTypeEnum.COMPLEMENT_CALCULATE_MODEL_TASK);
    }

    public static FAFDataSequenceWorkTaskGroup createComplementCalculateTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)taskTransLog;
            IExceptionListener exceptionListener = meta.getExceptionListener();
            FAFDataSequenceInterruptWorkTaskGroup groupTask = exceptionListener == null ? new FAFDataSequenceInterruptWorkTaskGroup((Serializable)meta.getTaskGroupId(), (Serializable)((Object)"444"), null) : new FAFDataSequenceInterruptWorkTaskGroup((Serializable)meta.getTaskGroupId(), (Serializable)((Object)"444"), null, exceptionListener);
            FAFSummaryWorkTaskGroup complementTaskGroup = FAFWorkTaskFactory.createComplementTaskGroup(taskTransLog);
            if (complementTaskGroup != null) {
                complementTaskGroup.setExceptionListener(groupTask.getExceptionListener());
                complementTaskGroup.setTaskGroupCondition(groupTask.getTaskGroupCondition());
                groupTask.addSubTask(complementTaskGroup);
            }
            groupTask.addSubTask(FAFWorkTaskFactory.createCalculateLazyTask(taskTransLog));
            return groupTask;
        }
        return null;
    }

    public static FAFSummaryWorkTaskGroup createComplementTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta;
            DataExtractingDTO dataExtractingDTO;
            if (logger.isInfoEnabled()) {
                logger.info(String.format("createComplementTaskGroup:  taskTransLog=%s", taskTransLog));
            }
            if ((dataExtractingDTO = (meta = (FAFWorkTaskMeta)taskTransLog).getDataExtractingDTO()) == null) {
                return null;
            }
            String periodEntityNumber = dataExtractingDTO.getPeriodBaseData();
            if (StringUtils.isEmpty((String)periodEntityNumber)) {
                return null;
            }
            Set<Long> periodIdSet = dataExtractingDTO.getPeriodIdSet();
            if (periodIdSet == null || periodIdSet.isEmpty()) {
                return null;
            }
            Set<Long> orgIdSet = dataExtractingDTO.getOrgIdSet();
            if (orgIdSet == null || orgIdSet.isEmpty()) {
                return null;
            }
            DynamicObject analysisModel = FAFAnalysisModelHelper.loadAnalysisModel(meta.getAnalysisModelId());
            FAFAnalysisModelModel analysisModelModel = new FAFAnalysisModelModel();
            analysisModelModel.loadFromDynamicObject(analysisModel, true);
            List<FAFMeasureModel> calMeasureList = analysisModelModel.getCalMeasure();
            if (calMeasureList == null || calMeasureList.isEmpty()) {
                return null;
            }
            String queryEntity = analysisModelModel.getModelEntity();
            FAFDimensionModel orgDim = analysisModelModel.getOrgDim();
            FAFDimensionModel periodDim = analysisModelModel.getPeriodDim();
            DynamicObject dim = periodDim.getSourceDynamicObject();
            FAFComparisonDTO dto = FAFComparisonDTO.quickCreate(FAFComparisonEnum.C_03.getCode());
            Map<Long, Long> valueMap = dto.loadLinkMap(dim, periodIdSet.toArray()).get("qoq");
            HashMap<Long, Long> resultMap = new HashMap<Long, Long>(valueMap.size());
            valueMap.forEach((k, v) -> resultMap.put((Long)v, (Long)k));
            String selectField = FAFTableDataHelper.selectField(analysisModelModel, true);
            RdbComplementIterator complementIterator = new RdbComplementIterator("fias", queryEntity, selectField, orgDim, periodDim, resultMap, orgIdSet, periodEntityNumber);
            complementIterator.splitFilter();
            FAFDataComplementHandler handler = new FAFDataComplementHandler(analysisModelModel, resultMap);
            return new FAFSummaryWorkTaskGroup((Serializable)meta.getTaskId(), (Serializable)((Object)"333"), complementIterator, handler);
        }
        return null;
    }
}

