/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl.olap;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.IDataAbstractParallelWorkTaskGroup;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.engine.task.status.IDataWorkTaskStatusMgr;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.olap.OlapSQLBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractOlapDataQueryTask
extends IDataAbstractParallelWorkTaskGroup<Long, Callable<Long>, IDataSimpleWorkTaskStatisticStatus> {
    private static final Log logger = LogFactory.getLog(AbstractOlapDataQueryTask.class);
    protected boolean multipleSQLQuery;
    protected OlapSQLBuilder sqlBuilder;
    protected Iterator<OlapSQLBuilder> sqlBuilderIterator;
    protected Map<Integer, List<String>> selectDimensionMap;
    protected MainEntityType outputDynEntity;
    protected Map<String, String> fieldMappings;
    protected Map<String, Object> manuallyAddFieldMap;
    protected IWorkTaskTransLog<Long> taskMeta;

    protected AbstractOlapDataQueryTask(Serializable taskKey, Serializable version, OlapSQLBuilder sqlBuilder, Map<String, String> fieldMappings, Map<String, Object> manuallyAddFieldMap) {
        super(taskKey, version);
        this.sqlBuilder = sqlBuilder;
        this.setSqlBuilder(this.sqlBuilder);
        this.fieldMappings = fieldMappings;
        this.manuallyAddFieldMap = manuallyAddFieldMap;
    }

    @Override
    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FAFWorkTaskStatusConsumer.getInstance();
    }

    protected abstract long processOlapQueryReader(OlapSQLBuilder var1, SelectCommandInfo var2, OlapDataReader var3);

    protected void updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = ((IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent()).copy();
        workTaskStatusEvent.updateTaskStatistics(fetchDataCnt, processDataCnt, skipErrorDataCnt, this.totalStatisticsPoints);
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode(ResManager.loadKDString((String)"\u66f4\u65b0\u53d6\u6570\u4efb\u52a1\u6761\u6570\u5931\u8d25", (String)"AbstractOlapDataQueryTask_0", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long doTaskJob() {
        String lockKey = DLockHelper.getMLockKey(this.outputDynEntity.getName());
        try (DLock dLock = DLock.create((String)lockKey);){
            if (dLock.tryLock(1000L)) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("Start Do Task Job: multipleSQLQuery=%s, outputDynEntity=%s", this.multipleSQLQuery, this.outputDynEntity));
                    }
                    this.updateTaskStatistics(0, 0, 0);
                    if (this.multipleSQLQuery) {
                        this.taskResult = super.doTaskJob();
                    } else {
                        this.initializeTaskJob();
                        Callable<Long> singleQueryWorkTask = this.createOlapQuerySubTask("OLAPInnerSingleQueryTask", this.sqlBuilder);
                        this.executeSubTask(0, new ThreeValueTuple<Callable<Long>, Boolean, Boolean>(singleQueryWorkTask, Boolean.FALSE, Boolean.FALSE));
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("Complete Do Task Job on [%sms]: multipleSQLQuery=%s, outputDynEntity=%s, taskResult=%s", this.getTaskExecutionTime(), this.multipleSQLQuery, this.outputDynEntity, this.taskResult));
                    }
                    Long l = (Long)this.taskResult;
                    return l;
                }
                finally {
                    dLock.unlock();
                }
            }
            this.onException(new KDBizException(new ErrorCode("fi.pa.common.engine.PADataExtractingTask", "BusinessTask TryLock error!"), new Object[0]));
        }
        return (Long)this.taskResult;
    }

    @Override
    protected Long processTaskResult(int taskIndex, Callable<Long> task, Object taskResult) {
        AbstractOlapDataQueryTask abstractOlapDataQueryTask = this;
        abstractOlapDataQueryTask.taskResult = (Long)abstractOlapDataQueryTask.taskResult + (taskResult != null ? (Long)taskResult : 0L);
        return abstractOlapDataQueryTask.taskResult;
    }

    @Override
    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
        this.sqlBuilder.close();
        if (this.taskMeta instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta FAFWorkTaskMeta2 = (FAFWorkTaskMeta)this.taskMeta;
            DataExtractingDTO dataExtractingDTO = FAFWorkTaskMeta2.getDataExtractingDTO();
            Long analysisModelId = FAFWorkTaskMeta2.getAnalysisModelId();
            if (isCancelled || withError) {
                logger.info("start deleting historical data when failed fetching data");
                QFilter rollBackFilter = new QFilter("del", "=", (Object)Long.valueOf(this.taskKey.toString()));
                rollBackFilter.and(dataExtractingDTO.getOrgQFilter(dataExtractingDTO.getOrgDimNumber()));
                rollBackFilter.and(dataExtractingDTO.getPeriodQFilter(dataExtractingDTO.getPeriodDimNumber()));
                if (this.outputDynEntity.getProperty("importbatch") != null) {
                    logger.info("rollBack data, add filter which importbatch is empty");
                    rollBackFilter.and(new QFilter("importbatch", "=", (Object)" "));
                }
                int deleteSize = DeleteServiceHelper.delete((String)this.outputDynEntity.getName(), (QFilter[])rollBackFilter.toArray());
                this.updateTaskStatistics(-deleteSize, -deleteSize, 0);
                if (this.exception != null) {
                    String stackTrace = ExceptionUtils.getStackTrace((Throwable)this.exception);
                    logger.error("traceId :" + RequestContext.getOrCreate().getTraceId() + "StackTrace :" + stackTrace);
                }
                this.waitingTaskQueue.clear();
            } else {
                logger.info("start deleting historical data when successful fetching data");
                QFilter deleteFilter = new QFilter("del", "!=", (Object)Long.valueOf(this.taskKey.toString()));
                deleteFilter.and(dataExtractingDTO.getOrgQFilter(dataExtractingDTO.getOrgDimNumber()));
                deleteFilter.and(dataExtractingDTO.getPeriodQFilter(dataExtractingDTO.getPeriodDimNumber()));
                if (this.outputDynEntity.getProperty("importbatch") != null) {
                    logger.info("have importbatch field, add filter which importbatch is empty");
                    deleteFilter.and(new QFilter("importbatch", "=", (Object)" "));
                } else {
                    logger.info(String.format("%s does not have importbatch field", this.outputDynEntity.getName()));
                }
                DeleteServiceHelper.delete((String)this.outputDynEntity.getName(), (QFilter[])new QFilter[]{deleteFilter});
            }
        }
    }

    protected Callable<Long> createOlapQuerySubTask(String taskTypeName, final OlapSQLBuilder currentSqlBuilder) {
        return new IDataAbstractWorkTask<Long>((Object)taskTypeName, this.subTaskExceptionListener){
            OlapSQLBuilder _subTaskSqlBuilder;
            {
                super(taskKey, exceptionListener);
                this._subTaskSqlBuilder = currentSqlBuilder;
            }

            @Override
            protected Long doTaskJob() {
                if (this._subTaskSqlBuilder == null) {
                    return 0L;
                }
                return KdOlapServerHelper.queryDataToReader(this._subTaskSqlBuilder, AbstractOlapDataQueryTask.this.outputDynEntity, (selectCommandInfo, dataReader) -> AbstractOlapDataQueryTask.this.processOlapQueryReader(this._subTaskSqlBuilder, (SelectCommandInfo)selectCommandInfo, (OlapDataReader)dataReader));
            }
        };
    }

    @Override
    public ThreeValueTuple<Callable<Long>, Boolean, Boolean> doGetNextSubTask() {
        OlapSQLBuilder curSqlBuilder = this.sqlBuilderIterator.next();
        if (curSqlBuilder == null) {
            return null;
        }
        return new ThreeValueTuple<Callable<Long>, Boolean, Boolean>(this.createOlapQuerySubTask("OLAPInnerMultiQueryTask", curSqlBuilder), Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public boolean hasSubTask() {
        return this.multipleSQLQuery && this.sqlBuilderIterator.hasNext() && !this.isCancelled();
    }

    public OlapSQLBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public final void setSqlBuilder(OlapSQLBuilder sqlBuilder) {
        if (sqlBuilder == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u6570\u636e\u67e5\u8be2\u6784\u5efa\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AbstractOlapDataQueryTask_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        this.selectDimensionMap = sqlBuilder.getSelectDimensionMap();
        this.multipleSQLQuery = sqlBuilder instanceof Iterator;
        if (this.multipleSQLQuery) {
            this.sqlBuilderIterator = (Iterator)((Object)sqlBuilder);
            this.multipleSQLQuery = this.sqlBuilderIterator.hasNext();
        } else {
            this.sqlBuilderIterator = null;
        }
    }

    public void setTaskMeta(IWorkTaskTransLog<Long> taskMeta) {
        this.taskMeta = taskMeta;
    }
}

