/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.ORM;
import kd.macc.faf.constant.FAFSystemParameters;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.engine.task.impl.olap.FAFSimpleOlapDataSyncTask;
import kd.macc.faf.engine.transformer.ColumnValueWritePosTransformer;
import kd.macc.faf.olap.IColumnValueConverter;
import kd.macc.faf.olap.OlapSQLBuilder;

public class FAFOlapDataSyncTask
extends FAFSimpleOlapDataSyncTask {
    private static final Log logger = LogFactory.getLog(FAFOlapDataSyncTask.class);
    private IColumnValueConverter<Object[], IDataEntityProperty> columnWritePosLookupService;
    private Map<List<String>, String> transformFieldIndexMap;
    private Map<String, Object> baseDataFieldDefaultMap;

    public FAFOlapDataSyncTask(long taskId, Long version, OlapSQLBuilder sqlBuilder, String outputTargetEntityName, Map<List<String>, String> transformFieldIndexMap, Map<String, String> fieldMappings, boolean allowDimNull, boolean ignoreDimNull, int totalStatisticsPoints, Map<String, Object> manuallyAddFieldMap, Map<String, Map<String, Long>> dimEntityNumberTransIdMap, List<MappingRelationShipDTO> mappingRelationShipDTOs) {
        super(taskId, version, sqlBuilder, outputTargetEntityName, fieldMappings, allowDimNull, ignoreDimNull, null, totalStatisticsPoints, manuallyAddFieldMap, dimEntityNumberTransIdMap, mappingRelationShipDTOs);
        this.transformFieldIndexMap = transformFieldIndexMap;
    }

    @Override
    protected void initializeTaskJob() {
        super.initializeTaskJob();
        if (this.columnWritePosLookupService == null) {
            List<Integer> srcFieldValueReadIndexs;
            logger.info("columnWritePosLookupService is null, need to create: transformFieldIndexMap=" + this.transformFieldIndexMap);
            if (this.measureTypeFieldReadIndex == null) {
                srcFieldValueReadIndexs = Collections.emptyList();
            } else {
                srcFieldValueReadIndexs = new ArrayList(this.measureTypeFieldReadIndex.length);
                for (int idx : this.measureTypeFieldReadIndex) {
                    srcFieldValueReadIndexs.add(idx);
                }
            }
            this.columnWritePosLookupService = ColumnValueWritePosTransformer.buildMulToSingleFieldTransformer(this.getOutputTargetEntityName(), srcFieldValueReadIndexs, this.transformFieldIndexMap);
        }
        RowMeta rowMeta = ORM.create().createRowMeta(this.outputDynEntity.getName(), String.join((CharSequence)",", this.outputDynEntity.getAllFields().keySet()));
        Map allFields = this.outputDynEntity.getAllFields();
        this.baseDataFieldDefaultMap = new HashMap<String, Object>(allFields.size());
        for (Map.Entry entry : allFields.entrySet()) {
            if (!(entry.getValue() instanceof BasedataProp)) continue;
            if (DataType.StringType.equals((Object)rowMeta.getField((String)entry.getKey()).getDataType())) {
                this.baseDataFieldDefaultMap.put((String)entry.getKey(), " ");
                continue;
            }
            if (!DataType.LongType.equals((Object)rowMeta.getField((String)entry.getKey()).getDataType())) continue;
            this.baseDataFieldDefaultMap.put((String)entry.getKey(), 0L);
        }
    }

    @Override
    protected long processOlapQueryReader(OlapSQLBuilder olapSQLBuilder, SelectCommandInfo selectCommandInfo, OlapDataReader dataReader) {
        Object[] measureValue = new Object[1];
        olapSQLBuilder.clean();
        selectCommandInfo.getDimensions().clear();
        selectCommandInfo.getFilter().clear();
        selectCommandInfo.getMeasures().clear();
        int batchSize = FAFSystemParameters.getTaskDBWriteBatchSize() * this.transformFieldIndexMap.size();
        HashMap<String, Integer> writeDataIndex = new HashMap<String, Integer>(olapSQLBuilder.getDimCombCnt());
        DynamicObject[] writeDataBuffer = new DynamicObject[olapSQLBuilder.getDimCombCnt()];
        Object[] rowBuffer = new Object[dataReader.getFieldCount()];
        int fetchCnt = 0;
        int skipCnt = 0;
        int lastBufferWriteIndex = -1;
        boolean active = true;
        long totalFetchCnt = 0L;
        while (active && dataReader.next()) {
            dataReader.getValues(rowBuffer);
            ++fetchCnt;
            if (!this.fetchMeasureValue(0, rowBuffer, measureValue)) {
                ++skipCnt;
                continue;
            }
            int currentWriteIndex = this.processRowKeyValues(rowBuffer, writeDataIndex, writeDataBuffer, lastBufferWriteIndex + 1);
            if (currentWriteIndex > lastBufferWriteIndex) {
                if (writeDataBuffer[currentWriteIndex] == null) {
                    --fetchCnt;
                    continue;
                }
                this.processManuallyAndRelationValues(writeDataBuffer[currentWriteIndex]);
                this.relationShipWritePosLookupService.convert(writeDataBuffer[currentWriteIndex]);
                lastBufferWriteIndex = currentWriteIndex;
            }
            if (measureValue[0] != null) {
                this.processMeasureValues(measureValue, rowBuffer, writeDataBuffer[currentWriteIndex]);
            }
            if (fetchCnt < batchSize) continue;
            this.updateTaskStatistics(fetchCnt, 0, skipCnt);
            totalFetchCnt += (long)fetchCnt;
            fetchCnt = 0;
            skipCnt = 0;
            active = !this.isCancelled();
        }
        writeDataIndex.clear();
        this.saveBufferRecords(fetchCnt, skipCnt, Arrays.copyOf(writeDataBuffer, lastBufferWriteIndex + 1));
        writeDataBuffer = null;
        return totalFetchCnt += (long)fetchCnt;
    }

    @Override
    protected void processMeasureValues(Object measureValue, Object[] srcRowBuffer, DynamicObject outputTarget) {
        IDataEntityProperty valueProp = this.columnWritePosLookupService.defaultConvert(srcRowBuffer, new Object[0]);
        if (valueProp != null) {
            valueProp.setValueFast((Object)outputTarget, measureValue);
        } else {
            logger.error(String.format("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ea6\u91cf\u5b57\u6bb5\u5c5e\u6027: measureValue=%s, srcRowBuffer=%s", measureValue, Arrays.deepToString(srcRowBuffer)));
        }
    }

    protected int processRowKeyValues(Object[] rowBuffer, Map<String, Integer> writeDataIndex, DynamicObject[] writeDataBuffer, int lastBufferWriteIndex) {
        String rowKey = this.buildRowKey(rowBuffer, this.dimReadIndex).toString();
        Integer dynIndex = null;
        DynamicObject dynRow = null;
        dynIndex = writeDataIndex.get(rowKey);
        if (dynIndex == null) {
            dynRow = this.newDefaultDynamicObject(this.outputDynEntity);
            int i = 0;
            for (int dimIndex : this.dimReadIndex) {
                Long dimIds = (Long)((Map)this.numberTransIdIndexMap.get(dimIndex)).get(rowBuffer[dimIndex].toString());
                this.outputDimDynProps[i++].setValueFast((Object)dynRow, (Object)dimIds);
            }
            dynIndex = lastBufferWriteIndex;
            writeDataBuffer[dynIndex.intValue()] = dynRow;
            writeDataIndex.put(rowKey, dynIndex);
        }
        return dynIndex;
    }

    public DynamicObject newDefaultDynamicObject(MainEntityType outputDynEntity) {
        DynamicObject dynRow = new DynamicObject((DynamicObjectType)outputDynEntity);
        for (Map.Entry<String, Object> entry : this.baseDataFieldDefaultMap.entrySet()) {
            dynRow.set(entry.getKey(), entry.getValue());
        }
        return dynRow;
    }

    public IColumnValueConverter<Object[], IDataEntityProperty> getColumnWritePosLookupService() {
        return this.columnWritePosLookupService;
    }

    public void setColumnWritePosLookupService(IColumnValueConverter<Object[], IDataEntityProperty> columnWritePosLookupService) {
        this.columnWritePosLookupService = columnWritePosLookupService;
    }

    public Map<List<String>, String> getTransformFieldIndexMap() {
        return this.transformFieldIndexMap;
    }

    public void setTransformFieldIndexMap(Map<List<String>, String> transformFieldIndexMap) {
        this.transformFieldIndexMap = transformFieldIndexMap;
    }
}

