/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.impl.olap;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.engine.task.impl.olap.AbstractOlapDataQueryTask;
import kd.macc.faf.engine.transformer.RelationShipWritePosTransformer;
import kd.macc.faf.enums.FAFOlapSelectTypeEnum;
import kd.macc.faf.olap.OlapSQLBuilder;
import kd.macc.faf.util.IDataValueUtil;

public class FAFSimpleOlapDataSyncTask
extends AbstractOlapDataQueryTask {
    private static final Log logger = LogFactory.getLog(FAFSimpleOlapDataSyncTask.class);
    protected int[] dimReadIndex;
    protected int dimRowKeyReadStartIndex;
    protected int[] measureTypeFieldReadIndex;
    protected IDataEntityProperty[] outputDimDynProps;
    protected IDataEntityProperty measureValueProp;
    protected IDataEntityProperty[] needTransformFieldProp;
    protected boolean allowDimNull;
    protected boolean ignoreDimNull;
    protected String transformField;
    protected Map<String, Map<String, Long>> dimEntityNumberTransIdMap;
    protected Map<Integer, Map<String, Long>> numberTransIdIndexMap;
    protected List<MappingRelationShipDTO> mappingRelationShipDTOs;
    protected RelationShipWritePosTransformer relationShipWritePosLookupService;
    static final int[] DimTypes = new int[]{FAFOlapSelectTypeEnum.FIX_ROWKEY_TYPE.getIntCode(), FAFOlapSelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode()};

    public FAFSimpleOlapDataSyncTask(long taskId, Long version, OlapSQLBuilder sqlBuilder, String outputTargetEntityName, Map<String, String> fieldMappings, boolean allowDimNull, boolean ignoreDimNull, String transformField, int totalStatisticsPoints, Map<String, Object> manuallyAddFieldMap, Map<String, Map<String, Long>> dimEntityNumberTransIdMap, List<MappingRelationShipDTO> mappingRelationShipDTOs) {
        super(Long.valueOf(taskId), version, sqlBuilder, fieldMappings, manuallyAddFieldMap);
        this.allowDimNull = allowDimNull;
        this.ignoreDimNull = ignoreDimNull;
        this.version = version;
        this.transformField = transformField;
        this.taskResult = 0L;
        this.totalStatisticsPoints = totalStatisticsPoints;
        this.dimEntityNumberTransIdMap = dimEntityNumberTransIdMap;
        this.mappingRelationShipDTOs = mappingRelationShipDTOs;
        this.outputDynEntity = EntityMetadataCache.getDataEntityType((String)outputTargetEntityName);
    }

    @Override
    public String toString() {
        return "FSASimpleOlapDataSyncTask [outputTargetEntityName=" + this.outputDynEntity.getName() + ", dimReadIndex=" + Arrays.toString(this.dimReadIndex) + ", measureTypeReadIndex=" + Arrays.toString(this.measureTypeFieldReadIndex) + ", outputDimDynProps=" + Arrays.toString(this.outputDimDynProps) + ", measureValueProp=" + this.measureValueProp + "]";
    }

    @Override
    protected void initializeTaskJob() {
        int j;
        LinkedList<DynamicProperty> dimPropList = new LinkedList<DynamicProperty>();
        LinkedList<Integer> dimReadIndexList = new LinkedList<Integer>();
        LinkedList<Integer> measureTypeReadIndexList = new LinkedList<Integer>();
        int i = 1;
        if (StringUtils.isNotEmpty((String)this.transformField)) {
            this.measureValueProp = this.outputDynEntity.getProperty(this.transformField);
        }
        List transTypeDImFields = (List)this.selectDimensionMap.get(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode());
        for (j = 0; j < transTypeDImFields.size(); ++j) {
            measureTypeReadIndexList.add(i);
            ++i;
        }
        this.numberTransIdIndexMap = new HashMap<Integer, Map<String, Long>>(this.dimEntityNumberTransIdMap.size());
        j = 0;
        for (int dimType : DimTypes) {
            for (String rowKeyTypeDimField : (List)this.selectDimensionMap.get(dimType)) {
                dimReadIndexList.add(i);
                this.numberTransIdIndexMap.put(i, this.dimEntityNumberTransIdMap.get(rowKeyTypeDimField));
                dimPropList.add(this.outputDynEntity.getProperty((String)this.fieldMappings.get(rowKeyTypeDimField)));
                ++i;
            }
        }
        Object object = this.manuallyAddFieldMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry manuallyField = (Map.Entry)object.next();
            dimPropList.add(this.outputDynEntity.getProperty((String)manuallyField.getKey()));
        }
        this.outputDimDynProps = dimPropList.toArray(new IDataEntityProperty[0]);
        this.dimReadIndex = IDataValueUtil.convertIntListToArray(dimReadIndexList, -1);
        this.dimRowKeyReadStartIndex = this.dimReadIndex[0];
        this.measureTypeFieldReadIndex = IDataValueUtil.convertIntListToArray(measureTypeReadIndexList, -1);
        this.relationShipWritePosLookupService = RelationShipWritePosTransformer.buildRelationShipWritePosTransformer(this.getOutputTargetEntityName(), this.mappingRelationShipDTOs);
    }

    protected boolean fetchMeasureValue(int fetchIndex, Object[] srcRowBuffer, Object[] measureValue) {
        measureValue[0] = srcRowBuffer[fetchIndex];
        if (measureValue[0] == null) {
            if (this.ignoreDimNull) {
                return false;
            }
            if (!this.allowDimNull) {
                measureValue[0] = 0L;
            }
        } else if (!(measureValue[0] instanceof Number)) {
            try {
                measureValue[0] = new BigDecimal(measureValue[0].toString());
            }
            catch (Exception ex) {
                if (this.ignoreDimNull) {
                    return false;
                }
                measureValue[0] = this.allowDimNull ? null : Long.valueOf(0L);
            }
        }
        return true;
    }

    @Override
    protected int calcTaskTotalStatisticsPoints() {
        return this.totalStatisticsPoints;
    }

    protected void saveBufferRecords(int fetchCnt, int skipCnt, Object[] srcDatas) {
        try {
            int writeCnt = BusinessDataWriter.save((IDataEntityType)this.outputDynEntity, (Object[])srcDatas).length;
            this.updateTaskStatistics(fetchCnt, writeCnt, skipCnt);
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    @Override
    protected long processOlapQueryReader(OlapSQLBuilder olapSQLBuilder, SelectCommandInfo selectCommandInfo, OlapDataReader dataReader) {
        return 0L;
    }

    protected StringBuilder buildRowKey(Object[] rowBuffer, int[] dimReadIndexs) {
        StringBuilder rowKeyStr = new StringBuilder(20 * rowBuffer.length);
        for (int dimIndex : dimReadIndexs) {
            rowKeyStr.append(rowBuffer[dimIndex]).append('|');
        }
        return rowKeyStr;
    }

    protected void processMeasureValues(Object measureValue, Object[] srcRowBuffer, DynamicObject outputTarget) {
        this.measureValueProp.setValueFast((Object)outputTarget, measureValue);
    }

    protected void processManuallyAndRelationValues(DynamicObject outputTarget) {
        if (this.manuallyAddFieldMap != null) {
            for (Map.Entry manuallyAddField : this.manuallyAddFieldMap.entrySet()) {
                outputTarget.set(((String)manuallyAddField.getKey()).toLowerCase(), manuallyAddField.getValue());
            }
        }
        outputTarget.set("del", (Object)this.taskKey);
    }

    public String getOutputTargetEntityName() {
        return this.outputDynEntity != null ? this.outputDynEntity.getName() : null;
    }

    public void setOutputTargetEntityName(String outputTargetEntityName) {
        this.outputDynEntity = EntityMetadataCache.getDataEntityType((String)outputTargetEntityName);
    }

    public IDataEntityProperty[] getOutputDimDynProps() {
        return this.outputDimDynProps;
    }

    public void setOutputDimDynProps(IDataEntityProperty[] outputDimDynProps) {
        this.outputDimDynProps = outputDimDynProps;
    }

    public int[] getDimReadIndex() {
        return this.dimReadIndex;
    }

    public void setDimReadIndex(int[] dimReadIndex) {
        this.dimReadIndex = dimReadIndex;
    }

    public MainEntityType getOutputDynEntity() {
        return this.outputDynEntity;
    }

    public boolean isAllowDimNull() {
        return this.allowDimNull;
    }

    public void setAllowDimNull(boolean allowDimNull) {
        this.allowDimNull = allowDimNull;
    }

    public boolean isIgnoreDimNull() {
        return this.ignoreDimNull;
    }

    public void setIgnoreDimNull(boolean ignoreDimNull) {
        this.ignoreDimNull = ignoreDimNull;
    }
}

