/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.task.status;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.engine.task.status.AbstractIDataWorkTaskStatusConsumer;
import kd.macc.faf.event.IWorkTaskStatusEvent;

public class FAFWorkTaskStatusConsumer
extends AbstractIDataWorkTaskStatusConsumer {
    private static final Map<String, FAFWorkTaskStatusConsumer> instanceMap = new ConcurrentHashMap<String, FAFWorkTaskStatusConsumer>();
    private static FAFWorkTaskStatusConsumer instance;
    private static String centerId;

    @Override
    protected IDataCacheModule getCacheModel() {
        return IDataCacheModule.FAF;
    }

    public static FAFWorkTaskStatusConsumer getInstance() {
        centerId = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()).getAccountId();
        FAFWorkTaskStatusConsumer consumer = instanceMap.get(centerId);
        if (consumer == null) {
            consumer = new FAFWorkTaskStatusConsumer();
            instanceMap.put(centerId, consumer);
            instance = consumer;
        }
        if (consumer.processPipe == null) {
            throw new KDBizException("PAWorkTaskStatusConsumer PipeStream is null");
        }
        return consumer;
    }

    public void updateCachedWorkTaskStatusEvent(Object taskId, String message) {
        IWorkTaskStatusEvent statusEvent = this.getCachedWorkTaskStatusEvent(taskId);
        if (statusEvent != null) {
            statusEvent.setNeedMergeStatus(false);
            statusEvent.updateStatusMessage(message);
            try {
                instance.updateTaskStatus(statusEvent);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    static {
        centerId = null;
    }
}

