/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.macc.faf.olap.IColumnValueConverter;

public class ColumnValueWritePosTransformer
implements IColumnValueConverter<Object[], IDataEntityProperty> {
    private static final long serialVersionUID = -2804203355831557193L;
    private Map<String, IDataEntityProperty> outputDynPropIndexMap;
    private ArrayList<Integer>[] srcFieldValueReadIndexs;

    protected ColumnValueWritePosTransformer() {
    }

    public static ColumnValueWritePosTransformer buildMulToSingleFieldTransformer(String outputTargetEntityNumber, Map<Integer, List<Integer>> srcFieldValueReadIndexs, Map<List<String>, String> transforFieldIndexMap) {
        if (srcFieldValueReadIndexs == null || srcFieldValueReadIndexs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u6e90\u5b57\u6bb5\u503c\u7684\u5b57\u6bb5\u8bfb\u53d6\u7d22\u5f15\u4f4d\u7f6eMap\u4e0d\u80fd\u4e3aNull\u6216\u7a7a", (String)"ColumnValueWritePosTransformer_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        ColumnValueWritePosTransformer transformer = new ColumnValueWritePosTransformer();
        MainEntityType outputDynEntity = EntityMetadataCache.getDataEntityType((String)outputTargetEntityNumber);
        if (transforFieldIndexMap != null && !transforFieldIndexMap.isEmpty()) {
            LinkedHashMap<String, IDataEntityProperty> outputDynPropIndexMap = new LinkedHashMap<String, IDataEntityProperty>(transforFieldIndexMap.size());
            transformer.outputDynPropIndexMap = outputDynPropIndexMap;
            for (Map.Entry<List<String>, String> en : transforFieldIndexMap.entrySet()) {
                List<String> srcKeyList = en.getKey();
                if (srcKeyList == null || srcKeyList.isEmpty()) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (String k : srcKeyList) {
                    stringBuilder.append(k).append(';');
                }
                outputDynPropIndexMap.put(stringBuilder.toString(), (IDataEntityProperty)outputDynEntity.getProperty(en.getValue()));
            }
        } else {
            transformer.outputDynPropIndexMap = new LinkedHashMap<String, IDataEntityProperty>(0);
        }
        int maxCategoryIdx = 0;
        for (Integer n : srcFieldValueReadIndexs.keySet()) {
            maxCategoryIdx = Math.max(maxCategoryIdx, n);
        }
        transformer.srcFieldValueReadIndexs = new ArrayList[maxCategoryIdx + 1];
        for (Map.Entry entry : srcFieldValueReadIndexs.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            transformer.srcFieldValueReadIndexs[((Integer)entry.getKey()).intValue()] = new ArrayList((Collection)entry.getValue());
        }
        return transformer;
    }

    public static ColumnValueWritePosTransformer buildMulToSingleFieldTransformer(String outputTargetEntityNumber, List<Integer> srcFieldValueReadIndex, Map<List<String>, String> transforFieldIndexMap) {
        if (srcFieldValueReadIndex == null || srcFieldValueReadIndex.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u6e90\u5b57\u6bb5\u503c\u7684\u5b57\u6bb5\u8bfb\u53d6\u7d22\u5f15\u4f4d\u7f6eList\u4e0d\u80fd\u4e3aNull\u6216\u7a7a", (String)"ColumnValueWritePosTransformer_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        HashMap<Integer, List<Integer>> srcFieldValueReadIndexMap = new HashMap<Integer, List<Integer>>();
        srcFieldValueReadIndexMap.put(0, srcFieldValueReadIndex);
        return ColumnValueWritePosTransformer.buildMulToSingleFieldTransformer(outputTargetEntityNumber, srcFieldValueReadIndexMap, transforFieldIndexMap);
    }

    @Override
    public IDataEntityProperty convert(int index, Object[] srcRowValue, Object ... controlParam) {
        ArrayList<Integer> readIdxList = this.srcFieldValueReadIndexs[index];
        StringBuilder keyBuf = new StringBuilder();
        Iterator iterator = readIdxList.iterator();
        while (iterator.hasNext()) {
            int readIdx = (Integer)iterator.next();
            keyBuf.append(srcRowValue[readIdx]).append(';');
        }
        return this.outputDynPropIndexMap.get(keyBuf.toString());
    }

    @Override
    public int getCategoryCnt(int index) {
        return this.srcFieldValueReadIndexs[index] == null ? 0 : this.srcFieldValueReadIndexs[index].size();
    }
}

