/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.engine.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.MappingRelationShipDTO;

public class RelationShipWritePosTransformer {
    private Map<String, Object>[] outputDynPropIndexMap;
    private ArrayList<String>[] srcFieldValueReadField;
    private IDataEntityProperty[] entityProperties;
    private Map<String, DataType> filedClassMapping;

    public static RelationShipWritePosTransformer buildRelationShipWritePosTransformer(String outputTargetEntityNumber, List<MappingRelationShipDTO> mappingRelationShipDTOs) {
        if (CollectionUtils.isEmpty(mappingRelationShipDTOs)) {
            return null;
        }
        RelationShipWritePosTransformer transformer = new RelationShipWritePosTransformer();
        MainEntityType outputDynEntity = EntityMetadataCache.getDataEntityType((String)outputTargetEntityNumber);
        LinkedHashMap[] outputDynPropIndexMap = new LinkedHashMap[mappingRelationShipDTOs.size()];
        IDataEntityProperty[] entityProperties = new IDataEntityProperty[mappingRelationShipDTOs.size()];
        transformer.outputDynPropIndexMap = outputDynPropIndexMap;
        transformer.entityProperties = entityProperties;
        transformer.srcFieldValueReadField = new ArrayList[mappingRelationShipDTOs.size()];
        HashMap<String, DataType> filedClassMapping = new HashMap<String, DataType>(10);
        transformer.filedClassMapping = filedClassMapping;
        HashSet fieldSet = new HashSet(10);
        for (int i = 0; i < mappingRelationShipDTOs.size(); ++i) {
            MappingRelationShipDTO relationShipDTO = mappingRelationShipDTOs.get(i);
            if (relationShipDTO == null) continue;
            Map<List<Object>, Object> dimMembersIdMapping = relationShipDTO.getDimMembersIdMapping();
            LinkedHashMap<String, Object> outputPropIndexMap = new LinkedHashMap<String, Object>(dimMembersIdMapping.size());
            entityProperties[i] = outputDynEntity.getProperty(relationShipDTO.getTargetDimensionNumber());
            for (Map.Entry<List<Object>, Object> listObjectEntry : dimMembersIdMapping.entrySet()) {
                StringBuilder keyBuf = new StringBuilder();
                for (Object object : listObjectEntry.getKey()) {
                    keyBuf.append(object).append(";");
                }
                outputPropIndexMap.put(keyBuf.toString(), listObjectEntry.getValue());
            }
            outputDynPropIndexMap[i] = outputPropIndexMap;
            ArrayList<String> srcFieldValueReadField = new ArrayList<String>(relationShipDTO.getSourceDimensionNumbers().size());
            srcFieldValueReadField.addAll(relationShipDTO.getSourceDimensionNumbers());
            fieldSet.addAll(srcFieldValueReadField);
            transformer.srcFieldValueReadField[i] = srcFieldValueReadField;
        }
        RowMeta rowMeta = ORM.create().createRowMeta(outputTargetEntityNumber, String.join((CharSequence)",", fieldSet));
        for (String field : fieldSet) {
            filedClassMapping.put(field, rowMeta.getField(field).getDataType());
        }
        return transformer;
    }

    public boolean convert(DynamicObject outputTarget) {
        boolean result = true;
        for (int i = 0; i < this.entityProperties.length; ++i) {
            IDataEntityProperty convert = this.entityProperties[i];
            ArrayList<String> readFieldList = this.srcFieldValueReadField[i];
            if (CollectionUtils.isEmpty(readFieldList)) {
                result = false;
            }
            StringBuilder keyBuf = new StringBuilder();
            for (String readField : readFieldList) {
                if (outputTarget.get(readField) == null) {
                    if (DataType.LongType.equals((Object)this.filedClassMapping.get(readField)) || DataType.IntegerType.equals((Object)this.filedClassMapping.get(readField))) {
                        keyBuf.append("0").append(';');
                        continue;
                    }
                    keyBuf.append(';');
                    continue;
                }
                keyBuf.append(outputTarget.get(readField)).append(';');
            }
            Object value = this.outputDynPropIndexMap[i].get(keyBuf.toString());
            if (value == null || StringUtils.isEmpty((String)value.toString())) {
                result = false;
            }
            convert.setValueFast((Object)outputTarget, value);
        }
        return result;
    }
}

