/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.enums;

import kd.bos.exception.KDBizException;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;

public enum DataSourceTypeEnum {
    BIZVOUCHER("1", "ai_bizvoucher"),
    VOUCHER("2", "gl_voucher"),
    TEMPPORARY("3", "pa_dsanalysisdata"),
    GLBALANCE("4", "gl_balance"),
    BCM("5", "bcm"),
    EPM("6", "epm"),
    INV_PERIODBALANCE("7", "im_inv_periodbalance");

    private final String code;
    private final String formId;

    private DataSourceTypeEnum(String code, String formId) {
        this.code = code;
        this.formId = formId;
    }

    public static DataSourceTypeEnum getEnum(String code) {
        for (DataSourceTypeEnum value : DataSourceTypeEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        throw new KDBizException("DataSourceTypeEnum: " + code + " not exsit");
    }

    public static ImportSystemSourceTypeEnum transDataSourceEnumToImportEnum(DataSourceTypeEnum dataSourceTypeEnum) {
        if (dataSourceTypeEnum != null) {
            switch (dataSourceTypeEnum) {
                case BCM: {
                    return ImportSystemSourceTypeEnum.BCM;
                }
                case EPM: {
                    return ImportSystemSourceTypeEnum.EPM;
                }
            }
        }
        return null;
    }

    public static OlapFromServiceEnum transImportEnumToOlapEnum(DataSourceTypeEnum dataSourceTypeEnum) {
        if (dataSourceTypeEnum != null) {
            switch (dataSourceTypeEnum) {
                case BCM: {
                    return OlapFromServiceEnum.BCM;
                }
                case EPM: {
                    return OlapFromServiceEnum.EPM;
                }
            }
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public ImportSystemSourceTypeEnum getImportSystemSourceTypeEnum() {
        switch (this) {
            case BCM: {
                return ImportSystemSourceTypeEnum.BCM;
            }
            case EPM: {
                return ImportSystemSourceTypeEnum.EPM;
            }
            case BIZVOUCHER: {
                return ImportSystemSourceTypeEnum.ASSTACT;
            }
        }
        return null;
    }

    public String getFormId() {
        return this.formId;
    }
}

