/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.enums;

import kd.bos.exception.KDBizException;
import kd.macc.faf.enums.OlapFromServiceEnum;

public enum ImportSystemSourceTypeEnum {
    NEW("0"),
    ASSTACT("1"),
    BCM("2"),
    EPM("3");

    private final String code;

    private ImportSystemSourceTypeEnum(String code) {
        this.code = code;
    }

    public static ImportSystemSourceTypeEnum getEnumByCode(String code) {
        for (ImportSystemSourceTypeEnum enums : ImportSystemSourceTypeEnum.values()) {
            if (!enums.getCode().equals(code)) continue;
            return enums;
        }
        throw new KDBizException("not exit ImportDimensionSystemSourceTypeEnum by " + code);
    }

    public static OlapFromServiceEnum transImportEnumToOlapEnum(ImportSystemSourceTypeEnum importSystemSourceTypeEnum) {
        switch (importSystemSourceTypeEnum) {
            case BCM: {
                return OlapFromServiceEnum.BCM;
            }
            case EPM: {
                return OlapFromServiceEnum.EPM;
            }
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getDimmappingTable() {
        switch (this) {
            case BCM: {
                return "faf_cmdimmapping";
            }
            case EPM: {
                return "faf_epmdimmapping";
            }
            case ASSTACT: {
                return "pa_dimension";
            }
        }
        throw new KDBizException("not support ImportSystemSourceTypeEnum type");
    }

    public String getSelectFields() {
        switch (this) {
            case BCM: {
                return "dimension,cmmodel immodel,cmdimension imdimension,cmdimnumber imdimnumber,cmdimname imdimname,membermodel";
            }
            case EPM: {
                return "dimension,epmmodel immodel,epmdimension imdimension,epmdimnumber imdimnumber,epmdimname imdimname,membermodel";
            }
            case ASSTACT: {
                return "id dimension,asstacttype.flexfiled,asstacttype.name";
            }
        }
        throw new KDBizException("not support ImportSystemSourceTypeEnum type");
    }

    public String getMeasureMappingTable() {
        switch (this) {
            case BCM: {
                return "faf_cmmeasuremapping";
            }
            case EPM: {
                return "faf_epmmeasuremapping";
            }
        }
        throw new KDBizException("not support ImportSystemSourceTypeEnum type");
    }

    public String getMeasureMappingSelectFields() {
        switch (this) {
            case BCM: {
                return "measure,cmmodel immodel,entryentity.cmdimension entryimdimension,entryentity.cmdimnumber entryimdimnumber,entryentity.cmdimname entryimdimname,entryentity.membermodel entrymembermodel,entryentity.memberid entrymemberid,entryentity.membernumber entrymembernumber,entryentity.membername entrymembername";
            }
            case EPM: {
                return "measure,epmmodel immodel,entryentity.epmdimension entryimdimension,entryentity.epmdimnumber entryimdimnumber,entryentity.epmdimname entryimdimname,entryentity.membermodel entrymembermodel,entryentity.memberid entrymemberid,entryentity.membernumber entrymembernumber,entryentity.membername entrymembername";
            }
        }
        throw new KDBizException("not support ImportSystemSourceTypeEnum type");
    }
}

