/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.dto;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.fas.dto.FAFPeriodDTO;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;

public class FAFComparisonDTO {
    private static final String ALGO_KEY = FAFComparisonDTO.class.getName();
    private List<FAFComparisonEnum> comparisonList;
    private Set<FAFComparisonMetaEnum> metaSet;

    private FAFComparisonDTO() {
    }

    public static FAFComparisonDTO quickCreate(String comparisonType) {
        return FAFComparisonDTO.create(Collections.singletonMap("comparisonType", comparisonType));
    }

    public static String parseComparisonType(Map<String, Object> comparison) {
        try {
            return (String)comparison.get("comparisonType");
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"comparison \u5165\u53c2\u9519\u8bef!", (String)"FAFComparisonDTO_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
    }

    public static FAFComparisonDTO create(Map<String, Object> comparison) {
        try {
            String comparisonType = (String)comparison.get("comparisonType");
            return FAFComparisonDTO.create(comparisonType);
        }
        catch (KDBizException kex) {
            throw kex;
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"comparison \u5165\u53c2\u9519\u8bef!", (String)"FAFComparisonDTO_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
    }

    private static FAFComparisonDTO create(String comparisonType) {
        if (StringUtils.isEmpty((CharSequence)comparisonType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFComparisonDTO_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        FAFComparisonDTO dto = new FAFComparisonDTO();
        String[] split = comparisonType.split(",");
        List<FAFComparisonEnum> comparisonEnumList = Stream.of(split).filter(StringUtils::isNotEmpty).map(FAFComparisonEnum::getEnum).collect(Collectors.toList());
        dto.setComparisonList(comparisonEnumList);
        Set<FAFComparisonMetaEnum> metaSet = dto.getComparisonList().stream().filter(FAFComparisonEnum::needComparison).map(FAFComparisonEnum::getMetaEnum).collect(Collectors.toSet());
        dto.setMetaSet(metaSet);
        return dto;
    }

    public List<FAFComparisonEnum> getComparisonList() {
        return this.comparisonList;
    }

    public void setComparisonList(List<FAFComparisonEnum> comparisonList) {
        this.comparisonList = comparisonList;
    }

    public void setMetaSet(Set<FAFComparisonMetaEnum> metaSet) {
        this.metaSet = metaSet;
    }

    public Map<String, Map<Long, Long>> loadLinkMap(DynamicObject dimension, Object[] pkIds) {
        DynamicObject paDimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)"pa_dimension");
        String entityName = paDimension.getString("dimensionsource_id");
        if ("bd_period".equals(entityName)) {
            return this.getBDPeriodLink(pkIds);
        }
        if ("pa_analysisperiod".equals(entityName)) {
            return this.getPAPeriodLink(pkIds);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u671f\u95f4\u7ef4\u5ea6:%s", (String)"FAFComparisonDTO_2", (String)"macc-faf-common", (Object[])new Object[0]), dimension.getString("name")));
    }

    private Map<String, Map<Long, Long>> getPAPeriodLink(Object[] pkIds) {
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"pa_analysisperiod");
        Collection values = map.values();
        HashSet<Integer> years = new HashSet<Integer>(1);
        for (DynamicObject value : values) {
            int periodyear = value.getInt("year");
            years.add(periodyear);
            years.add(periodyear - 1);
        }
        QFilter filter = new QFilter("year", "in", years).and(new QFilter("isadjust", "=", (Object)"0"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"pa_analysisperiod", (String)"id,level,year,semiannual,quarter,month", (QFilter[])filter.toArray(), (String)"level desc,year desc,semiannual desc,quarter desc,month desc");){
            Stream<Row> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 4), false);
            List<FAFPeriodDTO> collect = stream.map(row -> new FAFPeriodDTO(row.getInteger("level"), row.getLong("id"), row.getInteger("year"), this.convertNumber((Row)row))).collect(Collectors.toList());
            Map<String, Map<Long, Long>> map2 = this.buildLinkMap(map, collect);
            return map2;
        }
    }

    private int convertNumber(Row row) {
        Integer level = row.getInteger("level");
        if (level.equals(1)) {
            return 10001;
        }
        if (level.equals(2)) {
            return 20000 + row.getInteger("semiannual");
        }
        if (level.equals(3)) {
            return 30000 + row.getInteger("quarter");
        }
        if (level.equals(4)) {
            return 40000 + row.getInteger("month");
        }
        return 0;
    }

    private Map<String, Map<Long, Long>> getBDPeriodLink(Object[] pkIds) {
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"bd_period");
        Collection values = map.values();
        HashSet<Integer> years = new HashSet<Integer>(1);
        Long periodtype = null;
        for (DynamicObject value : values) {
            int periodyear = value.getInt("periodyear");
            years.add(periodyear);
            years.add(periodyear - 1);
            if (periodtype == null) {
                periodtype = value.getLong("periodtype_id");
                continue;
            }
            if (periodtype.equals(value.getLong("periodtype_id"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u7684\"\u671f\u95f4\u7c7b\u578b\"\u4e0d\u4e00\u81f4", (String)"FAFComparisonDTO_3", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("periodyear", "in", years).and(new QFilter("isadjustperiod", "=", (Object)"0")).and(new QFilter("periodtype", "=", periodtype));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])filter.toArray(), (String)"periodyear desc,periodnumber desc");){
            Stream<Row> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 4), false);
            List<FAFPeriodDTO> collect = stream.map(row -> new FAFPeriodDTO(0, row.getLong("id"), row.getInteger("periodyear"), row.getInteger("periodnumber"))).collect(Collectors.toList());
            Map<String, Map<Long, Long>> map2 = this.buildLinkMap(map, collect);
            return map2;
        }
    }

    private Map<String, Map<Long, Long>> buildLinkMap(Map<Object, DynamicObject> map, List<FAFPeriodDTO> collect) {
        HashMap<String, Map<Long, Long>> hashMap = new HashMap<String, Map<Long, Long>>(this.metaSet.size());
        for (FAFComparisonMetaEnum metaEnum : this.metaSet) {
            hashMap.put(metaEnum.getCode(), this.buildLinkMap(metaEnum, map, collect));
        }
        return hashMap;
    }

    private Map<Long, Long> buildLinkMap(FAFComparisonMetaEnum comparisonEnum, Map<Object, DynamicObject> map, List<FAFPeriodDTO> collect) {
        LinkedHashMap<String, Long> mapLink = new LinkedHashMap<String, Long>();
        LinkedHashMap<Long, Long> link = new LinkedHashMap<Long, Long>();
        for (int i = 0; i < collect.size(); ++i) {
            String currKey;
            Long linkId;
            FAFPeriodDTO row = collect.get(i);
            Long currId = row.getId();
            String linkKey = row.getLinkKey(comparisonEnum, i);
            DynamicObject dynamicObject = map.get(currId);
            if (dynamicObject != null) {
                mapLink.put(linkKey, currId);
            }
            if ((linkId = (Long)mapLink.get(currKey = row.getCurrKey(comparisonEnum, i))) == null) continue;
            link.put(currId, linkId);
        }
        return link;
    }

    public boolean needComparison() {
        return !this.metaSet.isEmpty();
    }

    public List<String> getComparionTypeList() {
        return this.comparisonList.stream().map(FAFComparisonEnum::getCode).collect(Collectors.toList());
    }
}

