/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.dto;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;

public class FAFDateRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Date startDate;
    private Date endDate;
    private LocalDate startLocalDate;
    private LocalDate endLocalDate;
    private final String startDateStr;
    private final String endDateStr;

    public FAFDateRange(String range) {
        try {
            String[] _daterange = range.split(",");
            this.startDateStr = _daterange[0];
            this.endDateStr = _daterange[1];
        }
        catch (Exception ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u533a\u95f4\u683c\u5f0f\u9519\u8bef\uff1a%s ", (String)"FAFDateRange_0", (String)"macc-faf-common", (Object[])new Object[0]), range));
        }
    }

    public FAFDateRange(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.startDateStr = this.simpleDateFormat.format(startDate);
        this.endDateStr = this.simpleDateFormat.format(endDate);
    }

    public FAFDateRange(String startDateStr, String endDateStr) {
        this.startDateStr = startDateStr;
        this.endDateStr = endDateStr;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startDateStr)) {
                this.startDate = this.simpleDateFormat.parse(startDateStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)endDateStr)) {
                this.endDate = this.simpleDateFormat.parse(endDateStr);
            }
        }
        catch (Exception ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u533a\u95f4\u683c\u5f0f\u9519\u8bef\uff1a%1$s ~ %2$s ", (String)"FAFDateRange_1", (String)"macc-faf-common", (Object[])new Object[0]), startDateStr, endDateStr));
        }
    }

    public String getStartDateStr() {
        return this.startDateStr;
    }

    public String getEndDateStr() {
        return this.endDateStr;
    }

    public String getShowText() {
        return this.getStartDateStr() + " ~ " + this.getEndDateStr();
    }

    public String getDateRange() {
        return this.getStartDateStr() + "," + this.getEndDateStr();
    }

    public Date getStartDate() {
        if (this.startDate == null && StringUtils.isNotEmpty((CharSequence)this.startDateStr)) {
            try {
                this.startDate = this.simpleDateFormat.parse(this.startDateStr);
            }
            catch (ParseException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8fc7\u65f6\u9519\u8bef:%s", (String)"FAFDateRange_2", (String)"macc-faf-common", (Object[])new Object[0]), this.startDateStr));
            }
        }
        return this.startDate;
    }

    public Date getEndDate() {
        if (this.endDate == null && StringUtils.isNotEmpty((CharSequence)this.endDateStr)) {
            try {
                this.endDate = this.simpleDateFormat.parse(this.endDateStr);
            }
            catch (ParseException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8fc7\u65f6\u9519\u8bef:%s", (String)"FAFDateRange_2", (String)"macc-faf-common", (Object[])new Object[0]), this.endDateStr));
            }
        }
        return this.endDate;
    }

    public LocalDate getStartLocalDate() {
        if (this.startLocalDate == null && StringUtils.isNotEmpty((CharSequence)this.startDateStr)) {
            this.startLocalDate = LocalDate.parse(this.startDateStr, DateTimeFormatter.ISO_DATE);
        }
        return this.startLocalDate;
    }

    public LocalDate getEndLocalDate() {
        if (this.endLocalDate == null && StringUtils.isNotEmpty((CharSequence)this.endDateStr)) {
            this.endLocalDate = LocalDate.parse(this.endDateStr, DateTimeFormatter.ISO_DATE);
        }
        return this.endLocalDate;
    }

    public static Date toDate(String dateStr) {
        return new FAFDateRange(dateStr, null).getStartDate();
    }
}

