/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.formula;

import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.fas.formula.FormulaCalculator;
import kd.macc.faf.fas.formula.FormulaCalculatorTokenManager;
import kd.macc.faf.fas.formula.ParseException;
import kd.macc.faf.fas.formula.SimpleCharStream;
import kd.macc.faf.fas.formula.Token;

public class FormulaCalculatorHelper {
    public static BigDecimal calculate(String expr, Map<String, BigDecimal> params) throws Error, ArithmeticException, ParseException {
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new ParseException(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FormulaCalculatorHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        BigDecimal cal = FormulaCalculatorHelper.cal(expr, params);
        if (cal != null && cal.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal("0.0");
        }
        return cal;
    }

    public static void tryCalculate(String expr) throws Error, ParseException {
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new ParseException(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FormulaCalculatorHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        HashMap<String, BigDecimal> tryCalParams = new HashMap<String, BigDecimal>();
        FormulaCalculatorHelper.resolveFormulaAsTokenList(expr).stream().filter(token -> token.kind == 6).forEach(variateToken -> tryCalParams.putIfAbsent(variateToken.image, BigDecimal.ONE));
        try {
            FormulaCalculatorHelper.cal(expr, tryCalParams);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public static List<Token> resolveFormulaAsTokenList(String expr) throws ParseException, Error {
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new ParseException(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FormulaCalculatorHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        FormulaCalculatorTokenManager formulaCalculatorTokenManager = new FormulaCalculatorTokenManager(new SimpleCharStream(new StringReader(expr), 1, 1));
        ArrayList<Token> tokens = new ArrayList<Token>(8);
        while (true) {
            Token token = formulaCalculatorTokenManager.getNextToken();
            if (token.kind == 0) break;
            tokens.add(token);
        }
        return tokens;
    }

    private static BigDecimal cal(String expr, Map<String, BigDecimal> params) throws Error, ArithmeticException, ParseException {
        FormulaCalculator formulaCalculator = CollectionUtils.isEmpty(params) ? new FormulaCalculator(expr) : new FormulaCalculator(expr, params);
        BigDecimal calcResult = formulaCalculator.calc();
        if (!FormulaCalculatorHelper.isFormulaCalIntegrated(formulaCalculator)) {
            throw new ParseException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u5408\u6cd5,\u89e3\u6790\u5b58\u5728\u9519\u8bef", (String)"FormulaCalculatorHelper_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        return calcResult;
    }

    private static boolean isFormulaCalIntegrated(FormulaCalculator formulaCalculator) throws Error, ParseException {
        char[] buffer = formulaCalculator.token_source.input_stream.buffer;
        int endIndex = 0;
        for (char c : buffer) {
            if (c == '\u0000') continue;
            ++endIndex;
        }
        return formulaCalculator.getJj_gen() == FormulaCalculatorHelper.resolveFormulaAsTokenList(new String(buffer, 0, endIndex)).size();
    }
}

