/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.func;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.fas.index.IAggregateProcess;

public class FAFAvgReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta newRowMeta;
    private final int aggregateFieldIndex;
    private final int aggregateFieldOldIndex;
    private final Map<Integer, Integer> refmap;

    public FAFAvgReduceFunction(RowMeta rowMeta, IAggregateProcess process, String alias) {
        String[] grouper = process.grouper();
        String[] names = Arrays.copyOf(process.grouper(), grouper.length + 1);
        DataType[] types = new DataType[grouper.length + 1];
        for (int i = 0; i < names.length - 1; ++i) {
            Field field = rowMeta.getField(names[i]);
            types[i] = field.getDataType();
        }
        names[names.length - 1] = alias;
        types[types.length - 1] = DataType.BigDecimalType;
        this.newRowMeta = new RowMeta(names, types);
        this.aggregateFieldIndex = names.length - 1;
        this.aggregateFieldOldIndex = rowMeta.getFieldIndex(process.getAggmeasure());
        this.refmap = new HashMap<Integer, Integer>(grouper.length);
        for (String s : grouper) {
            this.refmap.put(this.newRowMeta.getFieldIndex(s), rowMeta.getFieldIndex(s));
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int count = 0;
        BigDecimal sum = new BigDecimal("0.00");
        RowX newRowX = new RowX(this.newRowMeta.getFieldCount());
        RowX initRow = null;
        for (RowX rowX : iterable) {
            BigDecimal bigDecimal;
            ++count;
            if (initRow == null) {
                initRow = rowX;
            }
            if ((bigDecimal = rowX.getBigDecimal(this.aggregateFieldOldIndex)) == null) continue;
            sum = sum.add(bigDecimal);
        }
        if (initRow == null) {
            return;
        }
        for (Map.Entry entry : this.refmap.entrySet()) {
            newRowX.set(((Integer)entry.getKey()).intValue(), initRow.get(((Integer)entry.getValue()).intValue()));
        }
        BigDecimal avg = sum.divide(BigDecimal.valueOf(count), 10, RoundingMode.HALF_UP);
        newRowX.set(this.aggregateFieldIndex, (Object)avg);
        collector.collect(newRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

