/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.func;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;
import kd.macc.faf.fas.index.IComparison;

public class FAFComparisonMapFunction
extends MapFunction {
    private static final Long serialVersionUID = 1L;
    private final RowMeta resultRowMeta;
    private final int newLength;
    private final int grouperLength;
    private final boolean includeProcess;
    private final List<String> comparisonTypeList;
    private final int index_this;
    private final Map<String, Integer> indexyoyMap;

    public FAFComparisonMapFunction(RowMeta rowMeta, IComparison comparison) {
        int i;
        this.comparisonTypeList = comparison.getComparisonTypeList();
        this.grouperLength = comparison.grouper().length;
        this.includeProcess = comparison.isIncludeProcess() || comparison.isMicroservice();
        this.newLength = this.includeProcess ? rowMeta.getFieldCount() + this.comparisonTypeList.size() : this.grouperLength + this.comparisonTypeList.size();
        Field[] resultFields = new Field[this.newLength];
        for (i = 0; i < this.grouperLength; ++i) {
            resultFields[i] = rowMeta.getFields()[i].copy();
        }
        for (i = this.grouperLength; i < this.grouperLength + this.comparisonTypeList.size(); ++i) {
            String fieldName = FAFComparisonEnum.getFieldName(this.comparisonTypeList.get(i - this.grouperLength));
            resultFields[i] = new Field(fieldName, (DataType)DataType.BigDecimalType);
        }
        if (this.includeProcess) {
            for (i = this.grouperLength + this.comparisonTypeList.size(); i < this.newLength; ++i) {
                resultFields[i] = rowMeta.getFields()[i - this.comparisonTypeList.size()].copy();
            }
        }
        this.resultRowMeta = new RowMeta(resultFields);
        this.index_this = rowMeta.getFieldIndex(comparison.getIndexNumber());
        this.indexyoyMap = new HashMap<String, Integer>(3);
        List<String> metaList = comparison.getComparisonMetaList();
        for (String code : metaList) {
            String prefix = FAFComparisonMetaEnum.getEnum(code).getPrefix();
            this.indexyoyMap.put(code, rowMeta.getFieldIndex(prefix + comparison.getOriginalIndexNumber(), false));
        }
    }

    public RowX map(RowX row) {
        int i;
        RowX newRowX = new RowX(this.newLength);
        for (i = 0; i < this.grouperLength; ++i) {
            newRowX.set(i, this.safeGet(row, i));
        }
        for (i = this.grouperLength; i < this.grouperLength + this.comparisonTypeList.size(); ++i) {
            String code = this.comparisonTypeList.get(i - this.grouperLength);
            if (FAFComparisonEnum.C_00.eq(code)) {
                newRowX.set(i, (Object)this.safeGetBigDecimal(row, this.index_this));
                continue;
            }
            int index = this.getIndex(code);
            if (index != -1) {
                BigDecimal comparisonValue = this.safeGetBigDecimal(row, index);
                newRowX.set(i, (Object)this.calculate(code, this.safeGetBigDecimal(row, this.index_this), comparisonValue));
                continue;
            }
            newRowX.set(i, null);
        }
        if (this.includeProcess) {
            for (i = this.grouperLength + this.comparisonTypeList.size(); i < this.newLength; ++i) {
                newRowX.set(i, this.safeGet(row, i - this.comparisonTypeList.size()));
            }
        }
        return newRowX;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    private int getIndex(String code) {
        String metaCode = FAFComparisonEnum.getEnum(code).getMetaEnum().getCode();
        return this.indexyoyMap.getOrDefault(metaCode, -1);
    }

    private BigDecimal calculate(String comparisonType, BigDecimal thisData, BigDecimal previousData) {
        if ("01".equals(comparisonType) || "03".equals(comparisonType)) {
            BigDecimal yoyRatio = null;
            if (previousData != null && thisData != null) {
                if (BigDecimal.ZERO.compareTo(previousData) != 0) {
                    yoyRatio = BigDecimal.ZERO.compareTo(thisData) != 0 ? thisData.subtract(previousData).divide(previousData, 10, 4) : new BigDecimal("-1");
                } else if (BigDecimal.ZERO.compareTo(thisData) == 0) {
                    yoyRatio = new BigDecimal("0.00");
                }
            }
            return yoyRatio;
        }
        if ("02".equals(comparisonType) || "04".equals(comparisonType)) {
            if (previousData != null && thisData != null) {
                return thisData.subtract(previousData);
            }
            return null;
        }
        return null;
    }

    private Object safeGet(RowX rowX, int index) {
        return rowX != null ? rowX.get(index) : null;
    }

    private BigDecimal safeGetBigDecimal(RowX rowX, int index) {
        return rowX != null ? rowX.getBigDecimal(index) : null;
    }
}

