/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.func;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;
import kd.macc.faf.fas.formula.FormulaCalculatorHelper;
import kd.macc.faf.fas.index.IFormulaProcess;
import kd.macc.faf.fas.index.model.FAFCompositeIndex;
import kd.macc.faf.fas.index.model.FAFElementaryIndex;
import kd.macc.faf.fas.index.model.FAFIndex;

public class FAFCompositeIndexFormulaCalcMapFunction
extends MapFunction {
    private static final Long serialVersionUID = 1L;
    private final RowMeta resultRowMeta;
    private final String indexFormula;
    private final List<FAFIndex> indexFormulaArgs;
    private final String flatElementaryIndexFormula;
    private final String[] groupNumbers;
    private final boolean isIncludeProcess;
    private final String prefix;

    public FAFCompositeIndexFormulaCalcMapFunction(RowMeta rowMeta, IFormulaProcess process, String[] groupNumbers, FAFComparisonMetaEnum cmeta) {
        this.sourceRowMeta = rowMeta;
        this.indexFormula = process.getIndexformula();
        this.indexFormulaArgs = process.getIndexformulaargs();
        this.flatElementaryIndexFormula = process.getFlatElementaryIndexFormula();
        this.groupNumbers = groupNumbers;
        this.isIncludeProcess = process.isIncludeProcess();
        this.prefix = cmeta.getPrefix();
        Field[] resultFields = this.isIncludeProcess ? new Field[groupNumbers.length + this.indexFormulaArgs.size() + 1] : new Field[groupNumbers.length + 1];
        for (int i = 0; i <= resultFields.length - 1; ++i) {
            if (i < groupNumbers.length) {
                resultFields[i] = this.sourceRowMeta.getField(i);
                continue;
            }
            if (i == resultFields.length - 1) {
                String fieldName = process.getFieldName(this.prefix);
                resultFields[i] = new Field(fieldName, (DataType)DataType.BigDecimalType);
                continue;
            }
            FAFIndex fasIndex = this.indexFormulaArgs.get(i - groupNumbers.length);
            String fieldName = fasIndex.getFieldName(this.prefix);
            resultFields[i] = fasIndex instanceof FAFElementaryIndex ? this.sourceRowMeta.getField(fieldName) : new Field(fieldName, (DataType)DataType.BigDecimalType);
        }
        this.resultRowMeta = new RowMeta(resultFields);
    }

    public RowX map(RowX rowX) {
        String formula;
        String fieldName;
        int i;
        int sourceFieldCount = this.sourceRowMeta.getFieldCount();
        int resultFieldCount = this.resultRowMeta.getFieldCount();
        RowX newRowX = new RowX(resultFieldCount);
        LinkedHashMap<String, BigDecimal> formulaIndexParams = new LinkedHashMap<String, BigDecimal>(resultFieldCount);
        LinkedHashMap<String, BigDecimal> flatFormulaElementaryIndexParams = new LinkedHashMap<String, BigDecimal>(sourceFieldCount);
        for (i = this.groupNumbers.length; i < sourceFieldCount; ++i) {
            Object elementaryIndexValue = rowX.get(i);
            fieldName = this.sourceRowMeta.getField(i).getName();
            flatFormulaElementaryIndexParams.put(this.removePrefix(fieldName), this.convertToBigDecimal(elementaryIndexValue));
        }
        for (i = 0; i < this.groupNumbers.length; ++i) {
            newRowX.set(i, rowX.get(i));
        }
        if (this.isIncludeProcess) {
            formula = this.indexFormula;
            for (i = this.groupNumbers.length; i < resultFieldCount - 1; ++i) {
                Object result;
                FAFIndex fasIndex = this.indexFormulaArgs.get(i - this.groupNumbers.length);
                fieldName = this.prefix + fasIndex.getOriginalIndexNumber();
                if (fasIndex instanceof FAFCompositeIndex) {
                    String flatElementaryIndexFormula = ((FAFCompositeIndex)fasIndex).getFlatElementaryIndexFormula();
                    result = this.calculateFormula(flatElementaryIndexFormula, flatFormulaElementaryIndexParams);
                } else {
                    result = rowX.get(this.sourceRowMeta.getFieldIndex(fieldName));
                    if (result == null) {
                        DataType dataType = this.sourceRowMeta.getField(fieldName).getDataType();
                        if (dataType instanceof BigDecimalType) {
                            result = new BigDecimal("0.00");
                        } else if (dataType instanceof IntegerType) {
                            result = 0;
                        }
                    }
                }
                formulaIndexParams.put(fasIndex.getOriginalIndexNumber(), result == null ? null : new BigDecimal(result.toString()));
                newRowX.set(i, result);
            }
        } else {
            formula = this.flatElementaryIndexFormula;
            formulaIndexParams.putAll(flatFormulaElementaryIndexParams);
        }
        for (BigDecimal indexParam : formulaIndexParams.values()) {
            if (indexParam != null) continue;
            newRowX.set(resultFieldCount - 1, null);
            return newRowX;
        }
        newRowX.set(resultFieldCount - 1, (Object)this.calculateFormula(formula, formulaIndexParams));
        return newRowX;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    private BigDecimal calculateFormula(String indexFormula, Map<String, BigDecimal> formulaParams) {
        try {
            return FormulaCalculatorHelper.calculate(indexFormula, formulaParams);
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
        catch (Error | Exception throwable) {
            String message = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
            throw new KDBizException(message);
        }
    }

    private String removePrefix(String fieldName) {
        return fieldName.substring(this.prefix.length());
    }

    private BigDecimal convertToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        return new BigDecimal("0.00");
    }
}

