/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.func;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.fas.index.model.FAFDateProcess;

public class FAFDateTimeToDateMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta newRowMeta;
    private final Map<Integer, DataType> indexMap = new LinkedHashMap<Integer, DataType>();

    public FAFDateTimeToDateMapFunction(RowMeta rowMeta, FAFDateProcess process) {
        Field[] fields = rowMeta.getFields();
        Field[] newFields = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            DataType dataType = fields[i].getDataType();
            if (dataType.equals((Object)DataType.DateType) || dataType.equals((Object)DataType.TimestampType)) {
                this.indexMap.put(i, dataType);
                newFields[i] = new Field(fields[i].getName(), (DataType)DataType.LongType);
                continue;
            }
            newFields[i] = fields[i].copy();
        }
        this.newRowMeta = new RowMeta(newFields);
    }

    public RowX map(RowX rowX) {
        Set<Map.Entry<Integer, DataType>> entries = this.indexMap.entrySet();
        for (Map.Entry<Integer, DataType> entry : entries) {
            Date date;
            DataType dataType = entry.getValue();
            if (dataType.equals((Object)DataType.TimestampType)) {
                Timestamp timestamp = rowX.getTimestamp(entry.getKey().intValue());
                if (timestamp == null) continue;
                LocalDateTime localDateTime = timestamp.toLocalDateTime();
                LocalDateTime with = localDateTime.with(LocalTime.of(0, 0, 0));
                Instant instant = with.atZone(ZoneId.systemDefault()).toInstant();
                rowX.set(entry.getKey().intValue(), (Object)instant.toEpochMilli());
                continue;
            }
            if (!dataType.equals((Object)DataType.DateType) || (date = rowX.getDate(entry.getKey().intValue())) == null) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            rowX.set(entry.getKey().intValue(), (Object)calendar.getTime().getTime());
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

