/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.func;

import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class FAFIdToNameMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta newRowMeta;
    private final Map<String, Map<Object, String>> namesMap;

    public FAFIdToNameMapFunction(RowMeta rowMeta, String orgNumber, Map<String, Map<Object, String>> namesMap) {
        this.namesMap = namesMap;
        Field[] fields = rowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        newFields[0] = new Field("_id_" + orgNumber, (DataType)DataType.LongType);
        for (int i = 0; i < fields.length; ++i) {
            newFields[i + 1] = fields[i].copy();
            if (!namesMap.containsKey(newFields[i + 1].getName())) continue;
            newFields[i + 1].setDataType((DataType)DataType.StringType);
        }
        this.newRowMeta = new RowMeta(newFields);
    }

    public RowX map(RowX rowX) {
        RowX newRow = new RowX(this.newRowMeta.getFieldCount());
        newRow.set(0, rowX.get(0));
        for (int i = 1; i < this.newRowMeta.getFieldCount(); ++i) {
            Field field = this.newRowMeta.getField(i);
            if (this.namesMap.containsKey(field.getName())) {
                Object value = rowX.get(i - 1);
                if (value == null || value.equals(0L)) {
                    newRow.set(i, (Object)"");
                    continue;
                }
                String name = this.namesMap.get(field.getName()).getOrDefault(value, value + "");
                newRow.set(i, (Object)name);
                continue;
            }
            newRow.set(i, rowX.get(i - 1));
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

