/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.func;

import java.util.Arrays;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.RowX;

public class FAFJoinFunction
extends JoinFunction {
    private static final Long serialVersionUID = 1L;
    private final RowMeta resultRowMeta;
    private final String[] onfields;
    private final int leftCount;
    private final int newLength;

    public FAFJoinFunction(RowMeta left, RowMeta right, String[] onfields) {
        this.setLeftSourceRowMeta(left);
        this.setRightSourceRowMeta(right);
        this.onfields = onfields;
        this.leftCount = left.getFieldCount();
        int rightCount = right.getFieldCount();
        this.newLength = this.leftCount + rightCount - onfields.length;
        Field[] newFields = Arrays.copyOf(left.getFields(), this.newLength);
        for (int i = this.leftCount; i < this.newLength; ++i) {
            newFields[i] = right.getField(i - this.leftCount + onfields.length).copy();
        }
        this.resultRowMeta = new RowMeta(newFields);
    }

    public RowX join(RowX leftRow, RowX rightRow) {
        int i;
        RowX newRowX = new RowX(this.newLength);
        for (i = 0; i < this.onfields.length; ++i) {
            Object left = this.safeGet(leftRow, i);
            Object right = this.safeGet(rightRow, i);
            newRowX.set(i, left != null ? left : right);
        }
        for (i = this.onfields.length; i < this.leftCount; ++i) {
            newRowX.set(i, this.safeGet(leftRow, i));
        }
        for (i = this.leftCount; i < this.newLength; ++i) {
            newRowX.set(i, this.safeGet(rightRow, i - this.leftCount + this.onfields.length));
        }
        return newRowX;
    }

    public Object safeGet(RowX rowX, int index) {
        return rowX != null ? rowX.get(index) : null;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

