/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.macc.faf.fas.index.IAggregateProcess;
import kd.macc.faf.fas.index.IFormulaProcess;
import kd.macc.faf.fas.index.model.FAFElementaryIndex;
import kd.macc.faf.fas.index.model.FAFIndex;

public class FAFCompositeIndex
extends FAFIndex
implements IFormulaProcess {
    private static final long serialVersionUID = 1L;
    private final Set<Object> dependencyIndex = new HashSet<Object>();
    private String indexformula;
    private List<FAFIndex> indexformulaargs;
    private String flatElementaryIndexFormula;

    public Set<Object> getDependencyIndex() {
        return this.dependencyIndex;
    }

    public void setDependencyIndex(Set<Object> dependencyIndex) {
        this.dependencyIndex.addAll(dependencyIndex);
    }

    public FAFCompositeIndex(FAFIndex root, Object pkValue) {
        super(root, pkValue);
    }

    @Override
    public String getIndexformula() {
        return this.indexformula;
    }

    public void setIndexformula(String indexformula) {
        this.indexformula = indexformula;
    }

    @Override
    public List<FAFIndex> getIndexformulaargs() {
        return this.indexformulaargs;
    }

    @Override
    public List<IAggregateProcess> getAllAggregateProcess() {
        return this.getElementaryIndexMap().values().stream().map(fasIndex -> (FAFElementaryIndex)fasIndex).collect(Collectors.toList());
    }

    public void setIndexformulaargs(List<FAFIndex> indexformulaargs) {
        this.indexformulaargs = indexformulaargs;
    }

    @Override
    public String getFlatElementaryIndexFormula() {
        if (StringUtils.isNotBlank((CharSequence)this.flatElementaryIndexFormula)) {
            return this.flatElementaryIndexFormula;
        }
        this.flatElementaryIndexFormula = this.flatCompositeIndexToElementaryIndexes(this);
        return this.flatElementaryIndexFormula;
    }

    private String flatCompositeIndexToElementaryIndexes(FAFCompositeIndex compositeIndex) {
        String indexFormula = compositeIndex.getIndexformula();
        List<FAFIndex> indexFormulaArgs = compositeIndex.getIndexformulaargs();
        HashMap<String, String> tempVarFormulaM = new HashMap<String, String>();
        int i = 1;
        for (FAFIndex fAFIndex : indexFormulaArgs) {
            String indexNumber = fAFIndex.getOriginalIndexNumber();
            if (!(fAFIndex instanceof FAFCompositeIndex)) continue;
            String elementaryIndexesFormula = this.flatCompositeIndexToElementaryIndexes((FAFCompositeIndex)fAFIndex);
            String formulaPlaceHolder = String.format("###%s###", i++);
            indexFormula = indexFormula.replace(indexNumber, formulaPlaceHolder);
            tempVarFormulaM.put(formulaPlaceHolder, String.format("(%s)", elementaryIndexesFormula));
        }
        for (Map.Entry entry : tempVarFormulaM.entrySet()) {
            indexFormula = indexFormula.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return indexFormula;
    }
}

