/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.EntityNotExistsException;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.fas.index.IAggregateProcess;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.index.model.FAFIndexModel;

public class FAFElementaryIndex
extends FAFIndex
implements IAggregateProcess {
    private static final Log logger = LogFactory.getLog(FAFElementaryIndex.class);
    private static final long serialVersionUID = 1L;
    private FAFIndexModel model;
    private List<QFilter> condition;
    private String aggregate;
    private String aggmeasure;

    public FAFElementaryIndex(FAFIndex root, Object pkValue) {
        super(root, pkValue);
    }

    public FAFIndexModel getModel() {
        return this.model;
    }

    public void setModel(FAFIndexModel model) {
        this.model = model;
    }

    public List<QFilter> getCondition() {
        if (this.condition == null) {
            return Collections.emptyList();
        }
        return this.condition;
    }

    public void setCondition(List<QFilter> condition) {
        this.condition = condition;
    }

    @Override
    public String getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(String aggregate) {
        this.aggregate = aggregate;
    }

    @Override
    public String getAggmeasure() {
        return this.aggmeasure;
    }

    public void setAggmeasure(String aggmeasure) {
        this.aggmeasure = aggmeasure;
    }

    public String getSelectFields() {
        List<String> grouper = this.root.getParamsGrouperFields();
        if (grouper == null) {
            grouper = Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(10);
        list.add("id");
        list.addAll(grouper);
        String aggmeasure = this.getAggmeasure();
        if (aggmeasure != null) {
            list.add(aggmeasure);
        }
        return String.join((CharSequence)",", list);
    }

    public List<QFilter> getQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.addAll(this.root.getParamsQFilters());
        list.addAll(this.model.getQFilters());
        return list;
    }

    @Override
    public OrmInput getOrmInput() {
        String entityName = this.model.getEntityname();
        String selectFields = this.getSelectFields();
        try {
            RowMeta rowMeta = ORM.create().createRowMeta(entityName, selectFields);
            return new OrmInput("elementary_" + this.getIndexName(), entityName, selectFields, this.getQFilters().toArray(new QFilter[0]), rowMeta);
        }
        catch (EntityNotExistsException ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u201c%s\u201d\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u672a\u521b\u5efa\u3002", (String)"FAFElementaryIndex_0", (String)"macc-faf-common", (Object[])new Object[0]), this.model.getName()));
        }
        catch (Exception ex) {
            logger.error("getOrmInput \u5931\u8d25\u3002", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u6307\u6807\u521b\u5efa OrmInput \u5931\u8d25\u3002", (String)"FAFElementaryIndex_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
    }

    @Override
    public OrmInput getOffsetOrmInput(String code) {
        try {
            Map<Long, Long> linkMap = this.root.getLinkMap().get(code);
            if (linkMap == null || linkMap.size() == 0) {
                return null;
            }
            String entityName = this.model.getEntityname();
            String selectFields = this.getSelectFields();
            RowMeta rowMeta = ORM.create().createRowMeta(entityName, selectFields);
            String period = this.getDimensionPeriod().getString("number");
            QFilter[] offsetQfilters = (QFilter[])this.getQFilters().stream().filter(Objects::nonNull).map(QFilter::copy).peek(qFilter -> {
                String property = qFilter.getProperty();
                if (property.equals(period)) {
                    qFilter.__setValue((Object)linkMap.keySet().toArray());
                }
            }).toArray(QFilter[]::new);
            return new OrmInput("elementary_" + this.getIndexName(), entityName, this.getSelectFields(), offsetQfilters, rowMeta);
        }
        catch (EntityNotExistsException ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u201c%s\u201d\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u672a\u521b\u5efa\u3002", (String)"FAFElementaryIndex_2", (String)"macc-faf-common", (Object[])new Object[0]), this.model.getName()));
        }
        catch (Exception ex) {
            logger.error("getOffsetOrmInput \u5931\u8d25\u3002", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u6307\u6807\u521b\u5efa OrmInput \u5931\u8d25\u3002", (String)"FAFElementaryIndex_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
    }
}

