/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;
import kd.macc.faf.fas.index.model.FAFComparisonProcess;
import kd.macc.faf.fas.index.model.FAFDateProcess;
import kd.macc.faf.fas.index.model.FAFElementaryIndex;
import kd.macc.faf.fas.index.model.FAFVariable;

public class FAFIndex
extends FAFComparisonProcess {
    private static final long serialVersionUID = 1L;
    List<String> paramsGrouperFields = new ArrayList<String>();
    List<QFilter> paramsQFilters = new ArrayList<QFilter>();
    protected FAFIndex root;
    private final Object pkValue;
    private String number;
    private String name;
    private Object system;
    private Integer precision;
    private Map<String, FAFIndex> elementaryIndexMap;
    private Map<String, FAFIndex> allIndexMap;
    private boolean isIncludeProcess = true;
    private boolean microservice = false;
    private DynamicObject dimOrg;
    private final List<FAFVariable> variableList = new ArrayList<FAFVariable>();
    private DynamicObject dimPeriod;
    private List<DynamicObject> dimensions;
    private FAFDateProcess dateProcess;
    private String requestSource = "test";
    private Map<String, Object> mixParams = new HashMap<String, Object>();

    public FAFIndex(FAFIndex root, Object pkValue) {
        this.root = root == null ? this : root;
        this.pkValue = pkValue;
    }

    public Object getPkValue() {
        return this.pkValue;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getSystem() {
        return this.system;
    }

    public void setSystem(Object pkValueSystem) {
        this.system = pkValueSystem;
    }

    public List<FAFVariable> getVariableList() {
        return this.variableList;
    }

    public void setIncludeProcess(boolean includeProcess) {
        this.isIncludeProcess = includeProcess;
    }

    public void setMicroservice(boolean microservice) {
        this.microservice = microservice;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getPrecision() {
        if (this.precision == null || this.precision > 10) {
            return 10;
        }
        return this.precision;
    }

    @Override
    public String getRequestSource() {
        return this.requestSource;
    }

    public void setRequestSource(String requestSource) {
        this.requestSource = requestSource;
    }

    public Map<String, FAFIndex> getElementaryIndexMap() {
        return this.elementaryIndexMap;
    }

    public void setElementaryIndexMap(Map<String, FAFIndex> map) {
        this.elementaryIndexMap = map;
    }

    public Map<String, FAFIndex> getAllIndexMap() {
        return this.allIndexMap;
    }

    public void setAllIndexMap(Map<String, FAFIndex> allIndexMap) {
        this.allIndexMap = allIndexMap;
    }

    public DynamicObject getDimensionOrg() {
        if (this.dimOrg == null) {
            this.dimOrg = this.root.dimOrg;
        }
        return this.dimOrg;
    }

    public void setDimensionOrg(DynamicObject dimOrg) {
        this.dimOrg = dimOrg;
    }

    public DynamicObject getDimensionPeriod() {
        if (this.dimPeriod == null) {
            this.dimPeriod = this.root.dimPeriod;
        }
        return this.dimPeriod;
    }

    public void setDimensionPeriod(DynamicObject dimPeriod) {
        this.dimPeriod = dimPeriod;
    }

    public List<QFilter> getParamsQFilters() {
        return this.paramsQFilters;
    }

    public List<String> getParamsGrouperFields() {
        return this.paramsGrouperFields;
    }

    public List<DynamicObject> getDimensions() {
        if (this.dimensions == null) {
            for (FAFIndex fasIndex : this.elementaryIndexMap.values()) {
                FAFElementaryIndex elementaryIndex = (FAFElementaryIndex)fasIndex;
                if (this.dimensions == null) {
                    this.dimensions = elementaryIndex.getModel().getDimensions();
                    continue;
                }
                this.dimensions.retainAll(elementaryIndex.getModel().getDimensions());
            }
            if (this.dimensions == null) {
                this.dimensions = Collections.emptyList();
            } else {
                this.dimensions.sort((o1, o2) -> {
                    if (this.dimOrg != null) {
                        if (this.dimOrg.getPkValue().equals(o1.getPkValue())) {
                            return -1;
                        }
                        if (this.dimOrg.getPkValue().equals(o2.getPkValue())) {
                            return 1;
                        }
                    }
                    if (this.dimPeriod != null) {
                        if (this.dimPeriod.getPkValue().equals(o1.getPkValue())) {
                            return -1;
                        }
                        if (this.dimPeriod.getPkValue().equals(o2.getPkValue())) {
                            return 1;
                        }
                    }
                    return 0;
                });
            }
        }
        return this.dimensions;
    }

    @Override
    public FAFIndex getRoot() {
        return this.root;
    }

    @Override
    public String getIndexName() {
        return this.getName();
    }

    @Override
    public String getIndexNumber() {
        return FAFComparisonMetaEnum.NONE.getPrefix() + this.number;
    }

    @Override
    public String getOriginalIndexNumber() {
        return this.number;
    }

    @Override
    public String[] grouper() {
        List<String> grouper = this.root.getParamsGrouperFields();
        if (grouper == null) {
            return new String[0];
        }
        return grouper.toArray(new String[0]);
    }

    @Override
    public int getScale() {
        return this.getPrecision();
    }

    @Override
    public String getPeriodFieldName() {
        if (this.dimPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u8981\u7ef4\u5ea6\u3002", (String)"FAFIndex_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        return this.dimPeriod.getString("number");
    }

    @Override
    public boolean isIncludeProcess() {
        return this.isIncludeProcess;
    }

    @Override
    public boolean isMicroservice() {
        return this.microservice;
    }

    public void setDateProcess(FAFDateProcess dateProcess) {
        this.dateProcess = dateProcess;
    }

    public FAFDateProcess getDateProcess() {
        if (this.dateProcess == null) {
            this.dateProcess = this.root.dateProcess == null ? new FAFDateProcess() : this.root.dateProcess;
        }
        return this.dateProcess;
    }

    public String toString() {
        return this.name + '(' + this.number + ')';
    }

    @Override
    public String getParamsKey() {
        List<String> ctlist;
        String key = "";
        List<String> fields = this.getParamsGrouperFields();
        if (fields != null) {
            key = fields.stream().sorted().collect(Collectors.joining("_"));
        }
        if ((ctlist = this.getComparisonTypeList()) != null) {
            key = key + ctlist.stream().sorted().collect(Collectors.joining("_"));
        }
        key = key + String.valueOf(this.isIncludeProcess());
        return key;
    }

    public String getOrgNumber() {
        return FAFUtils.safeGet(this.getDimensionOrg(), "number", "");
    }

    public void setMixParams(Map<String, Object> mixParams) {
        this.mixParams = mixParams;
    }

    public Map<String, Object> getMixParams() {
        return this.mixParams;
    }
}

