/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.handle;

import java.util.List;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.macc.faf.dto.DimensionDTO;
import kd.macc.faf.dto.ResultDTO;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.handle.CmDataImportFactory;
import kd.macc.faf.handle.EpmDataImportFactory;
import kd.macc.faf.handle.IDataImport;
import kd.macc.faf.handle.IDataImportFactory;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;

public class DataImportFactoryBuilder {
    private static IDataImportFactory<?> createFactory(OlapFromServiceEnum serviceEnum) {
        if (OlapFromServiceEnum.EPM == serviceEnum) {
            return EpmDataImportFactory.getInstance();
        }
        if (OlapFromServiceEnum.BCM == serviceEnum) {
            return CmDataImportFactory.getInstance();
        }
        throw new KDBizException("no support factory");
    }

    private static IDataImport getDataImport(OlapFromServiceEnum serviceEnum) {
        IDataImportFactory<?> dataImportFactory = DataImportFactoryBuilder.createFactory(serviceEnum);
        return dataImportFactory.createDataImport();
    }

    public static ResultDTO saveDimension(OlapFromServiceEnum serviceEnum, List<OlapServerDimemsionMetaInfo> resultList, Long analysisSystemId, Long importSystemId, String importSystemNumber) {
        return DataImportFactoryBuilder.getDataImport(serviceEnum).saveDimension(serviceEnum, resultList, analysisSystemId, importSystemId, importSystemNumber);
    }

    public static ResultDTO saveMeasure(OlapFromServiceEnum serviceEnum, List<DimensionDTO> dimensionList, Long analysisSystemId, Long importSystemId, String importSystemNumber) {
        return DataImportFactoryBuilder.getDataImport(serviceEnum).saveMeasure(serviceEnum, dimensionList, analysisSystemId, importSystemId, importSystemNumber);
    }

    public static void deleteDimensionMapping(OlapFromServiceEnum serviceEnum, Set<Long> idSet) {
        DataImportFactoryBuilder.getDataImport(serviceEnum).deleteDimensionMapping(idSet);
    }

    public static void deleteMeasureMapping(OlapFromServiceEnum serviceEnum, Set<Long> idSet) {
        DataImportFactoryBuilder.getDataImport(serviceEnum).deleteMeasureMapping(idSet);
    }
}

