/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.handle.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.dto.DimensionDTO;
import kd.macc.faf.dto.MemberDTO;
import kd.macc.faf.dto.ResultDTO;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.EnableStatusEnum;
import kd.macc.faf.enums.FAFSituationTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.handle.IDataImport;
import kd.macc.faf.handle.impl.CmDataImportHandler;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.util.CartesianUtil;

public class DataImportHandler
implements IDataImport {
    public static final Log log = LogFactory.getLog(CmDataImportHandler.class);

    @Override
    public ResultDTO saveDimension(OlapFromServiceEnum serviceEnum, List<OlapServerDimemsionMetaInfo> resultList, Long analysisSystemId, Long importSystemId, String importSystemNumber) {
        ResultDTO resultDTO = new ResultDTO();
        Map<String, String> info = this.getInfoByOlapServiceEnum(serviceEnum);
        String dimMappingEntity = info.get("dimMappingEntity");
        String modelField = info.get("modelField");
        String dimensionField = info.get("dimensionField");
        String dimNumberField = info.get("dimNumberField");
        String dimNameField = info.get("dimNameField");
        String importSystemSourceType = info.get("importSystemSourceType");
        String codePrefix = info.get("codePrefix");
        try {
            int size;
            QFilter filter = new QFilter("analysis_system", "=", (Object)analysisSystemId).and(new QFilter(modelField, "=", (Object)importSystemId));
            DynamicObjectCollection dimMappingCol = QueryServiceHelper.query((String)dimMappingEntity, (String)dimensionField, (QFilter[])filter.toArray());
            if (dimMappingCol != null && !dimMappingCol.isEmpty()) {
                Set dimensionIdSet = dimMappingCol.stream().map(p -> p.getLong(dimensionField)).collect(Collectors.toSet());
                Iterator<OlapServerDimemsionMetaInfo> iterator = resultList.iterator();
                while (iterator.hasNext()) {
                    Long dimensionId = iterator.next().getId();
                    if (!dimensionIdSet.contains(dimensionId)) continue;
                    iterator.remove();
                }
            }
            if ((size = resultList.size()) > 0) {
                DynamicObject analysisSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisSystemId, (String)"pa_anasystemsetting", (String)"id,number,name");
                Set dimEntitySet = resultList.stream().map(OlapServerDimemsionMetaInfo::getDimEntityName).collect(Collectors.toSet());
                QFilter entityFilter = new QFilter("id", "in", dimEntitySet);
                Map entityMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])entityFilter.toArray());
                ArrayList<DynamicObject> saveDimension = new ArrayList<DynamicObject>(size);
                ArrayList<DynamicObject> saveDimensionMapping = new ArrayList<DynamicObject>(size);
                long[] ids = DB.genLongIds((String)"pa_dimension", (int)size);
                long currUserId = RequestContext.get().getCurrUserId();
                int dataCount = this.getDataMaxSeq(analysisSystemId);
                for (int i = 0; i < size; ++i) {
                    DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"pa_dimension");
                    OlapServerDimemsionMetaInfo result = resultList.get(i);
                    this.setDynamicNumber(++dataCount, codePrefix, importSystemNumber, dyObj);
                    dyObj.set("id", (Object)ids[i]);
                    String name = result.getName();
                    dyObj.set("name", (Object)(name != null && name.length() > 50 ? name.substring(0, 50) : name));
                    dyObj.set("system", (Object)analysisSystem);
                    dyObj.set("dimensiontype", (Object)DimensionTypeEnum.DATABASE.getCode());
                    dyObj.set("typefield", (Object)"dimension");
                    dyObj.set("group_id", (Object)result.getId());
                    this.setCommonProp(dyObj, currUserId);
                    dyObj.set("systemsource", (Object)importSystemSourceType);
                    dyObj.set("dimensionsource", entityMap.get(result.getDimEntityName()));
                    this.addDimensionEntryProp(dyObj);
                    saveDimension.add(dyObj);
                    DynamicObject dimensionMapping = BusinessDataServiceHelper.newDynamicObject((String)dimMappingEntity);
                    dimensionMapping.set("dimension", (Object)ids[i]);
                    dimensionMapping.set(modelField, (Object)importSystemId);
                    dimensionMapping.set("analysis_system", (Object)analysisSystemId);
                    dimensionMapping.set(dimensionField, (Object)result.getId());
                    dimensionMapping.set(dimNumberField, (Object)result.getNumber());
                    dimensionMapping.set(dimNameField, (Object)result.getName());
                    dimensionMapping.set("membermodel", (Object)result.getDimEntityName());
                    saveDimensionMapping.add(dimensionMapping);
                }
                OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"pa_dimension", (DynamicObject[])saveDimension.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                this.setResultAndSaveMapping(resultDTO, operateResult, saveDimension, saveDimensionMapping, "dimension");
            }
        }
        catch (Exception ex) {
            resultDTO.setExceptionInterrupt(true);
            log.error("DataImportHandler saveDimension error", (Throwable)ex);
        }
        return resultDTO;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResultDTO saveMeasure(OlapFromServiceEnum serviceEnum, List<DimensionDTO> dimensionList, Long analysisSystemId, Long importSystemId, String importSystemNumber) {
        ResultDTO result = new ResultDTO();
        Map<String, String> info = this.getInfoByOlapServiceEnum(serviceEnum);
        String measureMappingEntity = info.get("measureMappingEntity");
        String modelField = info.get("modelField");
        String dimensionField = info.get("dimensionField");
        String dimNumberField = info.get("dimNumberField");
        String dimNameField = info.get("dimNameField");
        String importSystemSourceType = info.get("importSystemSourceType");
        String codePrefix = info.get("codePrefix");
        try {
            int size;
            long currUserId = RequestContext.get().getCurrUserId();
            List totalMemberList = dimensionList.stream().map(DimensionDTO::getMemberList).collect(Collectors.toList());
            ArrayList resultMemberList = new ArrayList(8);
            CartesianUtil.descartes(totalMemberList, resultMemberList, 0, new ArrayList(1));
            QFilter filter = new QFilter("analysis_system", "=", (Object)analysisSystemId).and(new QFilter(modelField, "=", (Object)importSystemId));
            Map measureMappings = BusinessDataServiceHelper.loadFromCache((String)measureMappingEntity, (QFilter[])filter.toArray());
            if (measureMappings != null && !measureMappings.isEmpty()) {
                ArrayList memberIdList = new ArrayList(measureMappings.size());
                for (Map.Entry mapping : measureMappings.entrySet()) {
                    DynamicObjectCollection measureMappingEntry = ((DynamicObject)mapping.getValue()).getDynamicObjectCollection("entryentity");
                    Set memberIdSet = measureMappingEntry.stream().map(entry -> entry.getLong("memberid")).collect(Collectors.toSet());
                    memberIdList.add(memberIdSet);
                }
                Iterator iterator = resultMemberList.iterator();
                int failure = 0;
                StringBuilder resultMessage = new StringBuilder();
                block3: while (iterator.hasNext()) {
                    List memberList = (List)iterator.next();
                    for (Set set : memberIdList) {
                        if (memberList.size() != set.size()) continue;
                        boolean needRemove = true;
                        for (MemberDTO member2 : memberList) {
                            if (set.contains(member2.getId())) continue;
                            needRemove = false;
                            break;
                        }
                        if (!needRemove) continue;
                        if (resultMessage.length() > 0) {
                            resultMessage.append(", ");
                        }
                        for (int i = 0; i < memberList.size(); ++i) {
                            if (i > 0) {
                                resultMessage.append('_');
                            }
                            resultMessage.append(((MemberDTO)memberList.get(i)).getName());
                        }
                        ++failure;
                        iterator.remove();
                        continue block3;
                    }
                }
                if (resultMessage.length() > 0) {
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ef4\u5ea6\u6210\u5458(%s)\u5df2\u5728\u5f53\u524d\u5206\u6790\u4f53\u7cfb\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210", (String)"DataImportHandler_0", (String)"macc-faf-common", (Object[])new Object[0]), resultMessage.toString()));
                    result.setFailure(failure);
                }
            }
            if ((size = resultMemberList.size()) > 0) {
                DynamicObject analysisSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisSystemId, (String)"pa_anasystemsetting", (String)"id,number,name");
                HashMap memberDimMapping = new HashMap(size);
                for (DimensionDTO dimensionDTO : dimensionList) {
                    List<MemberDTO> memberList = dimensionDTO.getMemberList();
                    memberList.forEach(member -> memberDimMapping.put(member.getId(), dimensionDTO));
                }
                long[] ids = DB.genLongIds((String)"pa_measure", (int)size);
                ArrayList<DynamicObject> measureList = new ArrayList<DynamicObject>(size);
                ArrayList<DynamicObject> measureMappingList = new ArrayList<DynamicObject>(dimensionList.size());
                int n = this.getDataMaxSeq(analysisSystemId);
                for (int i = 0; i < size; ++i) {
                    void var27_32;
                    DynamicObject measure = BusinessDataServiceHelper.newDynamicObject((String)"pa_measure");
                    List memberList = (List)resultMemberList.get(i);
                    DynamicObject measureMapping = BusinessDataServiceHelper.newDynamicObject((String)measureMappingEntity);
                    measureMapping.set(modelField, (Object)importSystemId);
                    measureMapping.set("analysis_system", (Object)analysisSystemId);
                    measureMapping.set("measure", (Object)ids[i]);
                    DynamicObjectCollection measureMappingCol = measureMapping.getDynamicObjectCollection("entryentity");
                    StringBuilder measureNameBuilder = new StringBuilder();
                    for (int seqIndex = 0; seqIndex < memberList.size(); ++seqIndex) {
                        MemberDTO member3 = (MemberDTO)memberList.get(seqIndex);
                        measureNameBuilder.append('_').append(member3.getName());
                        DynamicObject measureMappingEntry = new DynamicObject(measureMappingCol.getDynamicObjectType());
                        DimensionDTO dimensionFromMap = (DimensionDTO)memberDimMapping.get(member3.getId());
                        measureMappingEntry.set("seq", (Object)seqIndex);
                        measureMappingEntry.set(dimensionField, (Object)dimensionFromMap.getId());
                        measureMappingEntry.set(dimNumberField, (Object)dimensionFromMap.getNumber());
                        measureMappingEntry.set(dimNameField, (Object)dimensionFromMap.getName());
                        measureMappingEntry.set("membermodel", (Object)dimensionFromMap.getDimEntityName());
                        measureMappingEntry.set("memberid", (Object)member3.getId());
                        measureMappingEntry.set("membernumber", (Object)member3.getNumber());
                        measureMappingEntry.set("membername", (Object)member3.getName());
                        measureMappingCol.add((Object)measureMappingEntry);
                    }
                    measureMappingList.add(measureMapping);
                    measure.set("id", (Object)ids[i]);
                    this.setDynamicNumber((int)(++var27_32), codePrefix, importSystemNumber, measure);
                    if (measureNameBuilder.length() > 0) {
                        String nameSub = measureNameBuilder.substring(1);
                        if (nameSub.length() > 50) {
                            nameSub = nameSub.substring(0, 50);
                        }
                        measure.set("name", (Object)nameSub);
                    }
                    measure.set("system", (Object)analysisSystem);
                    measure.set("measuretype", (Object)String.valueOf(MeasureTypeEnum.ORDINARY.getCode()));
                    this.setCommonProp(measure, currUserId);
                    measure.set("systemsource", (Object)importSystemSourceType);
                    measure.set("situationtype", (Object)FAFSituationTypeEnum.ACTUAL.getCodeString());
                    measure.set("precision", (Object)2);
                    measureList.add(measure);
                }
                OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"pa_measure", (DynamicObject[])measureList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                this.setResultAndSaveMapping(result, operateResult, measureList, measureMappingList, "measure");
            }
        }
        catch (Exception ex) {
            result.setExceptionInterrupt(true);
            log.error("DataImportHandler saveMeasure error", (Throwable)ex);
        }
        return result;
    }

    @Override
    public void deleteDimensionMapping(Set<Long> idSet) {
        QFilter filter = new QFilter("dimension", "in", idSet);
        DeleteServiceHelper.delete((String)"faf_epmdimmapping", (QFilter[])filter.toArray());
        DeleteServiceHelper.delete((String)"faf_cmdimmapping", (QFilter[])filter.toArray());
    }

    @Override
    public void deleteMeasureMapping(Set<Long> idSet) {
        QFilter filter = new QFilter("measure", "in", idSet);
        DeleteServiceHelper.delete((String)"faf_epmmeasuremapping", (QFilter[])filter.toArray());
        DeleteServiceHelper.delete((String)"faf_cmmeasuremapping", (QFilter[])filter.toArray());
    }

    private String getNumberSeq(int seqCount) {
        int seqNumberLength = 5;
        String seq = String.valueOf(seqCount);
        if (seq.length() < seqNumberLength) {
            StringBuilder originSeqBuilder = new StringBuilder(seq);
            for (int i = 0; i < seqNumberLength - seq.length(); ++i) {
                originSeqBuilder.insert(0, "0");
            }
            seq = originSeqBuilder.toString();
        }
        return seq;
    }

    private void setDynamicNumber(int dataCount, String codePrefix, String importSystemNumber, DynamicObject dyObj) {
        String numberSeq = this.getNumberSeq(dataCount);
        int remainingLength = Math.min(25 - numberSeq.length(), 19);
        String numberPrefix = codePrefix + importSystemNumber;
        if (numberPrefix.length() > remainingLength) {
            numberPrefix = numberPrefix.substring(0, remainingLength);
        }
        dyObj.set("number", (Object)(numberPrefix + "_" + numberSeq).toLowerCase());
    }

    private Map<String, String> getInfoByOlapServiceEnum(OlapFromServiceEnum serviceEnum) {
        HashMap<String, String> result = new HashMap<String, String>(5);
        boolean bcmNum = OlapFromServiceEnum.BCM == serviceEnum;
        result.put("dimMappingEntity", bcmNum ? "faf_cmdimmapping" : "faf_epmdimmapping");
        result.put("measureMappingEntity", bcmNum ? "faf_cmmeasuremapping" : "faf_epmmeasuremapping");
        result.put("modelField", bcmNum ? "cmmodel" : "epmmodel");
        result.put("dimensionField", bcmNum ? "cmdimension" : "epmdimension");
        result.put("dimNumberField", bcmNum ? "cmdimnumber" : "epmdimnumber");
        result.put("dimNameField", bcmNum ? "cmdimname" : "epmdimname");
        result.put("importSystemSourceType", bcmNum ? ImportSystemSourceTypeEnum.BCM.getCode() : ImportSystemSourceTypeEnum.EPM.getCode());
        result.put("codePrefix", bcmNum ? "cm" : "bgm");
        return result;
    }

    private void setCommonProp(DynamicObject dynamicObject, long currUserId) {
        dynamicObject.set("enable", (Object)EnableStatusEnum.enable.getCodeString());
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("creator_id", (Object)currUserId);
    }

    private void addDimensionEntryProp(DynamicObject dynamicObject) {
        DynamicObjectCollection dyCol = dynamicObject.getDynamicObjectCollection("dimensionentryentity");
        DynamicObject entryNameObj = new DynamicObject(dyCol.getDynamicObjectType());
        entryNameObj.set("fieldnumber", (Object)"name");
        entryNameObj.set("fieldname", (Object)new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataImportHandler_1", (String)"macc-faf-common", (Object[])new Object[0])));
        DynamicObject entryNumberObj = new DynamicObject(dyCol.getDynamicObjectType());
        entryNumberObj.set("fieldnumber", (Object)"number");
        entryNumberObj.set("fieldname", (Object)new LocaleString(ResManager.loadKDString((String)"\u7f16\u53f7", (String)"DataImportHandler_2", (String)"macc-faf-common", (Object[])new Object[0])));
        dyCol.add((Object)entryNameObj);
        dyCol.add((Object)entryNumberObj);
    }

    private void setResultAndSaveMapping(ResultDTO result, OperationResult operateResult, List<DynamicObject> saveObjList, List<DynamicObject> mappingList, String mappingIdField) {
        result.setSuccess(operateResult.getSuccessPkIds().size());
        List allErrorOrValidateInfo = operateResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            Iterator<DynamicObject> mappingIterator = mappingList.iterator();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                errorMsg.append(iOperateInfo.getMessage()).append(' ');
                long failureId = Long.parseLong(String.valueOf(iOperateInfo.getPkValue()));
                while (mappingIterator.hasNext()) {
                    DynamicObject next = mappingIterator.next();
                    if (failureId != next.getLong(mappingIdField)) continue;
                    mappingIterator.remove();
                }
            }
            result.setFailure(result.getFailure() + saveObjList.size() - result.getSuccess());
            if (result.getMessage() != null) {
                errorMsg.append(';').append(result.getMessage());
            }
            result.setMessage(errorMsg.toString());
        }
        if (!mappingList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])mappingList.toArray(new DynamicObject[0]));
        }
    }

    private int getDataMaxSeq(Long analysisSystemId) {
        int dimensionSeq = 0;
        QFilter[] filter = new QFilter[]{new QFilter("system", "=", (Object)analysisSystemId).and(new QFilter("systemsource", "in", Arrays.asList(ImportSystemSourceTypeEnum.BCM.getCode(), ImportSystemSourceTypeEnum.EPM.getCode())))};
        DynamicObjectCollection dimensionMaxSeqCol = QueryServiceHelper.query((String)"DataImportHandler.getDimensionMaxSeq", (String)"pa_dimension", (String)"number", (QFilter[])filter, (String)"id desc", (int)1);
        if (dimensionMaxSeqCol != null && !dimensionMaxSeqCol.isEmpty()) {
            String number = ((DynamicObject)dimensionMaxSeqCol.get(0)).getString("number");
            dimensionSeq = this.getSeqFromNumber(number);
        }
        int measureSeq = 0;
        DynamicObjectCollection measureMaxSeqCol = QueryServiceHelper.query((String)"DataImportHandler.getMeasureMaxSeq", (String)"pa_measure", (String)"number", (QFilter[])filter, (String)"id desc", (int)1);
        if (measureMaxSeqCol != null && !measureMaxSeqCol.isEmpty()) {
            String number = ((DynamicObject)measureMaxSeqCol.get(0)).getString("number");
            measureSeq = this.getSeqFromNumber(number);
        }
        return Math.max(dimensionSeq, measureSeq);
    }

    private int getSeqFromNumber(String number) {
        if (number != null && number.length() > 5) {
            String seqStr = number.substring(number.length() - 5);
            return Integer.parseInt(seqStr);
        }
        return 0;
    }
}

