/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.handle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.handle.IFAFDataHandler;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.rdb.RdbSQLInfo;

public class FAFDataCalculateMeasureHandler
implements IFAFDataHandler<Long> {
    private FAFAnalysisModelModel analysisModelModel;
    private FAFMeasureModel calMeasure;
    Predicate<Row> predicate;

    public FAFDataCalculateMeasureHandler(FAFAnalysisModelModel analysisModelModel, FAFMeasureModel calMeasure, Predicate<Row> predicate) {
        this.analysisModelModel = analysisModelModel;
        this.calMeasure = calMeasure;
        this.predicate = predicate;
    }

    @Override
    public Long handle(RdbSQLInfo rdbSQLInfo) {
        FAFDimensionModel calDim = this.calMeasure.getDimension();
        List<FAFDimensionModel> list = this.analysisModelModel.getAllDim();
        list.remove(calDim);
        FAFMeasureModel refMeasure = this.analysisModelModel.findOrdinaryMeasure(this.calMeasure.getMeasure().getNumber());
        this.doHandleOrder(rdbSQLInfo, calDim, list, refMeasure);
        return null;
    }

    private Long doHandleOrder(RdbSQLInfo rdbSQLInfo, FAFDimensionModel calDim, List<FAFDimensionModel> otherDimList, FAFMeasureModel refMeasure) {
        int process;
        Long result = 0L;
        String[] keyField = FAFTableDataHelper.dimToField(otherDimList);
        ArrayList<FAFDimensionModel> orderList = new ArrayList<FAFDimensionModel>(otherDimList);
        orderList.add(calDim);
        String[] orderField = FAFTableDataHelper.dimToField(orderList);
        int length = 10000;
        int from = 0;
        String preKey = null;
        DynamicObject preObj = null;
        do {
            process = 0;
            ArrayList<DynamicObject> batchSaveList = new ArrayList<DynamicObject>(length);
            try (DataSet orderDataSet = FAFTableDataHelper.queryByRdbSQLInfo(rdbSQLInfo, FAFTableDataHelper.arrayToStr(orderField), from, length);){
                BigDecimal calValue;
                BigDecimal total = preObj == null ? BigDecimal.ZERO : ((calValue = preObj.getBigDecimal(this.calMeasure.getNumber())) == null ? BigDecimal.ZERO : calValue);
                String classifyKey = preKey;
                for (Row row : orderDataSet) {
                    ++process;
                    String key = this.buildRowKey(row, keyField);
                    if (classifyKey == null) {
                        classifyKey = key;
                    }
                    if (!classifyKey.equals(key)) {
                        total = BigDecimal.ZERO;
                        classifyKey = key;
                    }
                    if (this.predicate == null || this.predicate.test(row)) {
                        total = total.add(row.getBigDecimal(refMeasure.getNumber()) == null ? BigDecimal.ZERO : row.getBigDecimal(refMeasure.getNumber()));
                    }
                    preObj = this.processTotal(row, total);
                    batchSaveList.add(preObj);
                    preKey = classifyKey;
                }
            }
            result = result + (long)process;
            from += process;
            FAFTableDataHelper.update(batchSaveList);
        } while (process >= length && process > 0);
        return result;
    }

    private String buildRowKey(Row row, String[] keyFields) {
        StringBuilder sb = new StringBuilder();
        for (String field : keyFields) {
            sb.append(row.get(field));
        }
        return sb.toString();
    }

    private DynamicObject processTotal(Row row, BigDecimal total) {
        DynamicObject totalData = BusinessDataServiceHelper.newDynamicObject((String)this.analysisModelModel.getModelEntity());
        totalData.set("id", row.get("id"));
        totalData.set(this.calMeasure.getNumber(), (Object)total);
        return totalData;
    }
}

