/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.handle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.handle.IFAFDataHandler;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.rdb.RdbSQLInfo;

public class FAFDataComplementHandler
implements IFAFDataHandler<Long> {
    private static final Log logger = LogFactory.getLog(FAFDataComplementHandler.class);
    private FAFAnalysisModelModel analysisModelModel;
    private Map<Long, Long> curToPrePeriodMap;

    public FAFDataComplementHandler(FAFAnalysisModelModel analysisModelModel, Map<Long, Long> curToPrePeriodMap) {
        this.analysisModelModel = analysisModelModel;
        this.curToPrePeriodMap = curToPrePeriodMap;
    }

    @Override
    public Long handle(RdbSQLInfo rdbSQLInfo) {
        List<DynamicObject> complementDataList;
        int process;
        logger.info(" start to Complement data:" + rdbSQLInfo);
        Long startTime = System.currentTimeMillis();
        Long result = 0L;
        List<FAFDimensionModel> list = this.analysisModelModel.getAllDim();
        FAFDimensionModel periodDim = this.analysisModelModel.getPeriodDim();
        List<FAFMeasureModel> calMeasureList = this.analysisModelModel.getCalMeasure();
        ArrayList<FAFDimensionModel> orderList = new ArrayList<FAFDimensionModel>(list);
        orderList.remove(periodDim);
        String[] keyField = FAFTableDataHelper.dimToField(orderList);
        orderList.add(periodDim);
        String[] orderField = FAFTableDataHelper.dimToField(orderList);
        int length = 10000;
        int from = 0;
        String preKey = null;
        ArrayList<DynamicObject> classfyDataList = new ArrayList<DynamicObject>(24);
        ArrayList<DynamicObject> batchInsertList = new ArrayList<DynamicObject>(length);
        do {
            process = 0;
            try (DataSet orderDataSet = FAFTableDataHelper.queryByRdbSQLInfo(rdbSQLInfo, FAFTableDataHelper.arrayToStr(orderField), from, length);){
                String classifyKey = preKey;
                for (Row row : orderDataSet) {
                    ++process;
                    String key = this.buildRowKey(row, keyField);
                    if (classifyKey == null) {
                        classifyKey = key;
                    }
                    if (!classifyKey.equals(key)) {
                        classifyKey = key;
                        List<DynamicObject> complementDataList2 = this.complementData(classfyDataList, orderList);
                        batchInsertList.addAll(complementDataList2);
                        classfyDataList.clear();
                    }
                    DynamicObject currentObj = this.processTotal(row, orderList, calMeasureList);
                    classfyDataList.add(currentObj);
                    preKey = classifyKey;
                }
            }
            result = result + (long)process;
            from += process;
            if (batchInsertList.isEmpty()) continue;
            FAFTableDataHelper.insert(batchInsertList);
            batchInsertList.clear();
        } while (process >= length && process > 0);
        if (!classfyDataList.isEmpty() && !(complementDataList = this.complementData(classfyDataList, orderList)).isEmpty()) {
            FAFTableDataHelper.insert(complementDataList);
        }
        logger.info(" end for Complement data, cost:" + (System.currentTimeMillis() - startTime));
        return result;
    }

    private List<DynamicObject> complementData(List<DynamicObject> classfyDataList, List<FAFDimensionModel> orderList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(2);
        LinkedHashMap<Long, Long> valueMap = new LinkedHashMap<Long, Long>(this.curToPrePeriodMap.size());
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(this.curToPrePeriodMap.size());
        ArrayList<Long> curPeriodList = new ArrayList<Long>(this.curToPrePeriodMap.keySet());
        curPeriodList.sort(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return Long.compare(o1, o2);
            }
        });
        for (Long aLong : curPeriodList) {
            valueMap.put(aLong, this.curToPrePeriodMap.get(aLong));
        }
        FAFDimensionModel period = this.analysisModelModel.getPeriodDim();
        String periodField = period.getNumber();
        for (DynamicObject dynamicObject : classfyDataList) {
            Long periodID = dynamicObject.getLong(periodField);
            valueMap.remove(periodID);
            dataMap.put(periodID, dynamicObject);
        }
        if (!valueMap.isEmpty()) {
            valueMap.forEach((currentPeriodId, previousPeriodId) -> {
                DynamicObject preData = (DynamicObject)dataMap.get(previousPeriodId);
                if (preData != null) {
                    DynamicObject currentData = this.copyData(preData, (Long)currentPeriodId, orderList, periodField);
                    dataMap.put((Long)currentPeriodId, currentData);
                    list.add(currentData);
                }
            });
        }
        return list;
    }

    private DynamicObject copyData(DynamicObject preData, Long currentPeriodId, List<FAFDimensionModel> orderList, String periodField) {
        List<FAFMeasureModel> list;
        DynamicObject currentData = BusinessDataServiceHelper.newDynamicObject((String)this.analysisModelModel.getModelEntity());
        currentData.set("collectstatus", (Object)"1");
        for (FAFDimensionModel fAFDimensionModel : orderList) {
            String field = fAFDimensionModel.getNumber();
            currentData.set(field, preData.get(field));
        }
        currentData.set(periodField, (Object)currentPeriodId);
        currentData.set("createtime", (Object)new Date());
        List<FAFMeasureModel> ordinaryMeasureList = this.analysisModelModel.getOrdinaryMeasure();
        if (ordinaryMeasureList != null && !ordinaryMeasureList.isEmpty()) {
            for (FAFMeasureModel measureModel : ordinaryMeasureList) {
                currentData.set(measureModel.getNumber(), (Object)BigDecimal.ZERO);
            }
        }
        if ((list = this.analysisModelModel.getCalMeasure()) != null && !list.isEmpty()) {
            for (FAFMeasureModel measureModel : list) {
                String field = measureModel.getNumber();
                currentData.set(field, preData.get(field));
            }
        }
        return currentData;
    }

    private String buildRowKey(Row row, String[] keyFields) {
        StringBuilder sb = new StringBuilder();
        for (String field : keyFields) {
            sb.append(row.get(field));
        }
        return sb.toString();
    }

    private DynamicObject processTotal(Row row, List<FAFDimensionModel> allDimension, List<FAFMeasureModel> calMeasureList) {
        String field;
        DynamicObject totalData = BusinessDataServiceHelper.newDynamicObject((String)this.analysisModelModel.getModelEntity());
        totalData.set("id", row.get("id"));
        for (FAFDimensionModel fieldDim : allDimension) {
            field = fieldDim.getNumber();
            totalData.set(field, row.get(field));
        }
        if (calMeasureList != null && !calMeasureList.isEmpty()) {
            for (FAFMeasureModel measureModel : calMeasureList) {
                field = measureModel.getNumber();
                totalData.set(field, row.get(field));
            }
        }
        return totalData;
    }
}

