/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.handle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.FAFCollectStatusEnum;
import kd.macc.faf.enums.OperationStatusEnum;
import kd.macc.faf.handle.IFAFDataHandler;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.rdb.RdbCalculateSQLInfo;
import kd.macc.faf.rdb.RdbSQLInfo;

public class FAFDataSummaryHandler
implements IFAFDataHandler<Long> {
    private static final Log logger = LogFactory.getLog(FAFDataSummaryHandler.class);
    private final FAFAnalysisModelModel analysisModelModel;

    public FAFDataSummaryHandler(FAFAnalysisModelModel analysisModelModel) {
        this.analysisModelModel = analysisModelModel;
    }

    @Override
    public Long handle(RdbSQLInfo rdbSQLInfo) {
        long result = 0L;
        List<FAFDimensionModel> dimList = this.getProcessDim(rdbSQLInfo.getFilters());
        result = this.doHandleRowKey(rdbSQLInfo, dimList);
        return result;
    }

    private Long doHandleRowKey(RdbSQLInfo rdbSQLInfo, List<FAFDimensionModel> keyFields) {
        int processCount;
        String summaryMessage = rdbSQLInfo.toString();
        logger.info("used param in summary :" + summaryMessage);
        Long result = 0L;
        List<FAFMeasureModel> sumMeasureList = this.analysisModelModel.getOrdinaryMeasure();
        QFilter[] orgPeriodFilter = rdbSQLInfo.getFilters();
        QFilter[] filters = new QFilter[orgPeriodFilter.length + 2];
        System.arraycopy(orgPeriodFilter, 0, filters, 0, orgPeriodFilter.length);
        filters[filters.length - 2] = new QFilter("operationstatus", "=", (Object)OperationStatusEnum.UNUSED.getCode());
        filters[filters.length - 1] = new QFilter("collectstatus", "=", (Object)FAFCollectStatusEnum.COLLECT.getCode());
        String sumEntityNumber = this.analysisModelModel.getModelEntity();
        String detailEntityNumber = this.analysisModelModel.getDetailEntityNumber();
        int length = 10000;
        do {
            processCount = 0;
            HashMap<String, DynamicObject> insertSummaryMap = new HashMap<String, DynamicObject>(10);
            HashSet<DynamicObject> updateSummarySet = new HashSet<DynamicObject>(10);
            ArrayList<DynamicObject> updateDetailList = new ArrayList<DynamicObject>(10);
            HashMap<String, ArrayList<DynamicObject>> updateSummaryMap = new HashMap<String, ArrayList<DynamicObject>>(length);
            try (DataSet dataSet = FAFTableDataHelper.queryByRdbSQLInfoLimit(rdbSQLInfo, length);){
                if (dataSet == null) {
                    Long l = result;
                    return l;
                }
                for (Object row : dataSet) {
                    Long l = result;
                    Long l2 = result = Long.valueOf(result + 1L);
                    ++processCount;
                    String key = this.buildRowKey((Row)row, keyFields);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)detailEntityNumber);
                    Long id = row.getLong("id");
                    dynamicObject.set("id", (Object)id);
                    dynamicObject.set("operationstatus", (Object)OperationStatusEnum.USED.getCode());
                    for (FAFDimensionModel dimension : this.analysisModelModel.getAllDim()) {
                        dynamicObject.set(dimension.getNumber(), row.get(dimension.getNumber()));
                    }
                    for (FAFMeasureModel measure : sumMeasureList) {
                        String measureField = measure.getNumber();
                        dynamicObject.set(measureField, (Object)row.getBigDecimal(measureField));
                    }
                    List<Object> detailList = (List)updateSummaryMap.get(key);
                    if (detailList == null) {
                        detailList = new ArrayList<DynamicObject>(10);
                        updateSummaryMap.put(key, (ArrayList<DynamicObject>)detailList);
                    }
                    detailList.add(dynamicObject);
                }
            }
            HashMap<String, DynamicObject> summaryMap = new HashMap<String, DynamicObject>(length);
            DataSet summaryDataSet = QueryServiceHelper.queryDataSet((String)"querySummaryData", (String)sumEntityNumber, (String)rdbSQLInfo.getSelectFields(), (QFilter[])filters, null);
            Object object = null;
            try {
                Object row;
                if (summaryDataSet == null) {
                    row = result;
                    return row;
                }
                row = summaryDataSet.iterator();
                while (row.hasNext()) {
                    Row row2 = (Row)row.next();
                    String string = this.buildRowKey(row2, keyFields);
                    if (!updateSummaryMap.containsKey(string)) continue;
                    if (summaryMap.containsKey(string)) {
                        throw new KDBizException("summary error: Duplicate key" + string);
                    }
                    DynamicObject modelData = BusinessDataServiceHelper.newDynamicObject((String)this.analysisModelModel.getModelEntity());
                    modelData.set("id", row2.get("id"));
                    for (FAFMeasureModel measure : sumMeasureList) {
                        modelData.set(measure.getNumber(), row2.get(measure.getNumber()));
                    }
                    summaryMap.put(string, modelData);
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (summaryDataSet != null) {
                    if (object != null) {
                        try {
                            summaryDataSet.close();
                        }
                        catch (Throwable key) {
                            ((Throwable)object).addSuppressed(key);
                        }
                    } else {
                        summaryDataSet.close();
                    }
                }
            }
            Set updateSummaryEntrySet = updateSummaryMap.entrySet();
            boolean hasCreateTimeField = EntityMetadataCache.getDataEntityType((String)sumEntityNumber).getProperty("createtime") != null;
            Date now = new Date();
            for (Map.Entry entry : updateSummaryEntrySet) {
                String key = (String)entry.getKey();
                DynamicObject summaryData = (DynamicObject)summaryMap.get(key);
                List detailList = (List)entry.getValue();
                if (summaryData == null) {
                    RdbCalculateSQLInfo calInfo;
                    summaryData = BusinessDataServiceHelper.newDynamicObject((String)sumEntityNumber);
                    DynamicObject template = (DynamicObject)detailList.get(0);
                    for (FAFDimensionModel fAFDimensionModel : this.analysisModelModel.getAllDim()) {
                        summaryData.set(fAFDimensionModel.getNumber(), template.get(fAFDimensionModel.getNumber()));
                    }
                    summaryData.set("collectstatus", (Object)FAFCollectStatusEnum.COLLECT.getCode());
                    if (hasCreateTimeField) {
                        summaryData.set("createtime", (Object)now);
                    }
                    if (rdbSQLInfo instanceof RdbCalculateSQLInfo && (calInfo = (RdbCalculateSQLInfo)rdbSQLInfo).isSituation()) {
                        summaryData.set("situationtype", (Object)calInfo.getSituationEnum().getCode());
                    }
                    long[] casPks = DBServiceHelper.genLongIds((String)("t_" + sumEntityNumber), (int)1);
                    summaryData.set("id", (Object)casPks[0]);
                    insertSummaryMap.put(key, summaryData);
                } else {
                    updateSummarySet.add(summaryData);
                }
                for (DynamicObject detail : detailList) {
                    for (FAFMeasureModel measure : sumMeasureList) {
                        String measureField = measure.getNumber();
                        BigDecimal amount = detail.getBigDecimal(measureField);
                        amount = amount == null ? BigDecimal.ZERO : amount;
                        BigDecimal oldAmount = summaryData.getBigDecimal(measureField);
                        oldAmount = oldAmount == null ? BigDecimal.ZERO : oldAmount;
                        BigDecimal newAmount = oldAmount.add(amount);
                        summaryData.set(measureField, (Object)newAmount);
                    }
                    Long l = summaryData.getLong("id");
                    detail.set("summaryid", (Object)l);
                    updateDetailList.add(detail);
                }
            }
            try {
                Throwable serializable = null;
                try (TXHandle h = TX.required((String)summaryMessage);){
                    try {
                        FAFTableDataHelper.update(updateDetailList);
                        FAFTableDataHelper.insert(insertSummaryMap.values());
                        FAFTableDataHelper.update(updateSummarySet);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        logger.error(e);
                        throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable e) {
                logger.error(e);
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        } while (processCount >= length);
        return result;
    }

    private Map<String, DynamicObject> querySummaryData(RdbSQLInfo rdbSQLInfo, List<FAFDimensionModel> keyFields) {
        HashMap<String, DynamicObject> summaryDataMap = new HashMap<String, DynamicObject>(10);
        List<FAFMeasureModel> sumMeasureList = this.analysisModelModel.getOrdinaryMeasure();
        try (DataSet dataSet = FAFTableDataHelper.querySummaryByRdbSQLInfo(rdbSQLInfo);){
            if (dataSet == null) {
                HashMap<String, DynamicObject> hashMap = summaryDataMap;
                return hashMap;
            }
            for (Row row : dataSet) {
                String key = this.buildRowKey(row, keyFields);
                if (summaryDataMap.containsKey(key)) {
                    throw new KDBizException("summary error: Duplicate key" + key);
                }
                DynamicObject modelData = BusinessDataServiceHelper.newDynamicObject((String)this.analysisModelModel.getModelEntity());
                modelData.set("id", row.get("id"));
                for (FAFMeasureModel measure : sumMeasureList) {
                    modelData.set(measure.getNumber(), row.get(measure.getNumber()));
                }
                summaryDataMap.put(key, modelData);
            }
        }
        return summaryDataMap;
    }

    private String buildRowKey(Row row, List<FAFDimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (FAFDimensionModel dim : keyFields) {
            Object data = row.get(dim.getNumber());
            sb.append(dim.valueToString(data)).append('|');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private List<FAFDimensionModel> getProcessDim(QFilter[] filters) {
        List<FAFDimensionModel> dimList = this.analysisModelModel.getAllDim();
        if (filters != null) {
            for (QFilter filter : filters) {
                FAFDimensionModel filterDim = null;
                for (FAFDimensionModel model : dimList) {
                    if (!filter.getProperty().equals(model.getNumber()) || model.getDataType() == DimensionTypeEnum.DATE) continue;
                    filterDim = model;
                    break;
                }
                dimList.remove(filterDim);
            }
        }
        return dimList;
    }
}

