/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.handle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.FAFCollectStatusEnum;
import kd.macc.faf.enums.FAFSituationTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;

public class ShareDataCalculateMeasureHandler {
    private static Log logger = LogFactory.getLog(ShareDataCalculateMeasureHandler.class);

    public Long calculate(Collection<DynamicObject> summaryDatas, Long analysisModelId) {
        if (summaryDatas == null || summaryDatas.isEmpty() || analysisModelId == null) {
            return null;
        }
        FAFAnalysisModelModel analysisModelModel = this.getAnalysisModelConfig(analysisModelId);
        List<FAFMeasureModel> calMeasureList = analysisModelModel.getCalMeasure();
        long count = 0L;
        for (FAFMeasureModel calMeasure : calMeasureList) {
            count += this.doCalculate(summaryDatas, analysisModelModel, calMeasure).longValue();
        }
        return count;
    }

    public Long calculate(Collection<DynamicObject> summaryDatas, FAFAnalysisModelModel analysisModelModel) {
        if (summaryDatas == null || summaryDatas.isEmpty() || analysisModelModel == null) {
            return null;
        }
        List<FAFMeasureModel> calMeasureList = analysisModelModel.getCalMeasure();
        if (calMeasureList == null || calMeasureList.isEmpty()) {
            return null;
        }
        long count = 0L;
        for (FAFMeasureModel calMeasure : calMeasureList) {
            count += this.doCalculate(summaryDatas, analysisModelModel, calMeasure).longValue();
        }
        return count;
    }

    private Long doCalculate(Collection<DynamicObject> summaryDatas, FAFAnalysisModelModel analysisModelModel, FAFMeasureModel calMeasure) {
        Map<Object, String> refDimValueKeyMap = this.completionPeriod(summaryDatas, calMeasure);
        if (refDimValueKeyMap == null || refDimValueKeyMap.isEmpty()) {
            logger.info(" value in refdim is empty");
            return 0L;
        }
        List<FAFDimensionModel> dimList = analysisModelModel.getAllDim();
        QFilter[] filters = this.genQFilter(summaryDatas, dimList, calMeasure, refDimValueKeyMap, analysisModelModel.getModelEntity());
        Map<String, List<DynamicObject>> classfyMap = this.completionSummary(summaryDatas, analysisModelModel, calMeasure, filters);
        return this.calculateMeasure(classfyMap, calMeasure, summaryDatas, refDimValueKeyMap);
    }

    private Long calculateMeasure(Map<String, List<DynamicObject>> classfyMap, FAFMeasureModel calMeasure, Collection<DynamicObject> summaryDatas, Map<Object, String> refDimValueKeyMap) {
        if (classfyMap == null || classfyMap.isEmpty()) {
            return 0L;
        }
        FAFDimensionModel refDim = calMeasure.getDimension();
        String calMeasureField = calMeasure.getNumber();
        String refMeasureField = calMeasure.getMeasure().getNumber();
        final String refDimField = refDim.getNumber();
        Comparator<DynamicObject> sortor = new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Long id1 = (Long)ShareDataCalculateMeasureHandler.this.getFieldValue(o1, refDimField);
                Long id2 = (Long)ShareDataCalculateMeasureHandler.this.getFieldValue(o2, refDimField);
                return id1.compareTo(id2);
            }
        };
        HashSet<Long> idSet = new HashSet<Long>(summaryDatas.size());
        for (DynamicObject dynamicObject : summaryDatas) {
            idSet.add(dynamicObject.getLong("id"));
        }
        Set<Map.Entry<String, List<DynamicObject>>> classEntrySet = classfyMap.entrySet();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(classfyMap.size());
        for (Map.Entry<String, List<DynamicObject>> classEntry : classEntrySet) {
            List<DynamicObject> dataList = classEntry.getValue();
            dataList.sort(sortor);
            BigDecimal total = BigDecimal.ZERO;
            String preKey = null;
            for (DynamicObject seqObj : dataList) {
                BigDecimal refMeasure;
                Object refDimId = this.getFieldValue(seqObj, refDimField);
                String curKey = refDimValueKeyMap.get(refDimId);
                if (preKey == null) {
                    preKey = curKey;
                }
                if (!preKey.equals(curKey)) {
                    total = BigDecimal.ZERO;
                    preKey = curKey;
                }
                total = total.add((refMeasure = seqObj.getBigDecimal(refMeasureField)) == null ? BigDecimal.ZERO : refMeasure);
                seqObj.set(calMeasureField, (Object)total);
                Long id = seqObj.getLong("id");
                if (idSet.contains(id)) continue;
                updateList.add(seqObj);
            }
        }
        FAFTableDataHelper.update(summaryDatas);
        FAFTableDataHelper.update(updateList);
        return summaryDatas.size() + updateList.size();
    }

    private Map<String, List<DynamicObject>> completionSummary(Collection<DynamicObject> summaryDatas, FAFAnalysisModelModel analysisModelModel, FAFMeasureModel calMeasure, QFilter[] filters) {
        List<FAFDimensionModel> allDimList = analysisModelModel.getAllDim();
        List<FAFDimensionModel> classfyDimList = analysisModelModel.getAllDim();
        classfyDimList.remove(calMeasure.getDimension());
        String selectFields = FAFTableDataHelper.selectField(analysisModelModel, true);
        HashSet<String> keySet = new HashSet<String>(summaryDatas.size());
        HashMap<String, List<DynamicObject>> classfyMap = new HashMap<String, List<DynamicObject>>(10);
        for (DynamicObject obj : summaryDatas) {
            String rowKey = this.buildRowKey(obj, allDimList);
            keySet.add(rowKey);
            String classfyKey = this.buildRowKey(obj, classfyDimList);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)classfyMap.get(classfyKey);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                classfyMap.put(classfyKey, list);
            }
            list.add(obj);
        }
        List<FAFMeasureModel> sumMeasureList = analysisModelModel.getOrdinaryMeasure();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"completionSummary", (String)analysisModelModel.getModelEntity(), (String)selectFields, (QFilter[])filters, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String classfyKey;
                    List list;
                    String rowKey = this.buildRowKey(row, allDimList);
                    if (keySet.contains(rowKey) || (list = (List)classfyMap.get(classfyKey = this.buildRowKey(row, classfyDimList))) == null) continue;
                    DynamicObject summaryData = BusinessDataServiceHelper.newDynamicObject((String)analysisModelModel.getModelEntity());
                    for (FAFDimensionModel dimension : allDimList) {
                        summaryData.set(dimension.getNumber(), row.get(dimension.getNumber()));
                    }
                    summaryData.set("id", row.get("id"));
                    for (FAFMeasureModel measure : sumMeasureList) {
                        String measureField = measure.getNumber();
                        summaryData.set(measureField, (Object)row.getBigDecimal(measureField));
                    }
                    list.add(summaryData);
                }
            }
        }
        return classfyMap;
    }

    private QFilter[] genQFilter(Collection<DynamicObject> summaryDatas, List<FAFDimensionModel> dimList, FAFMeasureModel calMeasure, Map<Object, String> refDimValueKeyMap, String entityNumber) {
        HashMap<String, Set> filterValueMap = new HashMap<String, Set>(dimList.size());
        FAFDimensionModel refDim = calMeasure.getDimension();
        String refField = refDim.getNumber();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (DynamicObject summaryData : summaryDatas) {
            for (FAFDimensionModel fAFDimensionModel : dimList) {
                String field = fAFDimensionModel.getNumber();
                if (refField.equals(field)) continue;
                Object value = summaryData.get(field);
                if (value == null) {
                    IDataEntityProperty property = mainEntityType.findProperty(field);
                    Class propertyType = property.getPropertyType();
                    value = String.class.isAssignableFrom(propertyType) ? "" : (Long.TYPE.isAssignableFrom(propertyType) ? Long.valueOf(0L) : null);
                }
                value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
                Set objsSet = filterValueMap.computeIfAbsent(field, key -> new HashSet(10));
                objsSet.add(value);
            }
        }
        QFilter[] filters = new QFilter[dimList.size() + 2];
        int count = 0;
        for (Map.Entry entry : filterValueMap.entrySet()) {
            Set valueSet = (Set)entry.getValue();
            if (valueSet.contains(null)) {
                QFilter nullFilter = new QFilter((String)entry.getKey(), "is null", null);
                valueSet.remove(null);
                if (!valueSet.isEmpty()) {
                    filters[count++] = nullFilter.or(new QFilter((String)entry.getKey(), "in", (Object)valueSet));
                    continue;
                }
                filters[count++] = nullFilter;
                continue;
            }
            filters[count++] = new QFilter((String)entry.getKey(), "in", entry.getValue());
        }
        filters[count++] = new QFilter(refField, "in", refDimValueKeyMap.keySet());
        filters[count++] = new QFilter("collectstatus", "=", (Object)FAFCollectStatusEnum.COLLECT.getCode());
        filters[count++] = new QFilter("situationtype", "=", (Object)FAFSituationTypeEnum.ACTUAL.getCode());
        return filters;
    }

    private Map<Object, String> completionPeriod(Collection<DynamicObject> summaryDatas, FAFMeasureModel calMeasure) {
        String[] attrs;
        FAFDimensionModel refDim = calMeasure.getDimension();
        String refField = refDim.getNumber();
        String entityName = refDim.getSource().getNumber();
        StringBuilder selectField = new StringBuilder("id");
        for (String string : attrs = calMeasure.getDimensionattrs()) {
            selectField.append(',').append(string);
        }
        HashMap<Object, String> idKeyMap = new HashMap<Object, String>(10);
        HashMap<String, ArrayList<Object>> keyIdMap = new HashMap<String, ArrayList<Object>>(10);
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"completionPeriod", (String)entityName, (String)selectField.toString(), null, null);){
            for (Row row : dataSet) {
                StringBuilder keyBuild = new StringBuilder();
                for (String attr3 : attrs) {
                    keyBuild.append(row.get(attr3));
                }
                String attrValue = keyBuild.toString();
                Object id = row.get("id");
                idKeyMap.put(id, attrValue);
                ArrayList<Object> idList = (ArrayList<Object>)keyIdMap.get(attrValue);
                if (idList == null) {
                    idList = new ArrayList<Object>(10);
                    keyIdMap.put(attrValue, idList);
                }
                idList.add(id);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        HashSet keySet = new HashSet(10);
        for (DynamicObject summaryData : summaryDatas) {
            try {
                Object refId = this.getFieldValue(summaryData, refField);
                keySet.add(idKeyMap.get(refId));
            }
            catch (Exception e) {
                logger.error("\u6c47\u603b\u6570\u636eid:" + summaryData.get("id") + "\uff0c \u805a\u5408\u7ef4\u5ea6:" + refField + "\uff0c\u805a\u5408\u7ef4\u5ea6\u503c:" + summaryData.get(refField));
                throw new KDBizException(new ErrorCode("", ""), new Object[]{e.getMessage(), e});
            }
        }
        HashMap<Object, String> hashMap = new HashMap<Object, String>(10);
        for (String key : keySet) {
            List idList = (List)keyIdMap.get(key);
            if (idList == null || idList.isEmpty()) continue;
            for (Object id : idList) {
                hashMap.put(id, (String)idKeyMap.get(id));
            }
        }
        return hashMap;
    }

    private String buildRowKey(DynamicObject data, List<FAFDimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (FAFDimensionModel dim : keyFields) {
            String valueStr;
            String field = dim.getNumber();
            Object value = this.getFieldValue(data, field);
            if (value == null || "0".equals(valueStr = String.valueOf(value)) || StringUtils.isEmpty((String)valueStr)) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    private Object getFieldValue(DynamicObject data, String field) {
        IDataEntityProperty property;
        Object value = data.get(field);
        Object object = value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
        if (value instanceof Integer && (property = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)field)) instanceof BasedataProp) {
            value = Long.valueOf(String.valueOf(value));
        }
        return value;
    }

    private String buildRowKey(Row row, List<FAFDimensionModel> keyFields) {
        StringBuilder sb = new StringBuilder();
        for (FAFDimensionModel dim : keyFields) {
            String valueStr;
            Object value = row.get(dim.getNumber());
            if (value == null || "0".equals(valueStr = String.valueOf(value)) || StringUtils.isEmpty((String)valueStr)) continue;
            sb.append(valueStr);
        }
        return sb.toString();
    }

    private FAFAnalysisModelModel getAnalysisModelConfig(Long analysisModelId) {
        DynamicObject analysisModel = FAFAnalysisModelHelper.loadAnalysisModel(analysisModelId);
        FAFAnalysisModelModel analysisModelModel = new FAFAnalysisModelModel();
        analysisModelModel.loadFromDynamicObject(analysisModel, true);
        return analysisModelModel;
    }
}

