/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.GLVoucherHelper;

public class BizVoucherHelper {
    public static final String TYPE_BASEDATA = "1";
    public static final String TYPE_ASSISTANTTYPE = "2";
    public static final String TYPE_TXT = "3";
    public static final String TYPE_BOOLEAN = "4";
    public static final String TYPE_NUMBER = "5";
    public static final String TYPE_DATE = "6";
    public static final String PREFIX = "dim_";

    public static Map<String, String> matchDimension(DimensionTypeEnum dimensionTypeEnum, String baseEntityId, Long assistantTypeId) {
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDmension", (String)"ai_asstacttype", (String)"flexfiled,name,datatype,valuesource,assistanttype", null, null);){
            for (Row row : dataSet) {
                String dataType = row.getString("datatype");
                DimensionTypeEnum type = BizVoucherHelper.typeMapping(dataType);
                if (type != dimensionTypeEnum) continue;
                boolean isMatch = false;
                switch (type) {
                    case DATABASE: {
                        String entityId = row.getString("valuesource");
                        isMatch = baseEntityId.equals(entityId);
                        break;
                    }
                    case ASSISTANTDATA: {
                        Long assistanttype = row.getLong("assistanttype");
                        isMatch = assistantTypeId.equals(assistanttype);
                        break;
                    }
                    case OTHER: {
                        isMatch = true;
                    }
                }
                if (!isMatch) continue;
                String number = row.getString("flexfiled");
                String name = row.getString("name");
                dataMap.put(BizVoucherHelper.addPrefix(number), BizVoucherHelper.addNamePrefix(name));
            }
        }
        return dataMap;
    }

    public static Map<String, String> getAiAsstactTypeMeasure() {
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        QFilter qFilter = new QFilter("datatype", "not in", (Object)new String[]{TYPE_BASEDATA, TYPE_ASSISTANTTYPE, TYPE_BOOLEAN, TYPE_DATE});
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMeasure", (String)"ai_asstacttype", (String)"flexfiled,name,datatype", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                String number = row.getString("flexfiled");
                String name = row.getString("name");
                dataMap.put(BizVoucherHelper.addPrefix(number), BizVoucherHelper.addNamePrefix(name));
            }
        }
        return dataMap;
    }

    public static Map<String, String> matchAsstactType(DimensionTypeEnum dimensionTypeEnum, String baseEntityId, Long assistantTypeId) {
        return GLVoucherHelper.matchDimension(dimensionTypeEnum, baseEntityId, assistantTypeId);
    }

    public static Map<String, String> queryDimension() {
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDmension", (String)"ai_asstacttype", (String)"flexfiled,name", null, null);){
            for (Row row : dataSet) {
                String number = row.getString("flexfiled");
                String name = row.getString("name");
                dataMap.put(BizVoucherHelper.addPrefix(number), BizVoucherHelper.addNamePrefix(name));
            }
        }
        return dataMap;
    }

    public static Map<String, String> queryAsstactType() {
        return GLVoucherHelper.queryDimension();
    }

    public static String addPrefix(String number) {
        return StringUtils.isEmpty((String)number) ? null : PREFIX + number;
    }

    public static String addNamePrefix(String name) {
        return StringUtils.isEmpty((String)name) ? "" : String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6_%s", (String)"BizVoucherHelper_0", (String)"macc-faf-common", (Object[])new Object[0]), name);
    }

    public static String deletePrefix(String field) {
        return StringUtils.isEmpty((String)field) && field.indexOf(PREFIX) < 0 ? field : field.substring(field.indexOf(PREFIX));
    }

    public static DimensionTypeEnum typeMapping(String asstacttype) {
        switch (asstacttype) {
            case "1": {
                return DimensionTypeEnum.DATABASE;
            }
            case "2": {
                return DimensionTypeEnum.ASSISTANTDATA;
            }
        }
        return DimensionTypeEnum.OTHER;
    }

    public static Map<String, String> flexAsstactTypeDimension(Map<String, String> flexField, Map<String, String> asstactTypeField) {
        return GLVoucherHelper.flexDimension(flexField, asstactTypeField);
    }
}

