/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.RefProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.BusinessControl;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.operation.DelParameter;
import kd.bos.metadata.entity.operation.ImportParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.entity.operation.SaveParameter;
import kd.bos.metadata.filter.CommonBaseDataFilterColumnAp;
import kd.bos.metadata.filter.CommonDateFilterColumnAp;
import kd.bos.metadata.filter.FastSearchGridViewAp;
import kd.bos.metadata.filter.FilterColumnAp;
import kd.bos.metadata.filter.FilterContainerAp;
import kd.bos.metadata.filter.FilterGridViewAp;
import kd.bos.metadata.filter.SchemeBaseDataFilterColumnAp;
import kd.bos.metadata.filter.SchemeComboFilterColumnAp;
import kd.bos.metadata.filter.SchemeFilterColumnAp;
import kd.bos.metadata.filter.SchemeFilterViewAp;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.DateListColumnAp;
import kd.bos.metadata.list.DecimalListColumnAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListFormAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.DataValueTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.util.CustomizedFormBuilderInfo;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.IDataValueUtil;

public class EntityMetaHelper {
    private static final Log logger = LogFactory.getLog(EntityMetaHelper.class);
    private static final String ENDSWITH_LK = "_lk";
    private static final String ENDSWITH_ID = "_id";
    private static final String LanguageGLang = "GLang";

    public static void initEntryEntity(MainEntityType dataEntityType, AbstractFormDataModel model, IFormView view, List<String> excludes) {
        int count;
        if (dataEntityType == null) {
            return;
        }
        if (model == null) {
            return;
        }
        if (view == null) {
            return;
        }
        List<Map<String, String>> returnDataList = EntityMetaHelper.parseEntryeEtityFields((IDataEntityType)dataEntityType, null, null);
        StringBuilder logs = new StringBuilder();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("showname", new Object[0]);
        vs.addField("shownumber", new Object[0]);
        vs.addField("showdatatype", new Object[0]);
        for (Map<String, String> map : returnDataList) {
            String showName = map.get("showname");
            String showNumber = map.get("shownumber");
            String showdatatype = map.get("showdatatype");
            if (StringUtils.isBlank((CharSequence)showName) || StringUtils.isBlank((CharSequence)showNumber) || StringUtils.isBlank((CharSequence)showdatatype)) {
                logs.append(" ");
                logs.append(showNumber);
                continue;
            }
            if (excludes != null && excludes.contains(showNumber)) {
                logs.append(" ");
                logs.append(showNumber);
                continue;
            }
            vs.addRow(new Object[]{showName, showNumber, showdatatype});
        }
        if (logs.length() > 0) {
            logs.insert(0, ResManager.loadKDString((String)"\u8fc7\u6ee4\u5df2\u9009\u5b57\u6bb5\u6216\u4fe1\u606f\u4e0d\u5168\u5b57\u6bb5", (String)"EntityMetaHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
            logger.info(logs.toString());
        }
        if ((count = vs.getCount()) > 0) {
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        model.endInit();
        view.updateView("entryentity");
    }

    @Deprecated
    public static List<Map<String, String>> parseEntryeEtityFields(IDataEntityType sourceDataType, String fullEntryPrefixNum, String fullEntryPrefixName) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (sourceDataType == null) {
            return resultList;
        }
        if (StringUtils.isBlank((CharSequence)sourceDataType.getAlias())) {
            return resultList;
        }
        StringBuilder endsWithLogs = new StringBuilder();
        StringBuilder displayNameLogs = new StringBuilder();
        StringBuilder aliasNameLogs = new StringBuilder();
        for (IDataEntityProperty prop : sourceDataType.getProperties()) {
            IBasedataField refBaseProp;
            List<Map<String, String>> childObjectFields;
            String fieldNumber = prop.getName() == null ? "" : prop.getName();
            fieldNumber = EntityMetaHelper.addPre(fullEntryPrefixNum, fieldNumber);
            LocaleString displayName = prop.getDisplayName();
            String fieldName = displayName == null ? "" : displayName.toString();
            fieldName = EntityMetaHelper.addPre(fullEntryPrefixName, fieldName);
            if (ENDSWITH_LK.endsWith(fieldNumber) || ENDSWITH_ID.endsWith(fieldNumber)) {
                endsWithLogs.append(" ");
                endsWithLogs.append(fieldNumber);
                continue;
            }
            if (displayName == null) {
                displayNameLogs.append(" ");
                displayNameLogs.append(fieldNumber);
                continue;
            }
            if (prop instanceof EntryProp) {
                resultList.addAll(EntityMetaHelper.parseEntryeEtityFields(((EntryProp)prop).getItemType(), fieldNumber, fieldName));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)prop.getAlias())) {
                aliasNameLogs.append(" ");
                aliasNameLogs.append(fieldNumber);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>(16);
            DataValueTypeEnum propertyDataType = IDataValueUtil.getDataType(prop);
            map.put("showname", fieldName);
            map.put("shownumber", fieldNumber);
            map.put("showdatatype", String.valueOf(propertyDataType.getCode()));
            if (DataValueTypeEnum.BaseProp == propertyDataType && !(childObjectFields = EntityMetaHelper.parseEntryeEtityFields((refBaseProp = (IBasedataField)prop).getComplexType(), fieldNumber, fieldName)).isEmpty()) {
                resultList.addAll(childObjectFields);
                childObjectFields.clear();
            }
            resultList.add(map);
        }
        if (endsWithLogs.length() > 0) {
            logger.info(endsWithLogs.insert(0, "\u5ffd\u7565\u663e\u793a _lk\u6216_id\u7ed3\u5c3e\u7684\u5c5e\u6027\u5b57\u6bb5").toString());
        }
        if (displayNameLogs.length() > 0) {
            logger.info(displayNameLogs.insert(0, "\u5ffd\u7565\u663e\u793a\u540d\u79f0\u4e3a\u7a7a\u7684\u5b57\u6bb5").toString());
        }
        if (aliasNameLogs.length() > 0) {
            logger.info(aliasNameLogs.insert(0, "\u5ffd\u7565\u6570\u636e\u5e93\u6ca1\u6709\u7684\u5b57\u6bb5").toString());
        }
        return resultList;
    }

    private static String addPre(String pre, String field) {
        if (pre != null && pre.length() > 0) {
            field = pre + "." + field;
        }
        return field;
    }

    public static boolean isUsed(String propertyName) {
        return StringUtils.isEmpty((CharSequence)propertyName) || propertyName.startsWith("##");
    }

    public static void getPropertyInHeadAndEntry(String entityNumber, String entryNumber, boolean hasSubEntry, String subEntryNumber, Consumer<IDataEntityProperty> consumer) {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if ("id".equals(name)) continue;
                if (property instanceof EntryProp) {
                    if (StringUtils.isNotBlank((CharSequence)entryNumber) && !property.getName().equals(entryNumber)) continue;
                    DataEntityPropertyCollection entryProperties = ((EntryProp)property)._collectionItemPropertyType.getProperties();
                    for (IDataEntityProperty subProp : entryProperties) {
                        if (subProp instanceof SubEntryProp) {
                            if (!hasSubEntry || StringUtils.isNotBlank((CharSequence)subEntryNumber) && !subProp.getName().equals(subEntryNumber)) continue;
                            DataEntityPropertyCollection subEntryProperties = ((SubEntryProp)subProp)._collectionItemPropertyType.getProperties();
                            for (IDataEntityProperty subEntryProperty : subEntryProperties) {
                                consumer.accept(subEntryProperty);
                            }
                            continue;
                        }
                        consumer.accept(subProp);
                    }
                    continue;
                }
                consumer.accept(property);
            }
        }
    }

    public static List<String> matchFlexProperty(String entityNumber) {
        ArrayList<String> flexProperty = new ArrayList<String>(2);
        EntityMetaHelper.getPropertyInHeadAndEntry(entityNumber, null, false, null, property -> {
            String name = property.getName();
            if (!EntityMetaHelper.isUsed(property.getAlias()) && property instanceof FlexProp) {
                if (property.getParent() instanceof EntryType) {
                    EntryType parentType = (EntryType)property.getParent();
                    String parentName = parentType.getName();
                    String subPropertyName = parentName + "." + name;
                    flexProperty.add(subPropertyName);
                } else {
                    flexProperty.add(name);
                }
            }
        });
        return flexProperty;
    }

    public static Set<String> matchFlexPropertyWithoutParent(String entityNumber) {
        HashSet<String> flexProperty = new HashSet<String>(2);
        EntityMetaHelper.getPropertyInHeadAndEntry(entityNumber, null, false, null, property -> {
            String name = property.getName();
            if (!EntityMetaHelper.isUsed(property.getAlias()) && property instanceof FlexProp) {
                flexProperty.add(name);
            }
        });
        return flexProperty;
    }

    public static Optional<String> getBaseEntityId(String entityName, String fieldName) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return Optional.empty();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return dataEntityType.getProperties().stream().filter(property -> property.getName().equals(fieldName) && property instanceof BasedataProp).findFirst().map(property -> ((BasedataProp)property).getBaseEntityId());
    }

    public static void constructMetadataList(CustomizedFormBuilderInfo builderInfo, DynamicObject analysisModel) {
        FormMetadata formMeta = builderInfo.getFormMeta();
        formMeta.setBizappId("2UK0B8T0A=WJ");
        EntityMetadata entityMeta = builderInfo.getEntityMeta();
        entityMeta.setBizappId("2UK0B8T0A=WJ");
        FormAp rootAp = formMeta.getRootAp();
        if (rootAp instanceof BasedataFormAp) {
            BasedataFormAp basedataFormAp = (BasedataFormAp)rootAp;
            OrmLocaleValue analysisModelName = (OrmLocaleValue)analysisModel.get("name");
            LocaleString listName = EntityMetaHelper.buildLocaleStringByField(String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5bfc\u5165\u5217\u8868", (String)"EntityMetaHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), analysisModelName.getLocaleValue()), String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5bfc\u5165\u5217\u8868", (String)"EntityMetaHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), analysisModelName.getLocaleValue_zh_CN()), String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5bfc\u5165\u5217\u8868", (String)"EntityMetaHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), analysisModelName.getLocaleValue_en()), String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5bfc\u5165\u5217\u8868", (String)"EntityMetaHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), analysisModelName.getLocaleValue_zh_TW()), String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5bfc\u5165\u5217\u8868", (String)"EntityMetaHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), analysisModelName.getItem(LanguageGLang)));
            FormMetadata formMetadata = new FormMetadata();
            formMetadata.setBizappId("2UK0B8T0A=WJ");
            formMetadata.setId(EntityMetaHelper.getMetaDataId());
            formMetadata.setKey("subformdesigner");
            formMetadata.setModelType("BillListCardViewModel");
            formMetadata.setName(listName);
            List items = formMetadata.getItems();
            basedataFormAp.setListMeta(formMetadata);
            List formPlugins = basedataFormAp.getPlugins();
            formPlugins.clear();
            Plugin formPlugin = new Plugin();
            formPlugin.setDescription(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u901a\u7528\u5bfc\u5165\u63d2\u4ef6", (String)"EntityMetaHelper_26", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_26", (String)"macc-faf-common").toString());
            formPlugin.setClassName("kd.macc.faf.system.FAFDynamicMetaImportPlugin");
            formPlugin.setScriptNumber(String.valueOf(analysisModel.get("id")));
            formPlugin.setEnabled(true);
            formPlugins.add(formPlugin);
            ListFormAp listFormAp = new ListFormAp();
            listFormAp.setLanguage(Lang.get().toString());
            listFormAp.setShowType("MainNewTabPage");
            listFormAp.setId(EntityMetaHelper.getMetaDataId());
            listFormAp.setAlignItems("stretch");
            listFormAp.setLockStyle(2);
            listFormAp.setName(listName);
            listFormAp.setPkId("2NQBZU//++MS");
            listFormAp.setKey("subformdesigner");
            listFormAp.setDirection("column");
            listFormAp.setWrap(false);
            List plugins = listFormAp.getPlugins();
            plugins.clear();
            Plugin plugin = new Plugin();
            plugin.setDescription(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u52a8\u6001\u5143\u6570\u636e\u5217\u8868\u63d2\u4ef6", (String)"EntityMetaHelper_27", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_27", (String)"macc-faf-common").toString());
            plugin.setClassName("kd.macc.faf.system.FAFDynamicBuildMetaListPlugin");
            plugin.setEnabled(true);
            plugins.add(plugin);
            items.add(listFormAp);
            FilterContainerAp filterContainerAp = new FilterContainerAp();
            filterContainerAp.setId("_FilterContainer_");
            filterContainerAp.setKey("_FilterContainer_");
            filterContainerAp.setGrow(0);
            filterContainerAp.setName(listName);
            items.add(filterContainerAp);
            ToolbarAp toolbarAp = new ToolbarAp();
            toolbarAp.setKey("_toolbar_");
            toolbarAp.setId("_toolbar_");
            toolbarAp.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5217\u8868\u5de5\u5177\u680f", (String)"EntityMetaHelper_28", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_28", (String)"macc-faf-common"));
            items.add(toolbarAp);
            BillListAp billListAp = new BillListAp();
            billListAp.setId("_BillList_");
            billListAp.setName(listName);
            billListAp.setKey("_BillList_");
            billListAp.setEntityId(builderInfo.getFormMeta().getEntityId());
            billListAp.setQueryType("1");
            items.add(billListAp);
            ListGridViewAp listGridViewAp = new ListGridViewAp();
            listGridViewAp.setId("gridview");
            listGridViewAp.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u8868\u683c\u89c6\u56fe", (String)"EntityMetaHelper_29", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_29", (String)"macc-faf-common"));
            listGridViewAp.setKey("gridview");
            listGridViewAp.setParentId("_BillList_");
            items.add(listGridViewAp);
            FastSearchGridViewAp fastSearchGridViewAp = new FastSearchGridViewAp();
            fastSearchGridViewAp.setId("fastsearchgridview");
            fastSearchGridViewAp.setKey("fastsearchgridview");
            fastSearchGridViewAp.setParentId("_FilterContainer_");
            fastSearchGridViewAp.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5feb\u6377\u641c\u7d22\u89c6\u56fe", (String)"EntityMetaHelper_30", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_30", (String)"macc-faf-common"));
            items.add(fastSearchGridViewAp);
            FilterGridViewAp filterGridViewAp = new FilterGridViewAp();
            filterGridViewAp.setId("filtergridview");
            filterGridViewAp.setKey("filtergridview");
            filterGridViewAp.setParentId("_FilterContainer_");
            filterGridViewAp.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5e38\u7528\u8fc7\u6ee4\u89c6\u56fe", (String)"EntityMetaHelper_31", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_31", (String)"macc-faf-common"));
            items.add(filterGridViewAp);
            SchemeFilterViewAp schemeFilterViewAp = new SchemeFilterViewAp();
            schemeFilterViewAp.setId("schemefilterview");
            schemeFilterViewAp.setKey("schemefilterview");
            schemeFilterViewAp.setParentId("_FilterContainer_");
            schemeFilterViewAp.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u65b9\u6848\u8fc7\u6ee4\u89c6\u56fe", (String)"EntityMetaHelper_32", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_32", (String)"macc-faf-common"));
            items.add(schemeFilterViewAp);
            BarItemAp importData = new BarItemAp();
            importData.setOperationKey("importdata");
            importData.setId(EntityMetaHelper.getMetaDataId());
            importData.setKey("importdata");
            importData.setOperationStyle(Integer.valueOf(0));
            importData.setParentId("_toolbar_");
            importData.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"EntityMetaHelper_33", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_33", (String)"macc-faf-common"));
            items.add(importData);
            List dropdownItems = importData.getDropdownItems();
            String dropdownVisible = ",init,new,edit,view,submit,audit,";
            DropdownItem viewImportResult = new DropdownItem();
            viewImportResult.setVisible(dropdownVisible);
            viewImportResult.setTitle(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", (String)"EntityMetaHelper_34", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_34", (String)"macc-faf-common"));
            viewImportResult.setOperationKey("importdetails");
            viewImportResult.setIsSwitch(true);
            viewImportResult.setId(EntityMetaHelper.getMetaDataId());
            viewImportResult.setKey("importdetails");
            dropdownItems.add(viewImportResult);
            DropdownItem exportListOnImportModel = new DropdownItem();
            exportListOnImportModel.setVisible(dropdownVisible);
            exportListOnImportModel.setTitle(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5bfc\u5165\u6a21\u677f\uff09", (String)"EntityMetaHelper_35", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_35", (String)"macc-faf-common"));
            exportListOnImportModel.setOperationKey("exportlist");
            exportListOnImportModel.setIsSwitch(true);
            exportListOnImportModel.setId(EntityMetaHelper.getMetaDataId());
            exportListOnImportModel.setKey("exportdata");
            dropdownItems.add(exportListOnImportModel);
            DropdownItem exportListOnExportModel = new DropdownItem();
            exportListOnExportModel.setVisible(dropdownVisible);
            exportListOnExportModel.setTitle(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5bfc\u51fa\u6a21\u677f\uff09", (String)"EntityMetaHelper_36", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_36", (String)"macc-faf-common"));
            exportListOnExportModel.setOperationKey("exportlist_expt");
            exportListOnExportModel.setIsSwitch(true);
            exportListOnExportModel.setId(EntityMetaHelper.getMetaDataId());
            exportListOnExportModel.setKey("exportdata_expt");
            dropdownItems.add(exportListOnExportModel);
            DropdownItem viewExportResult = new DropdownItem();
            viewExportResult.setVisible(dropdownVisible);
            viewExportResult.setTitle(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", (String)"EntityMetaHelper_37", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_37", (String)"macc-faf-common"));
            viewExportResult.setOperationKey("exportdetails");
            viewExportResult.setIsSwitch(true);
            viewExportResult.setId(EntityMetaHelper.getMetaDataId());
            viewExportResult.setKey("exportlog");
            dropdownItems.add(viewExportResult);
            BarItemAp viewData = new BarItemAp();
            viewData.setId(EntityMetaHelper.getMetaDataId());
            viewData.setKey("viewdata");
            viewData.setOperationStyle(Integer.valueOf(0));
            viewData.setIndex(1);
            viewData.setParentId("_toolbar_");
            viewData.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u67e5\u770b\u6570\u636e", (String)"EntityMetaHelper_38", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_38", (String)"macc-faf-common"));
            items.add(viewData);
            BarItemAp delete = new BarItemAp();
            delete.setId(EntityMetaHelper.getMetaDataId());
            delete.setKey("delete");
            delete.setOperationStyle(Integer.valueOf(0));
            delete.setIndex(2);
            delete.setParentId("_toolbar_");
            delete.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityMetaHelper_39", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_39", (String)"macc-faf-common"));
            items.add(delete);
            BarItemAp refresh = new BarItemAp();
            refresh.setOperationKey("refresh");
            refresh.setId(EntityMetaHelper.getMetaDataId());
            refresh.setKey("refresh");
            refresh.setOperationStyle(Integer.valueOf(0));
            refresh.setIndex(3);
            refresh.setParentId("_toolbar_");
            refresh.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5237\u65b0", (String)"EntityMetaHelper_40", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_40", (String)"macc-faf-common"));
            items.add(refresh);
            BarItemAp close = new BarItemAp();
            close.setOperationKey("btn_close");
            close.setId(EntityMetaHelper.getMetaDataId());
            close.setKey("btn_close");
            close.setOperationStyle(Integer.valueOf(0));
            close.setIndex(4);
            close.setParentId("_toolbar_");
            close.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u9000\u51fa", (String)"EntityMetaHelper_41", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_41", (String)"macc-faf-common"));
            items.add(close);
            CardRowPanelAp cardRowPanelAp = new CardRowPanelAp();
            cardRowPanelAp.setId(EntityMetaHelper.getMetaDataId());
            cardRowPanelAp.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5361\u7247", (String)"EntityMetaHelper_42", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_42", (String)"macc-faf-common"));
            cardRowPanelAp.setKey("cardviewrow");
            cardRowPanelAp.setParentId("cardview");
            items.add(cardRowPanelAp);
            ListColumnAp orderColumn = new ListColumnAp();
            orderColumn.setColumnOrderAndFilter("1");
            orderColumn.setSeqColumnType("EntitySeq");
            orderColumn.setId(EntityMetaHelper.getMetaDataId());
            orderColumn.setKey("listcolumnap");
            orderColumn.setOrder("NotOrder");
            orderColumn.setParentId("gridview");
            orderColumn.setListFieldId("fseq");
            orderColumn.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntityMetaHelper_43", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_43", (String)"macc-faf-common"));
            items.add(orderColumn);
            ListColumnAp importBatchColumn = new ListColumnAp();
            importBatchColumn.setColumnOrderAndFilter("1");
            importBatchColumn.setSeqColumnType("NotSeq");
            importBatchColumn.setId(EntityMetaHelper.getMetaDataId());
            importBatchColumn.setKey("listcolumnap2");
            importBatchColumn.setOrder("NotOrder");
            importBatchColumn.setIndex(1);
            importBatchColumn.setParentId("gridview");
            importBatchColumn.setListFieldId("importbatch");
            importBatchColumn.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u6279\u6b21\u53f7", (String)"EntityMetaHelper_44", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_44", (String)"macc-faf-common"));
            items.add(importBatchColumn);
            DateListColumnAp createTimeDateListColumn = new DateListColumnAp();
            createTimeDateListColumn.setColumnOrderAndFilter("1");
            createTimeDateListColumn.setSeqColumnType("NotSeq");
            createTimeDateListColumn.setId(EntityMetaHelper.getMetaDataId());
            createTimeDateListColumn.setKey("datelistcolumnap");
            createTimeDateListColumn.setOrder("NotOrder");
            createTimeDateListColumn.setIndex(2);
            createTimeDateListColumn.setParentId("gridview");
            createTimeDateListColumn.setListFieldId("createtime");
            createTimeDateListColumn.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"EntityMetaHelper_45", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_45", (String)"macc-faf-common"));
            items.add(createTimeDateListColumn);
            List entityMetaItemList = entityMeta.getItems();
            String orgNumber = null;
            ArrayList<String> necessityDimensionList = new ArrayList<String>(3);
            ArrayList<String> ordinaryDimensionList = new ArrayList<String>(3);
            int nextColumnIndex = 3;
            DynamicObjectCollection dimCol = analysisModel.getDynamicObjectCollection("dimension_entry");
            if (dimCol != null && !dimCol.isEmpty()) {
                block5: for (DynamicObject dimensionRow : dimCol) {
                    DynamicProperty property;
                    DynamicObject dimension2 = dimensionRow.getDynamicObject("dimension");
                    if (dimension2 == null) continue;
                    String fieldNumbers = dimensionRow.getString("field_number_tag");
                    Iterator fieldNumberArr = StringUtils.isNotEmpty((CharSequence)fieldNumbers) ? fieldNumbers.split(",") : null;
                    String dimensionType = dimension2.getString("dimensiontype");
                    if (fieldNumberArr == null && (DimensionTypeEnum.DATABASE.getCodeString().equals(dimensionType) || DimensionTypeEnum.ASSISTANTDATA.getCodeString().equals(dimensionType) || DimensionTypeEnum.PERIOD.getCodeString().equals(dimensionType))) continue;
                    MainEntityType dataEntityType = null;
                    String entityNumber = null;
                    if (DimensionTypeEnum.DATABASE.getCodeString().equals(dimensionType) || DimensionTypeEnum.PERIOD.getCodeString().equals(dimensionType)) {
                        entityNumber = dimension2.getString("dimensionsource_id");
                    } else if (DimensionTypeEnum.ASSISTANTDATA.getCodeString().equals(dimensionType)) {
                        entityNumber = "bos_assistantdata_detail";
                    }
                    if (entityNumber != null) {
                        dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    }
                    OrmLocaleValue dimensionName = (OrmLocaleValue)dimension2.get("name");
                    logger.info(String.format("EntityMetaHelper constructMetadataList dimension OrmLocaleName : %s", JSON.toJSONString((Object)dimensionName)));
                    LocaleString nameLocaleStr = EntityMetaHelper.buildLocaleStringByLocaleValue(dimensionName);
                    String number = dimension2.getString("number").toLowerCase();
                    String necessityDim = dimensionRow.getString("necessity_dim");
                    if (necessityDim != null && !necessityDim.isEmpty()) {
                        necessityDimensionList.add(number);
                        if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                            orgNumber = number;
                        }
                    } else {
                        ordinaryDimensionList.add(number);
                    }
                    int size = fieldNumberArr == null ? 1 : ((Iterator)fieldNumberArr).length;
                    ArrayList<Iterator> refProps = new ArrayList<Iterator>(size);
                    for (int i = 0; i < size; ++i) {
                        Iterator fieldNumber;
                        Iterator iterator = fieldNumber = fieldNumberArr == null ? null : fieldNumberArr[i];
                        if (fieldNumber != null && ((String)((Object)fieldNumber)).contains(".")) continue;
                        ListColumnAp dimensionListColumn = new ListColumnAp();
                        dimensionListColumn.setColumnOrderAndFilter("3");
                        dimensionListColumn.setSeqColumnType("NotSeq");
                        dimensionListColumn.setId(EntityMetaHelper.getMetaDataId());
                        dimensionListColumn.setKey("listcolumnap" + nextColumnIndex);
                        dimensionListColumn.setOrder("NotOrder");
                        dimensionListColumn.setIndex(nextColumnIndex);
                        dimensionListColumn.setParentId("gridview");
                        if (fieldNumber == null) {
                            dimensionListColumn.setListFieldId(number);
                            dimensionListColumn.setName(nameLocaleStr);
                        } else {
                            String showFieldNumber = number + "." + (String)((Object)fieldNumber);
                            dimensionListColumn.setListFieldId(showFieldNumber);
                            if (dataEntityType != null && (property = dataEntityType.getProperty((String)((Object)fieldNumber))) != null) {
                                LocaleString currentDisplayName = property.getDisplayName();
                                if (currentDisplayName == null) continue;
                                LocaleString showFieldLocaleStr = EntityMetaHelper.buildLocaleStringByField(dimensionName.getLocaleValue() + "." + currentDisplayName.getLocaleValue(), dimensionName.getLocaleValue_zh_CN() + "." + currentDisplayName.getLocaleValue_zh_CN(), dimensionName.getLocaleValue_en() + "." + currentDisplayName.getLocaleValue_en(), dimensionName.getLocaleValue_zh_TW() + "." + currentDisplayName.getLocaleValue_zh_TW(), dimensionName.getItem(LanguageGLang) + "." + (String)currentDisplayName.getItem(LanguageGLang));
                                dimensionListColumn.setName(showFieldLocaleStr);
                            }
                        }
                        items.add(dimensionListColumn);
                        ++nextColumnIndex;
                        refProps.add(fieldNumber);
                    }
                    for (EntityItem entityItem : entityMetaItemList) {
                        BasedataField basedataField;
                        if (!(entityItem instanceof BasedataField) || !number.equals((basedataField = (BasedataField)entityItem).getKey())) continue;
                        List currentRefPropList = basedataField.getRefProps();
                        for (RefProp currentProp : currentRefPropList) {
                            String currentPropName = currentProp.getName();
                            refProps.remove(currentPropName);
                        }
                        property = refProps.iterator();
                        while (property.hasNext()) {
                            String refPropName = (String)property.next();
                            currentRefPropList.add(new RefProp(refPropName));
                        }
                        continue block5;
                    }
                }
            }
            ArrayList<String> calculationMeasureList = new ArrayList<String>(1);
            ArrayList<String> ordinaryMeasureList = new ArrayList<String>(2);
            int nextMeasureMark = 0;
            DynamicObjectCollection measureCol = analysisModel.getDynamicObjectCollection("measure_entry");
            if (measureCol != null && !measureCol.isEmpty()) {
                for (Object measureRow : measureCol) {
                    DynamicObject measure = measureRow.getDynamicObject("measure");
                    if (measure == null) continue;
                    OrmLocaleValue measureName = (OrmLocaleValue)measure.get("name");
                    logger.info(String.format("EntityMetaHelper constructMetadataList measure OrmLocaleName : %s", JSON.toJSONString((Object)measureName)));
                    String number = measure.getString("number").toLowerCase();
                    String measureType = measure.getString("measuretype");
                    if (measureType.equals(String.valueOf(MeasureTypeEnum.CALCULATION.getCode()))) {
                        calculationMeasureList.add(number);
                        continue;
                    }
                    if (measureType.equals(String.valueOf(MeasureTypeEnum.ORDINARY.getCode()))) {
                        ordinaryMeasureList.add(number);
                    }
                    DecimalListColumnAp decimalListColumn = new DecimalListColumnAp();
                    decimalListColumn.setColumnOrderAndFilter("3");
                    decimalListColumn.setSeqColumnType("NotSeq");
                    decimalListColumn.setId(EntityMetaHelper.getMetaDataId());
                    decimalListColumn.setKey("decimallistcolumnap" + (nextMeasureMark != 0 ? Integer.valueOf(nextMeasureMark) : ""));
                    decimalListColumn.setOrder("NotOrder");
                    decimalListColumn.setIndex(nextColumnIndex);
                    decimalListColumn.setParentId("gridview");
                    decimalListColumn.setListFieldId(number);
                    decimalListColumn.setName(EntityMetaHelper.buildLocaleStringByLocaleValue(measureName));
                    items.add(decimalListColumn);
                    ++nextMeasureMark;
                    ++nextColumnIndex;
                }
            }
            List<String> backGroundColumnList = Arrays.asList("operationstatus", "datastatus", "del", "collectstatus", "situationtype", "offstatus", "createtime", "id", "summaryid", "sourceformid", "sourcebillid", "execlogid", "subexeclogid", "execparentbillid", "createstamp", "dimhash");
            for (EntityItem entityItem : entityMetaItemList) {
                if (!(entityItem instanceof Field)) continue;
                Field field = (Field)entityItem;
                Features features = field.getFeatures();
                String key = entityItem.getKey().toLowerCase();
                if ("importbatch".equals(key)) {
                    if (field instanceof TextField) {
                        TextField textField = (TextField)field;
                        textField.setDefValue(" ");
                    }
                    field.setMustInput(true);
                    continue;
                }
                if (backGroundColumnList.contains(key)) {
                    field.setMustInput(false);
                    features.setImportable(false);
                    features.setExportable(false);
                    continue;
                }
                if (necessityDimensionList.contains(key)) {
                    field.setMustInput(true);
                    continue;
                }
                if (ordinaryDimensionList.contains(key) || ordinaryMeasureList.contains(key)) {
                    field.setMustInput(false);
                    continue;
                }
                if (!calculationMeasureList.contains(key)) continue;
                field.setMustInput(false);
                features.setImportable(false);
            }
            FilterColumnAp importBatch = new FilterColumnAp();
            importBatch.setFieldName("importbatch");
            importBatch.setId(EntityMetaHelper.getMetaDataId());
            importBatch.setKey("filtercolumnap");
            importBatch.setParentId("fastsearchgridview");
            importBatch.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u6279\u6b21\u53f7", (String)"EntityMetaHelper_44", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_44", (String)"macc-faf-common"));
            items.add(importBatch);
            CommonBaseDataFilterColumnAp orgBaseDataFilter = new CommonBaseDataFilterColumnAp();
            orgBaseDataFilter.setType("text");
            orgBaseDataFilter.setMulti(false);
            orgBaseDataFilter.setId(EntityMetaHelper.getMetaDataId());
            orgBaseDataFilter.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"EntityMetaHelper_46", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_46", (String)"macc-faf-common"));
            orgBaseDataFilter.setFieldName(orgNumber + ".name");
            orgBaseDataFilter.setKey("commonbasedatafiltercolumnap");
            orgBaseDataFilter.setParentId("filtergridview");
            orgBaseDataFilter.setBaseEntityId("73f9bf0200001dac");
            items.add(orgBaseDataFilter);
            DynamicObject periodDimension = DimensionDyUtil.loopDoDimensionNecessity(analysisModel.getLong("id"), dimension -> dimension).get((Object)DimensionNecessityEnum.PERIOD);
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum(periodDimension.getString("dimensiontype"));
            if (DimensionTypeEnum.DATABASE == dimensionType && "bd_period".equals(periodDimension.getDynamicObject("dimensionsource").getString("number"))) {
                CommonBaseDataFilterColumnAp periodBaseDataFilter = new CommonBaseDataFilterColumnAp();
                periodBaseDataFilter.setType("text");
                periodBaseDataFilter.setMulti(false);
                periodBaseDataFilter.setId(EntityMetaHelper.getMetaDataId());
                periodBaseDataFilter.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u671f\u95f4", (String)"EntityMetaHelper_51", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_51", (String)"macc-faf-common"));
                periodBaseDataFilter.setFieldName(periodDimension.getString("number").toLowerCase() + ".name");
                periodBaseDataFilter.setKey("periodcommonbasedatafiltercolumnap");
                periodBaseDataFilter.setParentId("filtergridview");
                periodBaseDataFilter.setBaseEntityId("827b2b290000d5ac");
                periodBaseDataFilter.setMustInput(true);
                items.add(periodBaseDataFilter);
            }
            CommonDateFilterColumnAp createTimeDateFilter = new CommonDateFilterColumnAp();
            createTimeDateFilter.setType("datetime");
            createTimeDateFilter.setMulti(false);
            createTimeDateFilter.setId(EntityMetaHelper.getMetaDataId());
            createTimeDateFilter.setIndex(1);
            createTimeDateFilter.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"EntityMetaHelper_45", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_45", (String)"macc-faf-common"));
            createTimeDateFilter.setFieldName("createtime");
            createTimeDateFilter.setKey("commondatefiltercolumnap");
            createTimeDateFilter.setCustom(true);
            createTimeDateFilter.setParentId("filtergridview");
            items.add(createTimeDateFilter);
            if (!CollectionUtils.isEmpty((Collection)dimCol)) {
                Set baseEntityNumbers = dimCol.stream().filter(dimEntry -> DimensionTypeEnum.DATABASE == DimensionTypeEnum.getEnum(dimEntry.getDynamicObject("dimension").getString("dimensiontype"))).map(dimEntry -> dimEntry.getDynamicObject("dimension").getDynamicObject("dimensionsource").getString("number")).collect(Collectors.toSet());
                baseEntityNumbers.add("bos_assistantdata_detail");
                Map<String, String> baseEntityNumberIdMap = QueryServiceHelper.query((String)"bos_entitymeta", (String)"id,number", (QFilter[])new QFilter("number", "in", baseEntityNumbers).toArray()).stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("id")));
                block12: for (DynamicObject dimEntry2 : dimCol) {
                    DynamicObject dimension3 = dimEntry2.getDynamicObject("dimension");
                    DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(dimension3.getString("dimensiontype"));
                    String dimensionNumber = dimension3.getString("number").toLowerCase();
                    switch (dimensionTypeEnum) {
                        case DATABASE: {
                            SchemeBaseDataFilterColumnAp baseDataSchemeFilter = new SchemeBaseDataFilterColumnAp();
                            baseDataSchemeFilter.setId(EntityMetaHelper.getMetaDataId());
                            baseDataSchemeFilter.setName(new LocaleString(dimension3.getString("name")));
                            baseDataSchemeFilter.setFieldName(dimensionNumber + ".name");
                            baseDataSchemeFilter.setKey("schemebasedata" + dimensionNumber);
                            baseDataSchemeFilter.setParentId("schemefilterview");
                            baseDataSchemeFilter.setBaseEntityId(baseEntityNumberIdMap.get(dimension3.getDynamicObject("dimensionsource").getString("number")));
                            items.add(baseDataSchemeFilter);
                            continue block12;
                        }
                        case ASSISTANTDATA: {
                            SchemeBaseDataFilterColumnAp assistantDataSchemeFilter = new SchemeBaseDataFilterColumnAp();
                            assistantDataSchemeFilter.setId(EntityMetaHelper.getMetaDataId());
                            assistantDataSchemeFilter.setName(new LocaleString(dimension3.getString("name")));
                            assistantDataSchemeFilter.setFieldName(dimensionNumber + ".name");
                            assistantDataSchemeFilter.setKey("schemebasedata" + dimensionNumber);
                            assistantDataSchemeFilter.setParentId("schemefilterview");
                            assistantDataSchemeFilter.setBaseEntityId(baseEntityNumberIdMap.get("bos_assistantdata_detail"));
                            items.add(assistantDataSchemeFilter);
                            continue block12;
                        }
                        case DENUMS: {
                            DynamicObjectCollection enums = dimension3.getDynamicObjectCollection("entryentityenums");
                            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(enums.size());
                            int i = 0;
                            for (DynamicObject enumDimension : enums) {
                                comboItems.add(new ComboItem(i, new LocaleString(enumDimension.getString("title")), enumDimension.getString("value")));
                                ++i;
                            }
                            SchemeComboFilterColumnAp enumSchemeFilter = new SchemeComboFilterColumnAp();
                            enumSchemeFilter.setId(EntityMetaHelper.getMetaDataId());
                            enumSchemeFilter.setName(new LocaleString(dimension3.getString("name")));
                            enumSchemeFilter.setFieldName(dimensionNumber);
                            enumSchemeFilter.setKey("schemebasedata" + dimensionNumber);
                            enumSchemeFilter.setParentId("schemefilterview");
                            enumSchemeFilter.setComboItems(comboItems);
                            items.add(enumSchemeFilter);
                            continue block12;
                        }
                    }
                    SchemeFilterColumnAp schemeFilter = new SchemeFilterColumnAp();
                    schemeFilter.setId(EntityMetaHelper.getMetaDataId());
                    schemeFilter.setName(new LocaleString(dimension3.getString("name")));
                    schemeFilter.setFieldName(dimensionNumber);
                    schemeFilter.setKey("schemebasedata" + dimensionNumber);
                    schemeFilter.setParentId("schemefilterview");
                    items.add(schemeFilter);
                }
            }
            SchemeFilterColumnAp createTimeSchemeFilter = new SchemeFilterColumnAp();
            createTimeSchemeFilter.setFieldName("createtime");
            createTimeSchemeFilter.setId(EntityMetaHelper.getMetaDataId());
            createTimeSchemeFilter.setKey("schemefiltercolumnap");
            createTimeSchemeFilter.setIndex(2);
            createTimeSchemeFilter.setParentId("schemefilterview");
            createTimeSchemeFilter.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"EntityMetaHelper_45", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_45", (String)"macc-faf-common"));
            items.add(createTimeSchemeFilter);
        }
        MainEntity rootEntity = entityMeta.getRootEntity();
        BusinessControl businessControl = new BusinessControl();
        businessControl.setEnableImport(true);
        businessControl.setQingAnalysis(true);
        rootEntity.setBusinessControl(businessControl);
        HashMap<String, Object> customProperties = rootEntity.getCustomProperties();
        if (customProperties == null) {
            customProperties = new HashMap<String, Object>(1);
            rootEntity.setCustomProperties(customProperties);
        }
        customProperties.put("analysis_model", analysisModel.get("id"));
        List operationList = rootEntity.getOperations();
        operationList.clear();
        Operation exportDataOnImportModelOperation = new Operation();
        exportDataOnImportModelOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5bfc\u5165\u6a21\u677f\uff09", (String)"EntityMetaHelper_35", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_35", (String)"macc-faf-common"));
        exportDataOnImportModelOperation.setOperationType("exportlist");
        exportDataOnImportModelOperation.setId(EntityMetaHelper.getMetaDataId());
        exportDataOnImportModelOperation.setKey("exportlist");
        operationList.add(exportDataOnImportModelOperation);
        Operation importDataOperation = new Operation();
        importDataOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"EntityMetaHelper_33", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_33", (String)"macc-faf-common"));
        importDataOperation.setOperationType("importdata");
        importDataOperation.setId(EntityMetaHelper.getMetaDataId());
        importDataOperation.setKey("importdata");
        ImportParameter importParameter = new ImportParameter();
        String pluginDescription = ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6570\u636e\u5b8c\u6bd5\u540e\u8c03\u7528\u6c47\u603b\u8ba1\u7b97\u7684\u63d2\u4ef6", (String)"EntityMetaHelper_25", (String)"macc-faf-common", (Object[])new Object[0]);
        importParameter.setPlugins("[{\"FPK\":\"\",\"Type\":0,\"Description\":\"" + pluginDescription + "\",\"RowKey\":0,\"ClassName\":\"kd.macc.faf.system.FAFAfterSuccessfulImportDataFormPlugin\",\"DisplayName\":\"\",\"Enabled\":true,\"BizAppId\":\"\",\"Inherit\":false}]");
        importDataOperation.setParameter((OperationParameter)importParameter);
        operationList.add(importDataOperation);
        Operation deleteOperation = new Operation();
        DelParameter delParameter = new DelParameter();
        delParameter.setOperationKey("next");
        delParameter.setListDelScope("seldata");
        deleteOperation.setParameter((OperationParameter)delParameter);
        deleteOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityMetaHelper_39", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_39", (String)"macc-faf-common"));
        deleteOperation.setOperationType("delete");
        deleteOperation.setId(EntityMetaHelper.getMetaDataId());
        deleteOperation.setKey("delete");
        Plugin deletePlugin = new Plugin();
        deletePlugin.setDescription(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5220\u9664\u5bfc\u5165\u6570\u636e\u6821\u9a8c", (String)"EntityMetaHelper_47", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_47", (String)"macc-faf-common").toString());
        deletePlugin.setClassName("kd.macc.faf.system.opplugin.FAFImportDataDeleteOp");
        deletePlugin.setEnabled(true);
        deleteOperation.getPlugins().add(deletePlugin);
        operationList.add(deleteOperation);
        Operation refreshOperation = new Operation();
        refreshOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5237\u65b0", (String)"EntityMetaHelper_40", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_40", (String)"macc-faf-common"));
        refreshOperation.setOperationType("refresh");
        refreshOperation.setId(EntityMetaHelper.getMetaDataId());
        refreshOperation.setKey("refresh");
        operationList.add(refreshOperation);
        Operation viewImportResultOperation = new Operation();
        viewImportResultOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", (String)"EntityMetaHelper_34", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_34", (String)"macc-faf-common"));
        viewImportResultOperation.setOperationType("importdetails");
        viewImportResultOperation.setId(EntityMetaHelper.getMetaDataId());
        viewImportResultOperation.setKey("importdetails");
        operationList.add(viewImportResultOperation);
        Operation viewExportResultOperation = new Operation();
        viewExportResultOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", (String)"EntityMetaHelper_37", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_37", (String)"macc-faf-common"));
        viewExportResultOperation.setOperationType("exportdetails");
        viewExportResultOperation.setId(EntityMetaHelper.getMetaDataId());
        viewExportResultOperation.setKey("exportdetails");
        operationList.add(viewExportResultOperation);
        Operation exportDataOnExportModelOperation = new Operation();
        exportDataOnExportModelOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5bfc\u51fa\u6a21\u677f\uff09", (String)"EntityMetaHelper_36", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_36", (String)"macc-faf-common"));
        exportDataOnExportModelOperation.setOperationType("exportlist_expt");
        exportDataOnExportModelOperation.setId(EntityMetaHelper.getMetaDataId());
        exportDataOnExportModelOperation.setKey("exportlist_expt");
        operationList.add(exportDataOnExportModelOperation);
        Operation closeOperation = new Operation();
        closeOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5173\u95ed\u9875\u9762", (String)"EntityMetaHelper_48", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_48", (String)"macc-faf-common"));
        closeOperation.setOperationType("close");
        closeOperation.setId(EntityMetaHelper.getMetaDataId());
        closeOperation.setKey("btn_close");
        operationList.add(closeOperation);
        Operation saveOperation = new Operation();
        saveOperation.setName(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EntityMetaHelper_49", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_49", (String)"macc-faf-common"));
        saveOperation.setOperationType("save");
        saveOperation.setId(EntityMetaHelper.getMetaDataId());
        saveOperation.setKey("save");
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(1);
        Plugin saveOpPlugin = new Plugin();
        saveOpPlugin.setDescription(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u524d\u7f6e\u63d2\u4ef6", (String)"EntityMetaHelper_50", (String)"macc-faf-common", (Object[])new Object[0]), (String)"EntityMetaHelper_50", (String)"macc-faf-common").toString());
        saveOpPlugin.setClassName("kd.macc.faf.system.opplugin.FAFAnalysisImportSaveOp");
        saveOpPlugin.setEnabled(true);
        plugins.add(saveOpPlugin);
        saveOperation.setPlugins(plugins);
        SaveParameter saveParameter = new SaveParameter();
        saveParameter.setAfterOperation("default");
        saveOperation.setParameter((OperationParameter)saveParameter);
        operationList.add(saveOperation);
    }

    public static String getMetaDataId() {
        return Base39Coder.toString((long)IDService.get().genLongId());
    }

    private static LocaleString buildLocaleStringByLocaleValue(OrmLocaleValue localeValue) {
        LocaleString result = new LocaleString();
        result.setLocaleValue(localeValue.getLocaleValue());
        result.setLocaleValue_zh_CN(localeValue.getLocaleValue_zh_CN());
        result.setLocaleValue_en(localeValue.getLocaleValue_en());
        result.setLocaleValue_zh_TW(localeValue.getLocaleValue_zh_TW());
        result.setItem(LanguageGLang, (Object)localeValue.getItem(LanguageGLang));
        return result;
    }

    private static LocaleString buildLocaleStringByField(String val, String val_zh_CN, String val_en, String val_zh_TW, String gLang) {
        LocaleString result = new LocaleString();
        result.setLocaleValue(val);
        result.setLocaleValue_zh_CN(val_zh_CN);
        result.setLocaleValue_en(val_en);
        result.setLocaleValue_zh_TW(val_zh_TW);
        result.setItem(LanguageGLang, (Object)gLang);
        return result;
    }
}

