/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.ModelVersionEnum;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMeasureHelper;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFAnalysisModelHelper {
    private static final Log logger = LogFactory.getLog(FAFAnalysisModelHelper.class);

    public static Map<String, DynamicObject[]> queryDimensionAndMeasureById(Object id) {
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_analysismodel"));
        DynamicObjectCollection dimensionCOls = analysisModel.getDynamicObjectCollection("dimension_entry");
        DynamicObject[] dimList = new DynamicObject[dimensionCOls.size()];
        int i = 0;
        for (DynamicObject entry : dimensionCOls) {
            dimList[i] = entry.getDynamicObject("dimension");
            ++i;
        }
        DynamicObjectCollection measureCols = analysisModel.getDynamicObjectCollection("measure_entry");
        DynamicObject[] measureList = new DynamicObject[measureCols.size()];
        i = 0;
        for (DynamicObject entry : measureCols) {
            measureList[i] = entry.getDynamicObject("measure");
            ++i;
        }
        HashMap<String, DynamicObject[]> map = new HashMap<String, DynamicObject[]>(2);
        map.put("dimensionmapentry", dimList);
        map.put("measuremapentry", measureList);
        return map;
    }

    public static DynamicObject loadAnalysisModel(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_analysismodel");
    }

    public static String queryTableNumber(Object id) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"tablenumber", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        if (model != null) {
            return model.getString("tablenumber");
        }
        return null;
    }

    public static boolean isExist(Object id) {
        if (id == null) {
            return false;
        }
        String tableNumber = FAFAnalysisModelHelper.queryTableNumber(id);
        return tableNumber != null && !StringUtils.isEmpty((String)tableNumber) && MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber(tableNumber.toLowerCase(Locale.ENGLISH)));
    }

    public static List<Object> queryAnalysisModelIdsBySysTemId(Object systemId) {
        QFilter systemFilter = new QFilter("analysis_system", "=", systemId);
        QFilter tableNumberFilter = new QFilter("tablenumber", "!=", (Object)" ");
        ArrayList<Object> result = new ArrayList<Object>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAnalysisModelIdsBySysTemId", (String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{systemFilter, tableNumberFilter}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    result.add(row.get("id"));
                }
            }
        }
        return result;
    }

    public static DynamicObjectCollection queryModelByAnaSystem(Object ... anaSystemIds) {
        return QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,name,analysis_system", (QFilter[])new QFilter("analysis_system", "in", (Object)anaSystemIds).toArray(), null);
    }

    public static Map<Long, Map<Long, String>> queryOrgAndPeriodDimension(Long[] modelIds) {
        QFilter modelFilter = new QFilter("id", "in", (Object)modelIds);
        QFilter necessityFilter = new QFilter("dimension_entry.necessity_dim", "in", (Object)new String[]{"0", "1"});
        HashMap<Long, Map<Long, String>> dataMap = new HashMap<Long, Map<Long, String>>(modelIds.length);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryOrgAndPeriodDimension", (String)"pa_analysismodel", (String)"id,dimension_entry.dimension,dimension_entry.necessity_dim", (QFilter[])new QFilter[]{modelFilter, necessityFilter}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    Long modelId = row.getLong("id");
                    HashMap<Long, String> dimMap = (HashMap<Long, String>)dataMap.get(modelId);
                    if (dimMap == null) {
                        dimMap = new HashMap<Long, String>(2);
                        dataMap.put(modelId, dimMap);
                    }
                    dimMap.put(row.getLong("dimension_entry.dimension"), row.getString("dimension_entry.necessity_dim"));
                }
            }
        }
        return dataMap;
    }

    public static Set<Long> queryModelNecessityDimension(Long modelId) {
        HashSet<Long> necessityDimensionSet = new HashSet<Long>(3);
        if (modelId == null) {
            return necessityDimensionSet;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PAAnalysisModelHelper.queryModelNecessityDimension", (String)"pa_analysismodel", (String)"dimension_entry.dimension,dimension_entry.necessity_dim", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String nececssity = row.getString("dimension_entry.necessity_dim");
                    DimensionNecessityEnum enums = DimensionNecessityEnum.getEnum(nececssity);
                    if (enums == null) continue;
                    necessityDimensionSet.add(row.getLong("dimension_entry.dimension"));
                }
            }
        }
        return necessityDimensionSet;
    }

    public static DynamicObject queryModelNecessityTimeDimension(Long modelId) {
        QFilter idFilter = new QFilter("id", "=", (Object)modelId);
        QFilter dimFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        return QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"id,dimension_entry.dimension.dimensiontype,dimension_entry.dimension.dimensionsource,dimension_entry.dimension.group", (QFilter[])new QFilter[]{idFilter, dimFilter});
    }

    public static DynamicObjectCollection queryModelDateDimensionList() {
        QFilter dimFilter = new QFilter("dimension_entry.necessity_dim", "=", (Object)DimensionNecessityEnum.PERIOD.getCode());
        QFilter dimTypeFilter = new QFilter("dimension_entry.dimension.dimensiontype", "=", (Object)DimensionTypeEnum.DATE.getCodeString());
        return QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{dimFilter, dimTypeFilter});
    }

    public static Tuple<ImportSystemSourceTypeEnum, Long> getModelSystemSourceInfo(Long anaSystemModelId) {
        DynamicObject analysisModel = FAFAnalysisModelHelper.loadAnalysisModel(anaSystemModelId);
        long modelEPMModelId = 0L;
        ImportSystemSourceTypeEnum importSystemSourceTypeEnum = ImportSystemSourceTypeEnum.NEW;
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject entry : dimensionEntry) {
            DynamicObject dimension = entry.getDynamicObject("dimension");
            ImportSystemSourceTypeEnum dimensionSystemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode(dimension.getString("systemsource"));
            if (dimensionSystemSourceTypeEnum == ImportSystemSourceTypeEnum.NEW) continue;
            ArrayList<Object> dimensionIds = new ArrayList<Object>();
            dimensionIds.add(dimension.getLong("id"));
            DynamicObjectCollection dynamicObjects = FAFDimensionHelper.queryDimensionMappingByDimensionIds(dimensionIds, dimensionSystemSourceTypeEnum);
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
            modelEPMModelId = ((DynamicObject)dynamicObjects.get(0)).getLong("immodel");
            importSystemSourceTypeEnum = dimensionSystemSourceTypeEnum;
            break;
        }
        if (modelEPMModelId == 0L) {
            DynamicObjectCollection measureEntry = analysisModel.getDynamicObjectCollection("measure_entry");
            for (DynamicObject entry : measureEntry) {
                DynamicObject measure = entry.getDynamicObject("measure");
                ImportSystemSourceTypeEnum measureSystemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode(measure.getString("systemsource"));
                if (measureSystemSourceTypeEnum == ImportSystemSourceTypeEnum.NEW) continue;
                ArrayList<Object> measureIds = new ArrayList<Object>();
                measureIds.add(measure.getLong("id"));
                DynamicObjectCollection dynamicObjects = FAFMeasureHelper.queryMeasureMappingByMeasureIds(measureIds, measureSystemSourceTypeEnum);
                if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
                modelEPMModelId = ((DynamicObject)dynamicObjects.get(0)).getLong("immodel");
                importSystemSourceTypeEnum = measureSystemSourceTypeEnum;
                break;
            }
        }
        if (modelEPMModelId == 0L) {
            return null;
        }
        return new Tuple((Object)importSystemSourceTypeEnum, (Object)modelEPMModelId);
    }

    public static QFilter getBaseQFilter(DynamicObject anaModel, String necessityDim) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (anaModel == null || necessityDim == null) {
            return qFilter;
        }
        DynamicObject dimension = FAFAnalysisModelHelper.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return qFilter;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
        if (DimensionTypeEnum.DATABASE == dimType) {
            String typeField = dimension.getString("typefield");
            Object groupId = dimension.get("group_id");
            if (StringUtils.isNotEmpty((String)typeField)) {
                qFilter = new QFilter(typeField, "=", groupId);
            }
        } else {
            Object groupId = dimension.get("assistantsource_id");
            qFilter = new QFilter("group", "=", groupId);
        }
        return qFilter;
    }

    public static DynamicObject getDimension(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null || necessityDim == null) {
            return null;
        }
        DynamicObjectCollection dimEntryCol = anaModel.getDynamicObjectCollection("dimension_entry");
        long dimId = 0L;
        for (DynamicObject dyo : dimEntryCol) {
            if (!necessityDim.equals(dyo.getString("necessity_dim"))) continue;
            dimId = dyo.getLong("dimension_id");
            break;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"pa_dimension");
    }

    public static String getBaseEntityId(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null || necessityDim == null) {
            return null;
        }
        DynamicObject dimension = FAFAnalysisModelHelper.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return null;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
        switch (dimType) {
            case PERIOD: 
            case DATABASE: {
                return dimension.getDynamicObject("dimensionsource").getString("number");
            }
            case ASSISTANTDATA: {
                return "bos_assistantdata_detail";
            }
        }
        return "";
    }

    public static boolean isModelNewVersion(Long analysisModelId) {
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel", (String)"version,tablenumber");
        return FAFAnalysisModelHelper.isModelNewVersion(analysisModel);
    }

    public static boolean isModelNewVersion(DynamicObject analysisModel) {
        if (analysisModel == null) {
            return false;
        }
        String tableNumber = analysisModel.getString("tablenumber");
        if (StringUtils.isEmpty((String)tableNumber)) {
            return false;
        }
        if (analysisModel.getDynamicObjectType().getProperties().get((Object)"version") != null) {
            logger.info("tableNumber checkNumber:" + MetadataDao.checkNumber((String)AnalysisModelUtil.buildDetailEntityNumber(tableNumber)));
            logger.info("model COLUMN_VERSION:" + analysisModel.get("version"));
        }
        return analysisModel.getDynamicObjectType().getProperties().get((Object)"version") != null && ModelVersionEnum.new_version.getCodeStr().equals(String.valueOf(analysisModel.get("version"))) && MetadataDao.checkNumber((String)AnalysisModelUtil.buildDetailEntityNumber(tableNumber));
    }

    public static void upgradeModelVersion(Long modelId) {
        DB.execute((DBRoute)DBRoute.of((String)"fias"), (String)"update t_pa_analysismodel set fversion = '1' where fid = ?", (Object[])new Object[]{modelId});
    }
}

