/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.designer.FAFEntityMetadata;

public class FAFAnasystemSettingHelper {
    public static final String[] defaultFields = new String[]{"name", "number"};

    public static DynamicObject getAnasystemSettingById(Object id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_anasystemsetting"));
    }

    public static Map<String, Integer> getAnaSystemEachPropertyCount(Long systemId) {
        HashMap<String, Integer> propertyMap = new HashMap<String, Integer>();
        int dimensionCount = ORM.create().count("faf_count_1", "pa_dimension", new QFilter("system", "=", (Object)systemId).toArray());
        propertyMap.put("pa_dimension", dimensionCount);
        int measureCount = ORM.create().count("faf_count_2", "pa_measure", new QFilter("system", "=", (Object)systemId).toArray());
        propertyMap.put("pa_measure", measureCount);
        int modelCount = ORM.create().count("faf_count_3", "pa_analysismodel", new QFilter("analysis_system", "=", (Object)systemId).toArray());
        propertyMap.put("pa_analysismodel", modelCount);
        int mappingCount = ORM.create().count("faf_count_4", "pa_mappingrelationship", new QFilter("anasystem", "=", (Object)systemId).toArray());
        propertyMap.put("pa_mappingrelationship", mappingCount);
        int schemaCount = ORM.create().count("faf_count_5", "pa_syncdataschema", new QFilter("model", "=", (Object)systemId).toArray());
        propertyMap.put("pa_syncdataschema", schemaCount);
        return propertyMap;
    }

    public static void presetDefaultDimAndMeasureUnderCurrentAnaSystem(Long anaSystemId) {
        QFilter dimNumberFilter = new QFilter("number", "in", new ArrayList<String>(Arrays.asList("org", "period", "account")));
        QFilter anaSystemFilter = new QFilter("system", "=", (Object)anaSystemId);
        List existDefaultDimNumber = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (String)"number", (QFilter[])new QFilter[]{dimNumberFilter, anaSystemFilter}).values().stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        ArrayList<DynamicObject> saveDimensionList = new ArrayList<DynamicObject>();
        if (!existDefaultDimNumber.contains("org")) {
            saveDimensionList.add(FAFAnasystemSettingHelper.createDimOfOrg(anaSystemId));
        }
        if (!existDefaultDimNumber.contains("period")) {
            saveDimensionList.add(FAFAnasystemSettingHelper.createDimOfPeriod(anaSystemId));
        }
        if (!existDefaultDimNumber.contains("account")) {
            saveDimensionList.add(FAFAnasystemSettingHelper.createDimOfAccount(anaSystemId));
        }
        if (saveDimensionList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])saveDimensionList.toArray(new DynamicObject[0]));
        }
        QFilter measureNumberFilter = new QFilter("number", "in", new ArrayList<String>(Arrays.asList("current_period", "ending_balance", "beginning_balance", "quarter_to_date", "year_to_date")));
        List existDefaultMeasureNumber = BusinessDataServiceHelper.loadFromCache((String)"pa_measure", (String)"number", (QFilter[])new QFilter[]{measureNumberFilter, anaSystemFilter}).values().stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        ArrayList<DynamicObject> saveMeasureList = new ArrayList<DynamicObject>();
        if (!existDefaultMeasureNumber.contains("currentperiod")) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{FAFAnasystemSettingHelper.createCommonMeasure(ResManager.loadKDString((String)"\u672c\u671f", (String)"FAFAnasystemSettingHelper_0", (String)"macc-faf-common", (Object[])new Object[0]), "current_period", anaSystemId)});
        }
        if (!existDefaultMeasureNumber.contains("bop")) {
            saveMeasureList.add(FAFAnasystemSettingHelper.createCommonMeasure(ResManager.loadKDString((String)"\u671f\u521d", (String)"FAFAnasystemSettingHelper_1", (String)"macc-faf-common", (Object[])new Object[0]), "beginning_balance", anaSystemId));
        }
        if (!existDefaultMeasureNumber.contains("ending_balance")) {
            saveMeasureList.add(FAFAnasystemSettingHelper.createCommonMeasure(ResManager.loadKDString((String)"\u671f\u672b", (String)"FAFAnasystemSettingHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), "ending_balance", anaSystemId));
        }
        if (!existDefaultMeasureNumber.contains("quarter_to_date")) {
            saveMeasureList.add(FAFAnasystemSettingHelper.createMeasureOfQTD(anaSystemId));
        }
        if (!existDefaultMeasureNumber.contains("year_to_date")) {
            saveMeasureList.add(FAFAnasystemSettingHelper.createMeasureOfYTD(anaSystemId));
        }
        if (saveMeasureList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])saveMeasureList.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject createMeasureOfYTD(Long anaSystemId) {
        DynamicObject measureOfYTD = BusinessDataServiceHelper.newDynamicObject((String)"pa_measure");
        measureOfYTD.set("number", (Object)"year_to_date");
        measureOfYTD.set("name", (Object)ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"FAFAnasystemSettingHelper_3", (String)"macc-faf-common", (Object[])new Object[0]));
        measureOfYTD.set("status", (Object)"C");
        measureOfYTD.set("creator", (Object)RequestContext.get().getCurrUserId());
        measureOfYTD.set("enable", (Object)"1");
        measureOfYTD.set("createtime", (Object)new Date());
        measureOfYTD.set("system", (Object)anaSystemId);
        measureOfYTD.set("isdefault", (Object)"1");
        measureOfYTD.set("measuretype", (Object)"2");
        measureOfYTD.set("aggregationtype", (Object)"1");
        measureOfYTD.set("situationtype", (Object)"0");
        measureOfYTD.set("systemsource", (Object)"0");
        measureOfYTD.set("precision", (Object)2);
        QFilter calcMeasureNumberFilter = new QFilter("number", "=", (Object)"current_period");
        QFilter anaSystemFilter = new QFilter("system", "=", (Object)anaSystemId);
        Long currentPeriodFid = BusinessDataServiceHelper.loadSingle((String)"pa_measure", (String)"id", (QFilter[])new QFilter[]{calcMeasureNumberFilter, anaSystemFilter}).getLong("id");
        measureOfYTD.set("measure", (Object)currentPeriodFid);
        QFilter aggNumberFilter = new QFilter("number", "=", (Object)"period");
        Long periodFid = BusinessDataServiceHelper.loadSingle((String)"pa_dimension", (String)"id", (QFilter[])new QFilter[]{aggNumberFilter, anaSystemFilter}).getLong("id");
        measureOfYTD.set("dimension", (Object)periodFid);
        measureOfYTD.set("dimensionattr", (Object)ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6", (String)"FAFAnasystemSettingHelper_4", (String)"macc-faf-common", (Object[])new Object[0]));
        measureOfYTD.set("dimensionattrnb", (Object)"periodyear");
        return measureOfYTD;
    }

    private static DynamicObject createMeasureOfQTD(Long anaSystemId) {
        DynamicObject measureOfQTD = BusinessDataServiceHelper.newDynamicObject((String)"pa_measure");
        measureOfQTD.set("number", (Object)"quarter_to_date");
        measureOfQTD.set("name", (Object)ResManager.loadKDString((String)"\u672c\u5b63\u7d2f\u8ba1", (String)"FAFAnasystemSettingHelper_5", (String)"macc-faf-common", (Object[])new Object[0]));
        measureOfQTD.set("status", (Object)"C");
        measureOfQTD.set("creator", (Object)RequestContext.get().getCurrUserId());
        measureOfQTD.set("enable", (Object)"1");
        measureOfQTD.set("createtime", (Object)new Date());
        measureOfQTD.set("system", (Object)anaSystemId);
        measureOfQTD.set("isdefault", (Object)"1");
        measureOfQTD.set("measuretype", (Object)"2");
        measureOfQTD.set("aggregationtype", (Object)"1");
        measureOfQTD.set("situationtype", (Object)"0");
        measureOfQTD.set("systemsource", (Object)"0");
        measureOfQTD.set("precision", (Object)2);
        QFilter calcMeasureNumberFilter = new QFilter("number", "=", (Object)"current_period");
        QFilter anaSystemFilter = new QFilter("system", "=", (Object)anaSystemId);
        Long currentPeriodFid = BusinessDataServiceHelper.loadSingle((String)"pa_measure", (String)"id", (QFilter[])new QFilter[]{calcMeasureNumberFilter, anaSystemFilter}).getLong("id");
        measureOfQTD.set("measure", (Object)currentPeriodFid);
        QFilter aggNumberFilter = new QFilter("number", "=", (Object)"period");
        Long periodFid = BusinessDataServiceHelper.loadSingle((String)"pa_dimension", (String)"id", (QFilter[])new QFilter[]{aggNumberFilter, anaSystemFilter}).getLong("id");
        measureOfQTD.set("dimension", (Object)periodFid);
        measureOfQTD.set("dimensionattr", (Object)ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6,\u4f1a\u8ba1\u5b63\u5ea6", (String)"FAFAnasystemSettingHelper_6", (String)"macc-faf-common", (Object[])new Object[0]));
        measureOfQTD.set("dimensionattrnb", (Object)"periodyear,periodquarter");
        return measureOfQTD;
    }

    private static DynamicObject createCommonMeasure(String name, String number, Long anaSystemId) {
        DynamicObject commonMeasure = BusinessDataServiceHelper.newDynamicObject((String)"pa_measure");
        commonMeasure.set("number", (Object)number);
        commonMeasure.set("name", (Object)name);
        commonMeasure.set("status", (Object)"C");
        commonMeasure.set("creator", (Object)RequestContext.get().getCurrUserId());
        commonMeasure.set("enable", (Object)"1");
        commonMeasure.set("createtime", (Object)new Date());
        commonMeasure.set("system", (Object)anaSystemId);
        commonMeasure.set("isdefault", (Object)"1");
        commonMeasure.set("measuretype", (Object)"1");
        commonMeasure.set("situationtype", (Object)"0");
        commonMeasure.set("systemsource", (Object)"0");
        commonMeasure.set("precision", (Object)2);
        return commonMeasure;
    }

    private static DynamicObject createDimOfAccount(Long anaSystemId) {
        DynamicObject accountDimension = BusinessDataServiceHelper.newDynamicObject((String)"pa_dimension");
        accountDimension.set("number", (Object)"account");
        accountDimension.set("name", (Object)ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee", (String)"FAFAnasystemSettingHelper_7", (String)"macc-faf-common", (Object[])new Object[0]));
        accountDimension.set("status", (Object)"C");
        accountDimension.set("creator", (Object)RequestContext.get().getCurrUserId());
        accountDimension.set("enable", (Object)"1");
        accountDimension.set("createtime", (Object)new Date());
        accountDimension.set("system", (Object)anaSystemId);
        accountDimension.set("isdefault", (Object)"1");
        accountDimension.set("dimensiontype", (Object)"1");
        String accountEntityFid = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"bd_accountview").toArray()).getString("id");
        accountDimension.set("dimensionsource", (Object)accountEntityFid);
        accountDimension.set("typefield", (Object)"accounttable");
        accountDimension.set("grouptype", (Object)"bd_accounttable");
        accountDimension.set("systemsource", (Object)"0");
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bd_accounttable", (QFilter[])new QFilter[0], (String)"id", (int)1);
        accountDimension.set("group_id", primaryKeys.stream().findFirst().orElseGet(() -> null));
        DynamicObjectCollection periodDimensionEntryEntity = accountDimension.getDynamicObjectCollection("dimensionentryentity");
        FAFEntityMetadata entityMetadata = new FAFEntityMetadata("bd_accountview");
        for (String defaultField : defaultFields) {
            DynamicObject dynamicObject = periodDimensionEntryEntity.addNew();
            FAFEntityMetadata.RefFieldProp refFieldProp = entityMetadata.getRefFieldProp(defaultField);
            if (refFieldProp == null) continue;
            dynamicObject.set("fieldname", (Object)refFieldProp.getDisplayName());
            dynamicObject.set("fieldnumber", (Object)refFieldProp.getName());
            dynamicObject.set("datatype", (Object)refFieldProp.getType());
        }
        return accountDimension;
    }

    private static DynamicObject createDimOfPeriod(Long anaSystemId) {
        DynamicObject periodDimension = BusinessDataServiceHelper.newDynamicObject((String)"pa_dimension");
        periodDimension.set("number", (Object)"period");
        periodDimension.set("name", (Object)ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4", (String)"FAFAnasystemSettingHelper_8", (String)"macc-faf-common", (Object[])new Object[0]));
        periodDimension.set("status", (Object)"C");
        periodDimension.set("creator", (Object)RequestContext.get().getCurrUserId());
        periodDimension.set("enable", (Object)"1");
        periodDimension.set("createtime", (Object)new Date());
        periodDimension.set("system", (Object)anaSystemId);
        periodDimension.set("isdefault", (Object)"1");
        periodDimension.set("dimensiontype", (Object)"1");
        String periodEntityFid = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"bd_period").toArray()).getString("id");
        periodDimension.set("dimensionsource", (Object)periodEntityFid);
        periodDimension.set("typefield", (Object)"periodtype");
        periodDimension.set("grouptype", (Object)"bd_period_type");
        periodDimension.set("systemsource", (Object)"0");
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bd_period_type", (QFilter[])new QFilter[0], (String)"id", (int)1);
        periodDimension.set("group_id", primaryKeys.stream().findFirst().orElseGet(() -> null));
        DynamicObjectCollection periodDimensionEntryEntity = periodDimension.getDynamicObjectCollection("dimensionentryentity");
        FAFEntityMetadata entityMetadata = new FAFEntityMetadata("bd_period");
        for (String defaultField : defaultFields) {
            DynamicObject dynamicObject = periodDimensionEntryEntity.addNew();
            FAFEntityMetadata.RefFieldProp refFieldProp = entityMetadata.getRefFieldProp(defaultField);
            if (refFieldProp == null) continue;
            dynamicObject.set("fieldname", (Object)refFieldProp.getDisplayName());
            dynamicObject.set("fieldnumber", (Object)refFieldProp.getName());
            dynamicObject.set("datatype", (Object)refFieldProp.getType());
        }
        return periodDimension;
    }

    private static DynamicObject createDimOfOrg(Long anaSystemId) {
        DynamicObject orgDimension = BusinessDataServiceHelper.newDynamicObject((String)"pa_dimension");
        orgDimension.set("number", (Object)"org");
        orgDimension.set("name", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"FAFAnasystemSettingHelper_9", (String)"macc-faf-common", (Object[])new Object[0]));
        orgDimension.set("status", (Object)"C");
        orgDimension.set("creator", (Object)RequestContext.get().getCurrUserId());
        orgDimension.set("enable", (Object)"1");
        orgDimension.set("createtime", (Object)new Date());
        orgDimension.set("system", (Object)anaSystemId);
        orgDimension.set("isdefault", (Object)"1");
        orgDimension.set("dimensiontype", (Object)"1");
        orgDimension.set("systemsource", (Object)"0");
        String orgEntityFid = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"bos_org").toArray()).getString("id");
        orgDimension.set("dimensionsource", (Object)orgEntityFid);
        DynamicObjectCollection dynamicObjectCollection = orgDimension.getDynamicObjectCollection("dimensionentryentity");
        FAFEntityMetadata entityMetadata = new FAFEntityMetadata("bos_org");
        for (String defaultField : defaultFields) {
            DynamicObject dynamicObject = dynamicObjectCollection.addNew();
            FAFEntityMetadata.RefFieldProp refFieldProp = entityMetadata.getRefFieldProp(defaultField);
            if (refFieldProp == null) continue;
            dynamicObject.set("fieldname", (Object)refFieldProp.getDisplayName());
            dynamicObject.set("fieldnumber", (Object)refFieldProp.getName());
            dynamicObject.set("datatype", (Object)refFieldProp.getType());
        }
        return orgDimension;
    }
}

