/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.util.AnalysisModelUtil;
import org.apache.commons.lang3.StringUtils;

public class FAFDataQueryHelper {
    public static QFilter getDimensionF7SelectQFilter(DynamicObject dimension) {
        QFilter f7SelectQFilter = null;
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(dimension.getString("dimensiontype"));
        switch (dimensionTypeEnum) {
            case DATABASE: {
                String typeField = dimension.getString("typefield");
                Object groupId = dimension.get("group_id");
                if (!StringUtils.isNotEmpty((CharSequence)typeField) || groupId == null) break;
                f7SelectQFilter = new QFilter(typeField, "=", groupId);
                break;
            }
            case ASSISTANTDATA: {
                DynamicObject assistantSource = dimension.getDynamicObject("assistantsource");
                if (assistantSource == null) break;
                f7SelectQFilter = new QFilter("group", "=", (Object)assistantSource.getLong("id"));
                break;
            }
        }
        return f7SelectQFilter;
    }

    public static Object[] getDetailIdsBySummaryId(Long summaryId, Long modelId) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber(anaModel.getString("tablenumber"));
        return QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("summaryid", "=", (Object)summaryId)}, null, (int)-1).toArray();
    }
}

