/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.model.impl.DataSourceConfigModel;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.ParamBuilder;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;

public class FAFDataSourceConfigHelper {
    public static String queryEntityById(Object id) {
        DynamicObject source = FAFDataSourceConfigHelper.loadData(id);
        return FAFDataSourceConfigHelper.queryEntity(source);
    }

    public static String queryEntity(DynamicObject dataSource) {
        DynamicObject entityObj = dataSource.getDynamicObject("entity_number");
        if (entityObj == null) {
            return null;
        }
        return String.valueOf(entityObj.getPkValue());
    }

    public static DynamicObject loadData(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_datasourceconfig"));
    }

    public static QFilter queryOneDataSourceFilterById(Long dataSourceId) {
        Map<Long, QFilter> filterMap = FAFDataSourceConfigHelper.queryDataSourceFiltersByIds(dataSourceId);
        return filterMap.values().stream().findFirst().orElse(null);
    }

    public static Map<Long, QFilter> queryDataSourceFiltersByIds(Object ... ids) {
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"pa_datasourceconfig");
        LinkedHashMap<Long, QFilter> qFilterMap = new LinkedHashMap<Long, QFilter>();
        for (Map.Entry objectDynamicObjectEntry : dynamicObjectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)objectDynamicObjectEntry.getValue();
            Long dataSourceId = dynamicObject.getLong("id");
            QFilter qFilter = FAFDataSourceConfigHelper.parseQFilter(dynamicObject);
            if (qFilter == null) continue;
            qFilterMap.put(dataSourceId, qFilter);
        }
        return qFilterMap;
    }

    public static QFilter parseQFilter(DynamicObject dy) {
        DynamicObject accountbookstype;
        String dsType;
        QFilter qFilter = null;
        DynamicObject entity = dy.getDynamicObject("entity_number");
        String filterJson = dy.getString("entityfilter_tag");
        if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            MainEntityType number = EntityMetadataCache.getDataEntityType((String)entity.getString("number"));
            FilterBuilder filterBuilder = new FilterBuilder(number, filterCondition);
            filterBuilder.buildFilter(false);
            qFilter = filterBuilder.getQFilter();
        }
        if (("1".equals(dsType = dy.getString("datasource_type")) || "2".equals(dsType) || "4".equals(dsType)) && (accountbookstype = dy.getDynamicObject("accountbookstype")) != null) {
            QFilter booktype = new QFilter("booktype", "=", accountbookstype.getPkValue());
            if (qFilter != null) {
                qFilter.and(booktype);
            } else {
                qFilter = booktype;
            }
        }
        return qFilter;
    }

    public static List<String> filterIsSystemDataSourceNameNumberListAmountPrimaryKeys(Object[] primaryKeyValues) {
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"pa_datasourceconfig");
        return dynamicObjectMap.values().stream().filter(dy -> dy.getBoolean("issystem")).map(dy -> String.format("%s(%s)", dy.getString("name"), dy.getString("number"))).collect(Collectors.toList());
    }

    public static DataSourceConfigModel getDataSource(Long datasourceId) {
        DataSourceConfigModel dataSourceConfigModel = new DataSourceConfigModel();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)datasourceId, (String)"pa_datasourceconfig");
        dataSourceConfigModel.loadFromDynamicObject(dynamicObject);
        return dataSourceConfigModel;
    }

    public static Map<String, Set<String>> getDatasourceFilters(Long datasourceId) {
        DataSourceConfigModel dataSource = FAFDataSourceConfigHelper.getDataSource(datasourceId);
        List<DataSourceConfigModel.FilterEntry> filterEntries = dataSource.getFilterEntries();
        Map<String, Set<String>> collect = filterEntries.stream().collect(Collectors.toMap(DataSourceConfigModel.FilterEntry::getDimNumber, DataSourceConfigModel.FilterEntry::getMemberNumbers));
        return collect;
    }

    public static Collection<OlapServerDimemsionMetaInfo> getDimensionFromId(Long datasourceId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)datasourceId, (String)"pa_datasourceconfig");
        String type = dynamicObject.getString("datasource_type");
        OlapFromServiceEnum anEnum = OlapFromServiceEnum.getEnum(type);
        if (anEnum == null) {
            return Collections.emptyList();
        }
        String paramsrcTag = dynamicObject.getString("paramsrc_tag");
        return FAFDataSourceConfigHelper.getDimensionFromParamSetting(anEnum, paramsrcTag);
    }

    public static Collection<OlapServerDimemsionMetaInfo> getDimensionFromParamSetting(OlapFromServiceEnum olapFromServiceEnum, String paramsrc) {
        OlapRequestParam param1 = ParamBuilder.getParam(olapFromServiceEnum, paramsrc);
        Map<String, OlapServerDimemsionMetaInfo> allDim = RequestFactoryBuilder.getAllDim(olapFromServiceEnum, param -> param1);
        return allDim.values();
    }

    public static ImportSystemSourceTypeEnum transformDataSourceEnumToImportSystemSourceEnum(DataSourceTypeEnum dataSourceTypeEnum) {
        switch (dataSourceTypeEnum) {
            case BCM: {
                return ImportSystemSourceTypeEnum.BCM;
            }
            case EPM: {
                return ImportSystemSourceTypeEnum.EPM;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b", (String)"FAFDataSourceConfigHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
    }
}

