/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.helper.EntityMetaHelper;

public class FAFDimensionHelper {
    public static DynamicObject loadDimension(Object dimensionId) {
        return BusinessDataServiceHelper.loadSingle((Object)dimensionId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_dimension"));
    }

    public static Optional<String> getTypeFieldBaseEntityId(DynamicObject dimension) {
        DynamicObject value = dimension.getDynamicObject("dimensionsource");
        String typefield = dimension.getString("typefield");
        if (value != null && typefield != null) {
            return EntityMetaHelper.getBaseEntityId((String)value.getPkValue(), typefield);
        }
        return Optional.empty();
    }

    public static DynamicObject loadGroupDynamicObject(DynamicObject dimension) {
        Object group_id = dimension.get("group_id");
        Optional<String> optional = FAFDimensionHelper.getTypeFieldBaseEntityId(dimension);
        if (optional.isPresent() && group_id != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)group_id, (String)optional.get());
        }
        return null;
    }

    public static QFilter getDimensionTypeQFilter(DynamicObject dimension) {
        String grouptype = dimension.getString("typefield");
        Object group_id = dimension.get("group_id");
        if (StringUtils.isNotEmpty((CharSequence)grouptype) && group_id != null) {
            return new QFilter(grouptype, "=", group_id);
        }
        return null;
    }

    public static DynamicObject[] loadDimension(Object[] dimensionIds) {
        Map dimensions = BusinessDataServiceHelper.loadFromCache((Object[])dimensionIds, (String)"pa_dimension");
        DynamicObject[] results = dimensions.values().toArray(new DynamicObject[dimensions.size()]);
        return results;
    }

    public static boolean isDefaultPresetDimension(Object dimensionId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_dimension", (String)"isdefault", (QFilter[])new QFilter("id", "=", dimensionId).toArray());
        if (dynamicObject == null) {
            return false;
        }
        return "true".equals(dynamicObject.getString("isdefault"));
    }

    public static DynamicObjectCollection queryDimensionByAnaSystem(Object ... anaSystemIds) {
        QFilter systemIdFilter = new QFilter("system", "in", (Object)anaSystemIds);
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.query((String)"pa_dimension", (String)"id,system", (QFilter[])new QFilter[]{systemIdFilter, isDefaultFilter}, null);
    }

    public static void deleteDimensionByAnaSystemIds(Object ... anaSystemIds) {
        DeleteServiceHelper.delete((String)"pa_dimension", (QFilter[])new QFilter("system", "in", (Object)anaSystemIds).toArray());
    }

    public static String getDimensionSource(DynamicObject dimension, DimensionTypeEnum dimensionTypeEnum) {
        String baseEntityId;
        switch (dimensionTypeEnum) {
            case DATABASE: {
                DynamicObject dimensionSource = dimension.getDynamicObject("dimensionsource");
                baseEntityId = dimensionSource.getString("number");
                break;
            }
            case ASSISTANTDATA: {
                baseEntityId = "bos_assistantdata_detail";
                break;
            }
            default: {
                baseEntityId = null;
            }
        }
        return baseEntityId;
    }

    public static Map<Object, DynamicObject> queryDimensionType(Object[] pks) {
        if (pks == null || pks.length <= 0) {
            return new HashMap<Object, DynamicObject>(1);
        }
        HashMap<Object, DynamicObject> data = new HashMap<Object, DynamicObject>(pks.length);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"pa_dimension", (String)"id,dimensionsource,group,typefield", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        for (DynamicObject object : cols) {
            data.put(object.get("id"), object);
        }
        return data;
    }

    public static Object[] queryDimensionValueByType(DynamicObject dimension) {
        Object[] temp = new Object[]{};
        if (dimension == null) {
            return temp;
        }
        ArrayList<Object> idList = new ArrayList<Object>(10);
        String entityNumber = dimension.getString("dimensionsource");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDimensionValueByType", (String)entityNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter(dimension.getString("typefield"), "=", dimension.get("group"))}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    idList.add(row.get("id"));
                }
            }
        }
        return idList.isEmpty() ? temp : idList.toArray(temp);
    }

    public static DynamicObjectCollection queryDimensionMappingByAnaSystem(Object anaSystemIds, ImportSystemSourceTypeEnum systemSourceEnum) {
        List dimensionIdsOfAnaSystem = QueryServiceHelper.queryPrimaryKeys((String)"pa_dimension", (QFilter[])new QFilter("system", "in", anaSystemIds).toArray(), null, (int)-1);
        return FAFDimensionHelper.queryDimensionMappingByDimensionIds(dimensionIdsOfAnaSystem, systemSourceEnum);
    }

    public static DynamicObjectCollection queryDimensionMappingByDimensionIds(List<Object> dimensionIds, ImportSystemSourceTypeEnum systemSourceEnum) {
        switch (systemSourceEnum) {
            case BCM: {
                return QueryServiceHelper.query((String)"faf_cmdimmapping", (String)"dimension,cmmodel immodel,cmdimension imdimension,cmdimnumber imdimnumber,cmdimname imdimname,membermodel", (QFilter[])new QFilter("dimension", "in", dimensionIds).toArray(), null);
            }
            case EPM: {
                return QueryServiceHelper.query((String)"faf_epmdimmapping", (String)"dimension,epmmodel immodel,epmdimension imdimension,epmdimnumber imdimnumber,epmdimname imdimname,membermodel", (QFilter[])new QFilter("dimension", "in", dimensionIds).toArray(), null);
            }
        }
        return null;
    }

    public static List<ValueMapItem> getValueMapItems(DynamicObject dimension) {
        DynamicObject dynObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)"pa_dimension");
        DynamicObjectCollection items = dynObject.getDynamicObjectCollection("entryentityenums");
        return items.stream().map(dyn -> new ValueMapItem(null, dyn.getString("value"), new LocaleString(dyn.getString("title")))).collect(Collectors.toList());
    }

    public static List<ComboItem> getComboItems(DynamicObject dimension) {
        DynamicObject dynObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)"pa_dimension");
        DynamicObjectCollection items = dynObject.getDynamicObjectCollection("entryentityenums");
        return items.stream().map(dyn -> new ComboItem(new LocaleString(dyn.getString("title")), dyn.getString("value"))).collect(Collectors.toList());
    }

    public static boolean dimensionAlreadyCreateModeling(Object pkValue) {
        List allRefs = BaseDataRefrenceHelper.getAllRefs((String)"pa_dimension", (Object)pkValue);
        for (BaseDataRefenceKey ref : allRefs) {
            String refEntityKey = ref.getRefEntityKey();
            if (!"pa_analysismodel".equals(refEntityKey)) continue;
            QFilter qFilter = new QFilter("dimension_entry.dimension_id", "=", pkValue);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pa_analysismodel", (String)"tablenumber", (QFilter[])qFilter.toArray());
            for (DynamicObject dyObject : query) {
                String tablenumber = dyObject.getString("tablenumber");
                if (!StringUtils.isNotEmpty((CharSequence)tablenumber)) continue;
                return true;
            }
        }
        return false;
    }

    public static DataType getDimensionAlgoDataType(DynamicObject dimension) {
        String dimensiontype = dimension.getString("dimensiontype");
        if (FAFDimensionTypeEnum.DATABASE.eqScene(dimensiontype)) {
            Object dimensionsource = dimension.getDynamicObject("dimensionsource").getPkValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)dimensionsource));
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (primaryKey instanceof VarcharProp) {
                return DataType.StringType;
            }
            return DataType.LongType;
        }
        if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene(dimensiontype)) {
            return DataType.LongType;
        }
        if (FAFDimensionTypeEnum.OTHER.eqScene(dimensiontype)) {
            return DataType.StringType;
        }
        if (FAFDimensionTypeEnum.DENUMS.eqScene(dimensiontype)) {
            return DataType.StringType;
        }
        if (FAFDimensionTypeEnum.DATE.eqScene(dimensiontype)) {
            return DataType.DateType;
        }
        return DataType.StringType;
    }

    public static DataType getEntityFieldDataType(String entityNumber, String refField) {
        IDataEntityProperty property = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields().get(refField);
        if (property instanceof BasedataProp) {
            MainEntityType propEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
            ISimpleProperty primaryKey = propEntityType.getPrimaryKey();
            if (primaryKey instanceof VarcharProp) {
                return DataType.StringType;
            }
            return DataType.LongType;
        }
        if (property instanceof DateTimeProp) {
            return DataType.DateType;
        }
        return DataType.StringType;
    }
}

