/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.dto.FAFMappingDimensionDTO;
import kd.macc.faf.dto.FAFMappingDimensionQResultDTO;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.RelationShipMappingDimensionEnum;
import kd.macc.faf.util.CRC32CodeUtils;

public class FAFMappingRelationShipDataHelper {
    private static final Log logger = LogFactory.getLog(FAFMappingRelationShipDataHelper.class);
    public static final String ASST_DATA_KEY = "bos_assistantdata_detail";

    public static List<FAFMappingDimensionDTO> getDimensionList(IDataModel model, RelationShipMappingDimensionEnum dimensionEnum) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)model.getDataEntityType().getProperty(dimensionEnum.getCode());
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObject entity = model.getDataEntity();
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)entity);
        return rows.stream().map(row -> FAFMappingRelationShipDataHelper.buildDimMappingDTO(dimensionEnum.getCode(), (DynamicObject)basedataProp.getValue(row))).collect(Collectors.toList());
    }

    public static DynamicObjectCollection queryMappingByAnaSystem(Object ... anaSystemIds) {
        return QueryServiceHelper.query((String)"pa_mappingrelationship", (String)"id,anasystem", (QFilter[])new QFilter("anasystem", "in", (Object)anaSystemIds).toArray(), null);
    }

    public static Map<Object, DynamicObject> loadMappingByAnaSystem(Long anaSystemId) {
        return BusinessDataServiceHelper.loadFromCache((String)"pa_mappingrelationship", (String)"id,number,sourcedim,targetdim", (QFilter[])new QFilter("anasystem", "=", (Object)anaSystemId).toArray());
    }

    private static FAFMappingDimensionDTO buildDimMappingDTO(String dimNumber, DynamicObject dimDynamicObject) {
        FAFMappingDimensionDTO dimensionDTO = new FAFMappingDimensionDTO();
        dimensionDTO.setPkId(dimDynamicObject.getLong("id"));
        dimensionDTO.setNumber(dimDynamicObject.getString("number"));
        dimensionDTO.setName(dimDynamicObject.getString("name"));
        dimensionDTO.setDimensionType(RelationShipMappingDimensionEnum.getEnumByCode(dimNumber));
        String dimensionType = dimDynamicObject.getString("dimensiontype");
        switch (DimensionTypeEnum.getEnum(dimensionType)) {
            case DATABASE: {
                dimensionDTO.setType(dimensionType);
                dimensionDTO.setBaseDataSourceNumber(dimDynamicObject.getDynamicObject("dimensionsource").getString("number"));
                dimensionDTO.setImportSystemSourceTypeEnum(ImportSystemSourceTypeEnum.getEnumByCode(dimDynamicObject.getString("systemsource")));
                break;
            }
            case ASSISTANTDATA: {
                dimensionDTO.setType(dimensionType);
                dimensionDTO.setBaseDataSourceNumber(ASST_DATA_KEY);
                dimensionDTO.setAssistantDataTypeId(dimDynamicObject.getDynamicObject("assistantsource").getLong("id"));
                break;
            }
            case OTHER: {
                dimensionDTO.setType(dimensionType);
                break;
            }
            case DENUMS: {
                Map<String, String> enumMap = dimDynamicObject.getDynamicObjectCollection("entryentityenums").stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title")));
                dimensionDTO.setType(dimensionType);
                dimensionDTO.setEnumMap(enumMap);
            }
        }
        return dimensionDTO;
    }

    public static FAFMappingDimensionQResultDTO queryOneDimMappingBySourceDims(Long mappingRelationshipId, Map<String, Object> sourceDimMappingMap) {
        HashMap<Long, Map<String, Object>> sourceDimMappingMapMap = new HashMap<Long, Map<String, Object>>();
        sourceDimMappingMapMap.put(0L, sourceDimMappingMap);
        return FAFMappingRelationShipDataHelper.queryDimMappingBySourceDims(mappingRelationshipId, sourceDimMappingMapMap).get(0);
    }

    public static List<FAFMappingDimensionQResultDTO> queryDimMappingBySourceDims(Long mappingRelationshipId, Map<Long, Map<String, Object>> sourceDimMappingMapMap) {
        DynamicObject dimMappingScheme = FAFMappingRelationShipDataHelper.validateMappingSchema(mappingRelationshipId, sourceDimMappingMapMap);
        List<FAFMappingDimensionDTO> sourceDimMappingDTOs = FAFMappingRelationShipDataHelper.getMappingDimensionDTOsBySchema(dimMappingScheme, RelationShipMappingDimensionEnum.SOURCE.getCode());
        List<FAFMappingDimensionDTO> targetDimMappingDTOs = FAFMappingRelationShipDataHelper.getMappingDimensionDTOsBySchema(dimMappingScheme, RelationShipMappingDimensionEnum.TARGET.getCode());
        Map<Long, String> sourceDimJsonMap = FAFMappingRelationShipDataHelper.transferSourceDimToJsonMap(sourceDimMappingMapMap, sourceDimMappingDTOs);
        List sourceDimJsonCrc32List = sourceDimJsonMap.values().stream().map(sourceDimJson -> CRC32CodeUtils.encode(sourceDimJson.getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
        QFilter schemaIdFilter = new QFilter("id", "=", (Object)mappingRelationshipId);
        QFilter CRC32Filter = new QFilter("entryentity.sourcedimcrc", "in", sourceDimJsonCrc32List);
        QFilter sourceDimFilter = new QFilter("entryentity.sourcedimtext", "in", sourceDimJsonMap.values());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pa_mappingrelationship", (String)"entryentity.sourcedimtext,entryentity.targetdimtext", (QFilter[])new QFilter[]{schemaIdFilter, CRC32Filter, sourceDimFilter});
        return FAFMappingRelationShipDataHelper.buildMappingDimensionQResultDTOs(dynamicObjects, sourceDimJsonMap, sourceDimMappingDTOs, targetDimMappingDTOs, dimMappingScheme.getString("number"));
    }

    private static DynamicObject validateMappingSchema(Long mappingRelationshipId, Map<Long, Map<String, Object>> sourceDimMappingMapList) {
        if (mappingRelationshipId == null || mappingRelationshipId <= 0L) {
            logger.error("\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e3b\u952eid\u4e0d\u5408\u6cd5,mappingRelationshipId : " + mappingRelationshipId);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e3b\u952eid\u4e0d\u5408\u6cd5.", (String)"FAFMappingRelationShipDataHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(sourceDimMappingMapList)) {
            logger.error("\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u6e90\u7ef4\u5ea6\u53c2\u6570\u4e0d\u5408\u6cd5,sourceDimMappingMap : " + sourceDimMappingMapList);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u6e90\u7ef4\u5ea6\u53c2\u6570\u4e0d\u5408\u6cd5.", (String)"FAFMappingRelationShipDataHelper_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        DynamicObject dimMappingScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_mappingrelationship", (String)"id,number,sourcedim,targetdim", (QFilter[])new QFilter("id", "=", (Object)mappingRelationshipId).toArray());
        if (dimMappingScheme == null) {
            logger.error("\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u65b9\u6848\u4e0d\u5b58\u5728,mappingRelationshipId : " + mappingRelationshipId);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u65b9\u6848\u4e0d\u5b58\u5728.", (String)"FAFMappingRelationShipDataHelper_2", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        return dimMappingScheme;
    }

    public static List<FAFMappingDimensionDTO> getMappingDimensionDTOsBySchema(DynamicObject dimMappingScheme, String dimensionCode) {
        return dimMappingScheme.getDynamicObjectCollection(dimensionCode).stream().sorted(Comparator.comparing(dy -> dy.getLong("pkid"))).map(sourceDim -> FAFMappingRelationShipDataHelper.buildDimMappingDTO(dimensionCode, sourceDim.getDynamicObject("fbasedataid"))).collect(Collectors.toList());
    }

    private static Map<Long, String> transferSourceDimToJsonMap(Map<Long, Map<String, Object>> sourceDimMappingMapMap, List<FAFMappingDimensionDTO> sourceDimMappingDTOs) {
        LinkedHashMap<Long, String> sourceDimJsonToModelIdMap = new LinkedHashMap<Long, String>(sourceDimMappingMapMap.size());
        for (Map.Entry<Long, Map<String, Object>> longMapEntry : sourceDimMappingMapMap.entrySet()) {
            Long modelId = longMapEntry.getKey();
            Map<String, Object> sourceDimMappingMap = longMapEntry.getValue();
            LinkedHashMap<String, Object> sourceDimJsonMapWithDefaultValue = new LinkedHashMap<String, Object>(sourceDimMappingDTOs.size());
            block5: for (FAFMappingDimensionDTO sourceDimMappingDTO : sourceDimMappingDTOs) {
                String number = sourceDimMappingDTO.getNumber();
                String type = sourceDimMappingDTO.getType();
                DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum(type);
                Object value = sourceDimMappingMap.get(number);
                switch (dimensionTypeEnum) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        sourceDimJsonMapWithDefaultValue.put(number, value == null ? Long.valueOf(0L) : value);
                        continue block5;
                    }
                    case OTHER: 
                    case DENUMS: {
                        sourceDimJsonMapWithDefaultValue.put(number, value == null ? "" : value);
                        continue block5;
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"FAFMappingRelationShipDataHelper_3", (String)"macc-faf-common", (Object[])new Object[0]));
            }
            sourceDimJsonToModelIdMap.put(modelId, JSON.toJSONString(sourceDimJsonMapWithDefaultValue));
        }
        return sourceDimJsonToModelIdMap;
    }

    private static List<FAFMappingDimensionQResultDTO> buildMappingDimensionQResultDTOs(DynamicObjectCollection dynamicObjects, Map<Long, String> sourceDimJsonMap, List<FAFMappingDimensionDTO> sourceDimMappingDTOs, List<FAFMappingDimensionDTO> targetDimMappingDTOs, String schemaNumber) {
        ArrayList<FAFMappingDimensionQResultDTO> paMappingDimensionQResultDTOS = new ArrayList<FAFMappingDimensionQResultDTO>(sourceDimJsonMap.size());
        Map<String, String> sourceToTargetJsonMap = dynamicObjects.stream().collect(Collectors.toMap(entry -> entry.getString("entryentity.sourcedimtext"), entry -> entry.getString("entryentity.targetdimtext")));
        LinkedHashSet<Long> existMappingModelIds = new LinkedHashSet<Long>(sourceDimJsonMap.size());
        LinkedHashSet<Long> notExistMappingModelIds = new LinkedHashSet<Long>(sourceDimJsonMap.size());
        for (Map.Entry<Long, String> longStringEntry : sourceDimJsonMap.entrySet()) {
            FAFMappingDimensionQResultDTO dimensionQResultDTO;
            Long modelId = longStringEntry.getKey();
            String sourceDimJson = longStringEntry.getValue();
            String targetDimJson = sourceToTargetJsonMap.get(sourceDimJson);
            if (StringUtils.isNotBlank((CharSequence)targetDimJson)) {
                existMappingModelIds.add(modelId);
                dimensionQResultDTO = new FAFMappingDimensionQResultDTO(modelId, true, ResManager.loadKDString((String)"\u6210\u529f", (String)"FAFMappingRelationShipDataHelper_4", (String)"macc-faf-common", (Object[])new Object[0]));
                dimensionQResultDTO.setTargetDimensionDataMap((Map)JSON.parseObject((String)targetDimJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]));
            } else {
                notExistMappingModelIds.add(modelId);
                dimensionQResultDTO = new FAFMappingDimensionQResultDTO(modelId, false, ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728", (String)"FAFMappingRelationShipDataHelper_5", (String)"macc-faf-common", (Object[])new Object[0]));
            }
            dimensionQResultDTO.setSourceDimensionDTOs(sourceDimMappingDTOs);
            dimensionQResultDTO.setTargetDimensionDTOs(targetDimMappingDTOs);
            dimensionQResultDTO.setSourceDimensionDataMap((Map)JSON.parseObject((String)sourceDimJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]));
            paMappingDimensionQResultDTOS.add(dimensionQResultDTO);
        }
        logger.error(String.format("\u6620\u5c04\u65b9\u6848\u6807\u8bc6\u4e3a : %s\u4e2d\u76ee\u6807\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u5b58\u5728\u5bf9\u5e94\u7684\u6a21\u578bId\u4e3a: %s", schemaNumber, existMappingModelIds));
        logger.error(String.format("\u6620\u5c04\u65b9\u6848\u6807\u8bc6\u4e3a : %s\u4e2d\u76ee\u6807\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6a21\u578bId\u4e3a: %s", schemaNumber, notExistMappingModelIds));
        return paMappingDimensionQResultDTOS;
    }
}

