/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.helper.FAFDataSourceConfigHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.rdb.RdbSQLInfo;
import kd.macc.faf.rdb.RdbSQLSplitTaskIterator;
import kd.macc.faf.util.AnalysisModelUtil;
import org.apache.commons.lang3.StringUtils;

public class FAFRdbSqlIteratorHelper {
    private static final Log logger = LogFactory.getLog(FAFRdbSqlIteratorHelper.class);

    public static RdbSQLInfo getRdbSqlInfoByMeta(FAFWorkTaskMeta meta) {
        DataExtractingDTO dataExtractingDTO = meta.getDataExtractingDTO();
        Long dataSchemeId = meta.getDataSchemeId();
        DynamicObject schemeObj = BusinessDataReader.loadSingle((Object)dataSchemeId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_syncdataschema"));
        Object tableNumber = schemeObj.getDynamicObject("analysismodel").get("tablenumber");
        if (tableNumber == null || StringUtils.isEmpty((CharSequence)tableNumber.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u524d\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868\u3002", (String)"FAFRdbSqlIteratorHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        DynamicObjectCollection dimEntry = (DynamicObjectCollection)schemeObj.getDynamicObject("analysismodel").get("dimension_entry");
        for (DynamicObject dim : dimEntry) {
            if (DimensionNecessityEnum.ORG.getCode().equals(dim.get("necessity_dim"))) {
                qFilters.add(dataExtractingDTO.getOrgQFilter(dim.getDynamicObject("dimension").getString("number")));
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim"))) continue;
            qFilters.add(dataExtractingDTO.getPeriodQFilter(dim.getDynamicObject("dimension").getString("number")));
        }
        qFilters.add(new QFilter("del", "=", (Object)0L));
        return new RdbSQLInfo(null, AnalysisModelUtil.buildEntityNumber(tableNumber.toString()), null, qFilters.toArray(new QFilter[0]));
    }

    public static RdbSQLSplitTaskIterator getRdbSqlIteratorByMeta(FAFWorkTaskMeta meta) {
        DataExtractingDTO dataExtractingDTO = meta.getDataExtractingDTO();
        Long dataSchemeId = meta.getDataSchemeId();
        DynamicObject schemeObj = BusinessDataReader.loadSingle((Object)dataSchemeId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_syncdataschema"));
        String tableNumber = (String)schemeObj.getDynamicObject("analysismodel").get("tablenumber");
        if (tableNumber == null || StringUtils.isEmpty((CharSequence)tableNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u524d\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868\u3002", (String)"FAFRdbSqlIteratorHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        meta.setTableNumber(tableNumber);
        DynamicObjectCollection dimEntry = (DynamicObjectCollection)schemeObj.getDynamicObject("analysismodel").get("dimension_entry");
        HashMap<String, String> dimensionMap = new HashMap<String, String>(2);
        for (DynamicObject dim : dimEntry) {
            if (DimensionNecessityEnum.ORG.getCode().equals(dim.get("necessity_dim"))) {
                dimensionMap.put(dim.getDynamicObject("dimension").getString("number"), "org");
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim"))) continue;
            dimensionMap.put(dim.getDynamicObject("dimension").getString("number"), "period");
        }
        DynamicObjectCollection dimMap = schemeObj.getDynamicObjectCollection("dimensionmapentry");
        Object[] dimensionPks = new Object[dimMap.size()];
        String[] orgAndPeriodTargetNumber = new String[2];
        String[] orgAndPeriodField = new String[2];
        for (int i = 0; i < dimensionPks.length; ++i) {
            DynamicObject dim = (DynamicObject)dimMap.get(i);
            DynamicObject dimension = (DynamicObject)dim.get("dimension");
            String fieldNumber = dimension.getString("number");
            String fieldMark = (String)dimensionMap.get(fieldNumber);
            if (StringUtils.isNotEmpty((CharSequence)fieldMark)) {
                String dimField = dim.getString("dimensionfield");
                if (fieldMark.equals("org")) {
                    orgAndPeriodField[0] = dimField;
                    orgAndPeriodTargetNumber[0] = fieldNumber;
                } else if (fieldMark.equals("period")) {
                    orgAndPeriodField[1] = dimField;
                    orgAndPeriodTargetNumber[1] = fieldNumber;
                }
            }
            dimensionPks[i] = dimension.getPkValue();
        }
        if (orgAndPeriodField[0] == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7ec4\u7ec7\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"FAFRdbSqlIteratorHelper_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (orgAndPeriodField[1] == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u671f\u95f4\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"FAFRdbSqlIteratorHelper_2", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        long dataSourceId = schemeObj.getDynamicObject("datasource").getLong("id");
        DynamicObject dataSource = BusinessDataReader.loadSingle((Object)dataSourceId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_datasourceconfig"));
        QFilter dataSourceQFilter = FAFDataSourceConfigHelper.queryOneDataSourceFilterById(dataSourceId);
        String dataSourceEntityNumber = dataSource.getDynamicObject("entity_number").getString("number");
        Map<Object, DynamicObject> dimTypeMap = FAFDimensionHelper.queryDimensionType(dimensionPks);
        for (DynamicObject dim : dimMap) {
            DynamicObject dimen;
            String typeField;
            DynamicObject dimension = (DynamicObject)dim.get("dimension");
            String dimField = dim.getString("dimensionfield");
            if (!StringUtils.isNotEmpty((CharSequence)dimField) || orgAndPeriodField[0].equals(dimField) || orgAndPeriodField[1].equals(dimField) || dimField.startsWith("dim_") || !StringUtils.isNotEmpty((CharSequence)(typeField = (dimen = dimTypeMap.get(dimension.getPkValue())).getString("typefield")))) continue;
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)dimen.getString("dimensionsource"), (QFilter[])new QFilter[]{new QFilter(typeField, "=", dimen.get("group"))}, null, (int)-1);
            if (dataSourceQFilter == null) {
                dataSourceQFilter = new QFilter(dimField, "in", (Object)primaryKeys);
                continue;
            }
            dataSourceQFilter.and(new QFilter(dimField, "in", (Object)primaryKeys));
        }
        if (dataSourceQFilter == null) {
            dataSourceQFilter = dataExtractingDTO.getPeriodQFilter(orgAndPeriodField[1]);
        } else {
            dataSourceQFilter.and(dataExtractingDTO.getPeriodQFilter(orgAndPeriodField[1]));
        }
        Integer totalCount = 0;
        int groupSize = dataExtractingDTO.getOrgIds().length;
        String groupField = orgAndPeriodField[0];
        QFilter qFilter = dataSourceQFilter.copy().and(dataExtractingDTO.getOrgQFilter(orgAndPeriodField[0]));
        List<ThreeValueTuple<QFilter[], Integer, Integer>> splitQFilters = FAFRdbSqlIteratorHelper.statisticsGroupCount(dataSourceEntityNumber, qFilter, groupSize, groupField, dataExtractingDTO, meta);
        for (ThreeValueTuple<QFilter[], Integer, Integer> tuple : splitQFilters) {
            totalCount = totalCount + tuple.getValue();
        }
        return new RdbSQLSplitTaskIterator(null, dataSourceEntityNumber, null, dataSourceQFilter.toArray(), splitQFilters, orgAndPeriodTargetNumber, 100000, totalCount);
    }

    public static List<ThreeValueTuple<QFilter[], Integer, Integer>> statisticsGroupCount(String entityNumber, QFilter qFilters, Integer groupSize, String groupField, DataExtractingDTO dataExtractingDTO, FAFWorkTaskMeta meta) {
        StringBuilder selectFields = new StringBuilder();
        if ("ai_bizvoucher".equals(entityNumber)) {
            selectFields.append("entryentity.id,");
        } else if ("gl_voucher".equals(entityNumber)) {
            selectFields.append("entries.id,");
        } else {
            selectFields.append("id,");
        }
        selectFields.append(groupField);
        HashMap<Object, Integer> groupMap = new HashMap<Object, Integer>(groupSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PARdbSqlIteratorHelper.statistics", (String)entityNumber, (String)selectFields.toString(), (QFilter[])new QFilter[]{qFilters}, null);){
            for (Row next : ds) {
                Object key = next.get(groupField);
                if (groupMap.containsKey(key)) {
                    groupMap.put(key, (Integer)groupMap.get(key) + 1);
                    continue;
                }
                groupMap.put(key, 1);
            }
        }
        HashSet<Object> orgIds = new HashSet<Object>(dataExtractingDTO.getOrgIdSet());
        orgIds.removeAll(groupMap.keySet());
        ArrayList<ThreeValueTuple<QFilter[], Integer, Integer>> splitQFilters = new ArrayList<ThreeValueTuple<QFilter[], Integer, Integer>>(groupMap.size());
        for (Map.Entry entry : groupMap.entrySet()) {
            QFilter[] qFilterArray = new QFilter[1];
            Object key = entry.getKey();
            qFilterArray[0] = new QFilter(groupField, "=", key);
            ThreeValueTuple tuple = new ThreeValueTuple(qFilterArray, 0, entry.getValue());
            splitQFilters.add(tuple);
        }
        if (!orgIds.isEmpty()) {
            FAFRdbSqlIteratorHelper.deleteNotDataSourceData(dataExtractingDTO, orgIds, meta);
        }
        return splitQFilters;
    }

    private static void deleteNotDataSourceData(DataExtractingDTO dataExtractingDTO, Set<Object> orgSet, FAFWorkTaskMeta meta) {
        QFilter deleteFilter = new QFilter(dataExtractingDTO.getOrgDimNumber(), "in", orgSet);
        deleteFilter.and(dataExtractingDTO.getPeriodQFilter(dataExtractingDTO.getPeriodDimNumber()));
        MainEntityType outputDynEntity = EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildEntityNumber(meta.getTableNumber()));
        MainEntityType detailEntity = EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildDetailEntityNumber(meta.getTableNumber()));
        if (outputDynEntity.getProperty("importbatch") != null) {
            logger.info("have importbatch field, add filter which importbatch is empty");
            deleteFilter.and(new QFilter("importbatch", "=", (Object)" "));
        } else {
            logger.info(String.format("%s does not have importbatch field", outputDynEntity.getName()));
        }
        DeleteServiceHelper.delete((String)detailEntity.getName(), (QFilter[])new QFilter[]{deleteFilter});
        DeleteServiceHelper.delete((String)outputDynEntity.getName(), (QFilter[])new QFilter[]{deleteFilter});
    }
}

