/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.template.FAFDynamicObjectTemplate;
import kd.macc.faf.template.FAFFrameworkTemplate;

public class FAFSaveServiceHelper {
    private static final Log logger = LogFactory.getLog(FAFSaveServiceHelper.class);

    public static Map<String, Object> newFrameworkByTemplate(DynamicObject dataEntity, String frameworkTemplate) {
        Object systemPkvalue = dataEntity.getPkValue();
        if (systemPkvalue == null) {
            throw new KDBizException("pkvalue is null.");
        }
        long modelId = DB.genGlobalLongId();
        String modelName = FAFFrameworkTemplate.getModelName();
        String name = FAFFrameworkTemplate.getName();
        String tablenumber = "dyn" + dataEntity.getString("number");
        DynamicObject bizAppId = (DynamicObject)dataEntity.get("modulerange");
        String[] strings = FAFFrameworkTemplate.newFrameworkByTemplateLocaleString();
        try (TXHandle tx = TX.required((String)("system_" + dataEntity.getPkValue()));){
            try {
                FAFSaveServiceHelper.validNumberAndName(dataEntity);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                DynamicObject[] dimensions = FAFDynamicObjectTemplate.create("pa_dimension").propsCommon().put("system", systemPkvalue).put("systemsource", "0").template().setFields(FAFFrameworkTemplate.getDimensionFields()).addValuesList(FAFFrameworkTemplate.getDimensionValuesList()).finish().getDynamicObjects();
                SaveServiceHelper.save((DynamicObject[])dimensions);
                Map<Object, Object> dimensionPkMap = Arrays.stream(dimensions).collect(Collectors.toMap(dynamicObject -> dynamicObject.get("number"), DataEntityBase::getPkValue));
                Object pkValue = dimensionPkMap.get("period");
                long[] measureIds = DB.genGlobalLongIds((int)5);
                DynamicObject[] measures = FAFDynamicObjectTemplate.create("pa_measure").propsCommon().put("system", systemPkvalue).put("systemsource", "0").put("precision", 2).template().setFields(FAFFrameworkTemplate.getMeasureFields()).addValues(new Object[]{measureIds[0], "current_period", strings[0], Character.valueOf('1'), Character.valueOf(' '), 0, 0, Character.valueOf(' '), Character.valueOf(' '), Character.valueOf('0'), Character.valueOf('1')}).addValues(new Object[]{measureIds[1], "beginning_balance", strings[1], Character.valueOf('1'), Character.valueOf(' '), 0, 0, Character.valueOf(' '), Character.valueOf(' '), Character.valueOf('0'), Character.valueOf('1')}).addValues(new Object[]{measureIds[2], "ending_balance", strings[2], Character.valueOf('1'), Character.valueOf(' '), 0, 0, Character.valueOf(' '), Character.valueOf(' '), Character.valueOf('0'), Character.valueOf('1')}).addValues(new Object[]{measureIds[3], "quarter_to_date", strings[3], Character.valueOf('2'), Character.valueOf('1'), measureIds[0], pkValue, ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6,\u4f1a\u8ba1\u5b63\u5ea6", (String)"FAFSaveServiceHelper_0", (String)"macc-faf-common", (Object[])new Object[0]), "periodyear,periodquarter", Character.valueOf('0'), Character.valueOf('1')}).addValues(new Object[]{measureIds[4], "year_to_date", strings[4], Character.valueOf('2'), Character.valueOf('1'), measureIds[0], pkValue, ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6", (String)"FAFSaveServiceHelper_1", (String)"macc-faf-common", (Object[])new Object[0]), "periodyear", Character.valueOf('0'), Character.valueOf('1')}).finish().getDynamicObjects();
                SaveServiceHelper.save((DynamicObject[])measures);
                DynamicObject[] model = FAFDynamicObjectTemplate.create("pa_analysismodel").propsCommon().put("analysis_system", systemPkvalue).template().setFields(new Object[]{"id", "number", "name", "description", "tablenumber", "tablename", "periodtype", new Object[]{"dimension", "field_name", "field_number_tag", "necessity_dim", "dimension_entry"}, new Object[]{"measure", "measure_fieldname", "measure_fieldnumber", "measure_entry"}}).addValues(new Object[]{modelId, "analysis_model", modelName, "", tablenumber.toLowerCase(), modelName, FAFFrameworkTemplate.getFirstEntityPkId("bd_period_type"), new Object[]{new Object[]{dimensionPkMap.get("org"), name, "name", Character.valueOf('0')}, new Object[]{dimensionPkMap.get("period"), name, "name", Character.valueOf('1')}, new Object[]{dimensionPkMap.get("account"), name, "name", Character.valueOf('2')}, new Object[]{dimensionPkMap.get("report_item"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("department"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("cost_center"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("product"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("region"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("channel"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("project"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("customer"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("supplier"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("contract"), name, "name", Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("person"), name, "name", Character.valueOf(' ')}}, new Object[]{new Object[]{measureIds[0], name, "name"}, new Object[]{measureIds[4], name, "name"}}}).finish().getDynamicObjects();
                SaveServiceHelper.save((DynamicObject[])model);
                DynamicObject[] syncdata = FAFDynamicObjectTemplate.create("pa_syncdataschema").propsCommon().put("model", systemPkvalue).template().setFields(new Object[]{"number", "name", "analysismodel", "bizapp", "datasource", "description", new Object[]{"dimension", "dimensionfield", "dimensionmapentry"}, new Object[]{"measure", "selecttype", "conditiondesc", "condition_tag", "measuremapentry"}}).addValues(new Object[]{"data_acquisition_voucher", strings[5], modelId, bizAppId != null ? bizAppId.getString("id") : null, 1423052060147907584L, " ", new Object[]{new Object[]{dimensionPkMap.get("org"), "org"}, new Object[]{dimensionPkMap.get("period"), "period"}, new Object[]{dimensionPkMap.get("account"), "entries.account"}, new Object[]{dimensionPkMap.get("report_item"), Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("department"), Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("cost_center"), Character.valueOf(' ')}, new Object[]{dimensionPkMap.get("product"), Character.valueOf(' ')}}, new Object[]{new Object[]{measureIds[0], Character.valueOf('1'), strings[6], strings[7]}, new Object[]{measureIds[4], Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(' ')}}}).addValues(new Object[]{"data_acquisition_bizvoucher", strings[8], modelId, bizAppId != null ? bizAppId.getString("id") : null, 1423050123931351040L, " ", new Object[]{new Object[]{dimensionPkMap.get("org"), "org"}, new Object[]{dimensionPkMap.get("period"), "period"}, new Object[]{dimensionPkMap.get("account"), "entryentity.account"}, new Object[]{dimensionPkMap.get("report_item"), " "}, new Object[]{dimensionPkMap.get("department"), " "}, new Object[]{dimensionPkMap.get("cost_center"), "dim_b000025"}, new Object[]{dimensionPkMap.get("product"), " "}, new Object[]{dimensionPkMap.get("region"), " "}, new Object[]{dimensionPkMap.get("channel"), " "}, new Object[]{dimensionPkMap.get("project"), "dim_b000008"}, new Object[]{dimensionPkMap.get("customer"), "dim_b000013"}, new Object[]{dimensionPkMap.get("supplier"), "dim_b000012"}, new Object[]{dimensionPkMap.get("contract"), " "}, new Object[]{dimensionPkMap.get("person"), "entryentity.assgrp_f000010"}}, new Object[]{new Object[]{measureIds[0], Character.valueOf('1'), strings[6], strings[9]}, new Object[]{measureIds[4], Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(' ')}}}).finish().getDynamicObjects();
                SaveServiceHelper.save((DynamicObject[])syncdata);
                tx.commit();
            }
            catch (KDBizException e) {
                tx.markRollback();
                throw new KDBizException(new ErrorCode("newFrameworkByTemplate_02", e.getMessage()), new Object[0]);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(new ErrorCode("newFrameworkByTemplate_03", String.format(ResManager.loadKDString((String)"\u6309\u6a21\u677f\u521b\u5efa\u5206\u6790\u4f53\u7cfb\u5931\u8d25:%s", (String)"FAFSaveServiceHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
        return null;
    }

    public static void validNumberAndName(DynamicObject dataEntity) {
        String number = dataEntity.getString("number");
        boolean existsNumber = QueryServiceHelper.exists((String)dataEntity.getDataEntityType().getName(), (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (existsNumber) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u53f7\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"FAFSaveServiceHelper_3", (String)"macc-faf-common", (Object[])new Object[0]), number));
        }
        String name = dataEntity.getString("name");
        boolean existsName = QueryServiceHelper.exists((String)dataEntity.getDataEntityType().getName(), (QFilter[])new QFilter("name", "=", (Object)name).toArray());
        if (existsName) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"FAFSaveServiceHelper_4", (String)"macc-faf-common", (Object[])new Object[0]), name));
        }
    }
}

