/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.dto.FAFMappingDimensionDTO;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.FAFOlapSelectTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.enums.RelationShipMappingDimensionEnum;
import kd.macc.faf.helper.FAFDataSourceConfigHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMappingRelationShipDataHelper;
import kd.macc.faf.helper.FAFMeasureHelper;
import kd.macc.faf.model.impl.DataSourceConfigModel;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;
import kd.macc.faf.olap.driver.bcm.BcmOlapRequestParam;
import kd.macc.faf.olap.driver.epm.EpmOlapRequestParam;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.M;

public class FAFSyncDataSchemeHelper {
    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_syncdataschema");
    }

    public static Map<String, LinkedHashSet<String>> queryCommonFilter(QFilter[] filters) {
        String[] propertyFields = new String[]{"id", "name"};
        String[] fields = new String[]{"model", "analysismodel"};
        StringBuilder selectField = new StringBuilder();
        HashMap<String, LinkedHashSet<String>> resultMap = new HashMap<String, LinkedHashSet<String>>(fields.length);
        for (String field : fields) {
            for (String property : propertyFields) {
                selectField.append(field).append(".").append(property).append(",");
            }
            resultMap.put(field, new LinkedHashSet());
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCommonFilter", (String)"pa_syncdataschema", (String)selectField.substring(0, selectField.length() - 1), (QFilter[])filters, null);){
            for (Row row : dataSet) {
                for (String field : fields) {
                    LinkedHashSet dataList = (LinkedHashSet)resultMap.get(field);
                    StringBuilder valueBuilder = new StringBuilder();
                    for (String property : propertyFields) {
                        String dataField = field + "." + property;
                        valueBuilder.append(row.get(dataField)).append(",");
                    }
                    dataList.add(valueBuilder.substring(0, valueBuilder.length() - 1));
                }
            }
        }
        return resultMap;
    }

    public static OlapDataExtractingDTO buildOlapDataExtractingDTO(Long syncDataSchemaId, Set<Long> orgIds, Set<Long> analysisPeriods) {
        DynamicObject schema = BusinessDataServiceHelper.loadSingleFromCache((Object)syncDataSchemaId, (String)"pa_syncdataschema");
        DynamicObject datasource = schema.getDynamicObject("datasource");
        DataSourceConfigModel dataSourceConfigModel = FAFDataSourceConfigHelper.getDataSource(datasource.getLong("id"));
        ImportSystemSourceTypeEnum importSystemSourceTypeEnum = DataSourceTypeEnum.transDataSourceEnumToImportEnum(dataSourceConfigModel.getDataSourceTypeEnum());
        if (importSystemSourceTypeEnum == null) {
            return null;
        }
        DynamicObjectCollection measureEntry = schema.getDynamicObjectCollection("measuremapentry");
        List<Object> measureIds = measureEntry.stream().map(entry -> entry.getDynamicObject("measure").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection measureMappings = FAFMeasureHelper.queryMeasureMappingByMeasureIds(measureIds, importSystemSourceTypeEnum);
        List dimensionNumberList = null;
        if (!CollectionUtils.isEmpty((Collection)measureMappings)) {
            dimensionNumberList = measureMappings.stream().map(mapping -> mapping.getString("entryimdimnumber")).distinct().collect(Collectors.toList());
        }
        DynamicObjectCollection dimensionEntry = schema.getDynamicObjectCollection("dimensionmapentry");
        List<Object> dimensionIds = dimensionEntry.stream().map(entry -> entry.getDynamicObject("dimension").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection dimensionMappings = FAFDimensionHelper.queryDimensionMappingByDimensionIds(dimensionIds, importSystemSourceTypeEnum);
        Map mappingRelationShipOfCurrentAnaSystem = BusinessDataServiceHelper.loadFromCache((String)"pa_mappingrelationship", (String)"id,number,sourcedim,targetdim,entryentity,entryentity.sourcedimtext,entryentity.targetdimtext", (QFilter[])new QFilter("anasystem", "=", (Object)schema.getLong("model_id")).toArray());
        List<DataSourceConfigModel.FilterEntry> filterEntries = FAFSyncDataSchemeHelper.getDimensionFilterEntry(dataSourceConfigModel, schema, dimensionMappings, mappingRelationShipOfCurrentAnaSystem, orgIds, analysisPeriods);
        HashMap<Integer, List<String>> selectDimensionMap = new HashMap<Integer, List<String>>(16);
        Map<String, Integer> filterEntryCountMap = filterEntries.stream().collect(Collectors.toMap(DataSourceConfigModel.FilterEntry::getDimNumber, filterEntry -> filterEntry.getMemberNumbers().size()));
        selectDimensionMap.put(FAFOlapSelectTypeEnum.MEASURE_TYPE.getIntCode(), M.strArraylist("FMONEY"));
        selectDimensionMap.put(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode(), dimensionNumberList);
        selectDimensionMap.put(FAFOlapSelectTypeEnum.FIX_ROWKEY_TYPE.getIntCode(), dimensionEntry.stream().filter(entry -> importSystemSourceTypeEnum == ImportSystemSourceTypeEnum.getEnumByCode(entry.getDynamicObject("dimension").getString("systemsource"))).map(entry -> entry.getString("dimensionfield")).filter(StringUtils::isNotBlank).filter(importDimensionNumber -> filterEntryCountMap.getOrDefault(importDimensionNumber, 0) == 1).collect(Collectors.toList()));
        selectDimensionMap.put(FAFOlapSelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode(), dimensionEntry.stream().filter(entry -> importSystemSourceTypeEnum == ImportSystemSourceTypeEnum.getEnumByCode(entry.getDynamicObject("dimension").getString("systemsource"))).map(entry -> entry.getString("dimensionfield")).filter(StringUtils::isNotBlank).filter(importDimensionNumber -> filterEntryCountMap.getOrDefault(importDimensionNumber, 0) != 1).collect(Collectors.toList()));
        HashMap<List<String>, String> transformFieldIndexMap = new HashMap<List<String>, String>(16);
        for (Object entry2 : measureEntry) {
            String measureField;
            DynamicObject measure = entry2.getDynamicObject("measure");
            if (importSystemSourceTypeEnum != ImportSystemSourceTypeEnum.getEnumByCode(measure.getString("systemsource")) || !StringUtils.isNotBlank((CharSequence)(measureField = entry2.getString("measurefield")))) continue;
            transformFieldIndexMap.put(Arrays.stream(measureField.split(",")).collect(Collectors.toList()), measure.getString("number"));
        }
        HashMap<String, OlapDataExtractingDTO.SyncDataSchemaDimensionDTO> dimEntityMappingMap = new HashMap<String, OlapDataExtractingDTO.SyncDataSchemaDimensionDTO>(16);
        for (DynamicObject entry3 : dimensionEntry) {
            DynamicObject dimension = entry3.getDynamicObject("dimension");
            String dimensionNumber = dimension.getString("number");
            String dimensionSelectType = entry3.getString("dimensionselecttype");
            String dimensionField = entry3.getString("dimensionfield");
            DynamicObject mappingRelationShipSchema = (DynamicObject)mappingRelationShipOfCurrentAnaSystem.get(entry3.getLong("mappingrelationship_id"));
            String dimensionDefaultValue = entry3.getString("dimdefaultvalue");
            OlapDataExtractingDTO.SyncDataSchemaDimensionDTO syncDataSchemaDimensionDTO = new OlapDataExtractingDTO.SyncDataSchemaDimensionDTO();
            syncDataSchemaDimensionDTO.setDimensionNumber(dimensionNumber);
            syncDataSchemaDimensionDTO.setDimensionSystemSourceTypeEnum(ImportSystemSourceTypeEnum.getEnumByCode(dimension.getString("systemsource")));
            syncDataSchemaDimensionDTO.setDimensionSelectType(dimensionSelectType);
            syncDataSchemaDimensionDTO.setDimensionField(dimensionField);
            syncDataSchemaDimensionDTO.setMappingRelationShipDTO(FAFSyncDataSchemeHelper.getMappingRelationShipDTO(dimensionNumber, mappingRelationShipSchema));
            syncDataSchemaDimensionDTO.setDefaultValue(dimensionDefaultValue);
            if (dimensionField != null && importSystemSourceTypeEnum == ImportSystemSourceTypeEnum.getEnumByCode(dimension.getString("systemsource")) && !CollectionUtils.isEmpty((Collection)dimensionMappings)) {
                String memberModelMetadataNumber = dimensionMappings.stream().filter(dimensionMapping -> dimensionField.equals(dimensionMapping.getString("imdimnumber"))).map(dimensionMapping -> dimensionMapping.getString("membermodel")).findFirst().orElseGet(() -> null);
                syncDataSchemaDimensionDTO.setMetadataNumber(memberModelMetadataNumber);
            }
            dimEntityMappingMap.put(dimensionNumber, syncDataSchemaDimensionDTO);
        }
        OlapDataExtractingDTO olapDataExtractingDTO = new OlapDataExtractingDTO();
        olapDataExtractingDTO.setCubeCatelog(FAFSyncDataSchemeHelper.getCubeCateLog(dataSourceConfigModel, importSystemSourceTypeEnum));
        olapDataExtractingDTO.setDataSourceTypeEnum(OlapFromServiceEnum.getEnum(datasource.getString("datasource_type")));
        olapDataExtractingDTO.setModuleId(dataSourceConfigModel.getOlapRequestParam().getModuleId());
        olapDataExtractingDTO.setOrgViewId(FAFSyncDataSchemeHelper.getOrgView(dataSourceConfigModel, importSystemSourceTypeEnum));
        olapDataExtractingDTO.setAnalysisModelDyObj(AnalysisModelUtil.buildDetailEntityNumber(schema.getDynamicObject("analysismodel").getString("tablenumber")));
        olapDataExtractingDTO.setSelectDimensionMap(selectDimensionMap);
        olapDataExtractingDTO.setDimFilters(filterEntries.stream().collect(Collectors.toMap(DataSourceConfigModel.FilterEntry::getDimNumber, DataSourceConfigModel.FilterEntry::getMemberNumbers)));
        olapDataExtractingDTO.setTransformFieldIndexMap(transformFieldIndexMap);
        olapDataExtractingDTO.setDimEntityMappingMap(dimEntityMappingMap);
        return olapDataExtractingDTO;
    }

    private static List<DataSourceConfigModel.FilterEntry> getDimensionFilterEntry(DataSourceConfigModel dataSourceConfigModel, DynamicObject schema, DynamicObjectCollection dimensionMappings, Map<Object, DynamicObject> mappingRelationShipOfCurrentAnaSystem, Set<Long> orgIds, Set<Long> analysisPeriods) {
        DynamicObjectCollection schemaDimensionEntry = schema.getDynamicObjectCollection("dimensionmapentry");
        DynamicObjectCollection modelDimensionEntry = schema.getDynamicObject("analysismodel").getDynamicObjectCollection("dimension_entry");
        ImportSystemSourceTypeEnum importSystemSourceTypeEnum = DataSourceTypeEnum.transDataSourceEnumToImportEnum(dataSourceConfigModel.getDataSourceTypeEnum());
        ArrayList<DataSourceConfigModel.FilterEntry> filterEntries = new ArrayList<DataSourceConfigModel.FilterEntry>(dataSourceConfigModel.getFilterEntries());
        HashMap<String, DataSourceConfigModel.FilterEntry> mappingDimensionFilterMap = new HashMap<String, DataSourceConfigModel.FilterEntry>();
        Map<String, Set<Long>> dimensionFilterIdMap = FAFSyncDataSchemeHelper.getDimensionFilterIdMap(modelDimensionEntry, orgIds, analysisPeriods);
        for (Map.Entry<String, Set<Long>> dimensionNecessityStringIdsEntry : dimensionFilterIdMap.entrySet()) {
            String fafNecessityDimensionNumber = dimensionNecessityStringIdsEntry.getKey();
            Set<Long> fafNecessityDimensionIds = dimensionNecessityStringIdsEntry.getValue();
            Long relationShipId = schemaDimensionEntry.stream().filter(schemaDimension -> fafNecessityDimensionNumber.equals(schemaDimension.getDynamicObject("dimension").getString("number"))).map(schemaDimension -> schemaDimension.getLong("mappingrelationship_id")).findFirst().orElseGet(() -> 0L);
            MappingRelationShipDTO mappingRelationShipDTO = FAFSyncDataSchemeHelper.getMappingRelationShipDTO(fafNecessityDimensionNumber, mappingRelationShipOfCurrentAnaSystem.get(relationShipId));
            if (mappingRelationShipDTO == null) continue;
            Map<String, Set<Long>> mappingDimensionFilterIds = FAFSyncDataSchemeHelper.getImportDimensionFilterMappingIdsMap(mappingRelationShipDTO, fafNecessityDimensionIds, schemaDimensionEntry, importSystemSourceTypeEnum);
            FAFSyncDataSchemeHelper.translateQueryDimensionIdsToFilters(mappingDimensionFilterIds, mappingDimensionFilterMap, dataSourceConfigModel, dimensionMappings);
        }
        FAFSyncDataSchemeHelper.mergeMappingDimensionFilterWithDataSourceFilters(filterEntries, mappingDimensionFilterMap);
        DynamicObjectCollection modelMeasureEntry = schema.getDynamicObject("analysismodel").getDynamicObjectCollection("measure_entry");
        FAFSyncDataSchemeHelper.mergeMeasureDimensionFilterWithDataSourceFilters(modelMeasureEntry, importSystemSourceTypeEnum, filterEntries);
        return filterEntries.stream().filter(filterEntry -> !CollectionUtils.isEmpty(filterEntry.getMemberNumbers())).collect(Collectors.toList());
    }

    private static Map<String, Set<Long>> getImportDimensionFilterMappingIdsMap(MappingRelationShipDTO mappingRelationShipDTO, Set<Long> fafNecessityDimensionIds, DynamicObjectCollection schemaDimensionEntry, ImportSystemSourceTypeEnum importSystemSourceTypeEnum) {
        List<String> sourceDimensionNumbers = mappingRelationShipDTO.getSourceDimensionNumbers();
        Map<List<Object>, Object> dimMembersIdMapping = mappingRelationShipDTO.getDimMembersIdMapping();
        HashMap<String, Set<Long>> mappingDimensionFilterIds = new HashMap<String, Set<Long>>();
        for (Map.Entry<List<Object>, Object> listObjectEntry : dimMembersIdMapping.entrySet()) {
            List<Object> sourceDimValues = listObjectEntry.getKey();
            Long value = Long.valueOf(String.valueOf(listObjectEntry.getValue()));
            HashMap<String, Long> imDimensionNumberIdMap = new HashMap<String, Long>();
            if (!fafNecessityDimensionIds.contains(value)) continue;
            for (String sourceDimensionNumber : sourceDimensionNumbers) {
                String imDimensionNumber = schemaDimensionEntry.stream().filter(dimensionEntry -> sourceDimensionNumber.equals(dimensionEntry.getDynamicObject("dimension").getString("number"))).filter(dimensionEntry -> importSystemSourceTypeEnum == ImportSystemSourceTypeEnum.getEnumByCode(dimensionEntry.getDynamicObject("dimension").getString("systemsource"))).map(dimensionEntry -> dimensionEntry.getString("dimensionfield")).findFirst().orElse(null);
                if (!StringUtils.isNotBlank((CharSequence)imDimensionNumber)) continue;
                int sourceDimensionIndex = mappingRelationShipDTO.getSourceDimensionNumbers().indexOf(sourceDimensionNumber);
                long sourceDimValue = Long.parseLong(String.valueOf(sourceDimValues.get(sourceDimensionIndex)));
                imDimensionNumberIdMap.put(imDimensionNumber, sourceDimValue);
            }
            Optional<Long> imDimensionIdWithEmpty = imDimensionNumberIdMap.values().stream().filter(id -> id == null || id == 0L).findAny();
            if (imDimensionIdWithEmpty.isPresent()) continue;
            imDimensionNumberIdMap.forEach((entryKey, entryValue) -> {
                Set importDimIds = mappingDimensionFilterIds.computeIfAbsent((String)entryKey, key -> new HashSet());
                importDimIds.add(entryValue);
            });
        }
        return mappingDimensionFilterIds;
    }

    private static void mergeMeasureDimensionFilterWithDataSourceFilters(DynamicObjectCollection modelMeasureEntry, ImportSystemSourceTypeEnum importSystemSourceTypeEnum, List<DataSourceConfigModel.FilterEntry> filterEntries) {
        List<Object> measureIds = modelMeasureEntry.stream().map(entry -> entry.getDynamicObject("measure").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection measureMappings = FAFMeasureHelper.queryMeasureMappingByMeasureIds(measureIds, importSystemSourceTypeEnum);
        if (!CollectionUtils.isEmpty((Collection)measureMappings)) {
            String dimNumber;
            HashMap<String, Set> dimMemberNumbersMap = new HashMap<String, Set>(16);
            for (DynamicObject measureMapping : measureMappings) {
                dimNumber = measureMapping.getString("entryimdimnumber");
                String memberNumber = measureMapping.getString("entrymembernumber");
                Set memberNumberSet = dimMemberNumbersMap.computeIfAbsent(dimNumber, k -> new HashSet());
                memberNumberSet.add(memberNumber);
            }
            for (Map.Entry dimMemberNumbersEntry : dimMemberNumbersMap.entrySet()) {
                dimNumber = (String)dimMemberNumbersEntry.getKey();
                Set memberNumbers = (Set)dimMemberNumbersEntry.getValue();
                DataSourceConfigModel.FilterEntry filterEntry = filterEntries.stream().filter(entry -> dimNumber.equals(entry.getDimNumber())).findFirst().orElseGet(() -> null);
                if (filterEntry != null) {
                    filterEntry.setMemberNumbers(memberNumbers);
                    continue;
                }
                DataSourceConfigModel.FilterEntry newFilterEntry = new DataSourceConfigModel.FilterEntry();
                newFilterEntry.setDimNumber(dimNumber);
                newFilterEntry.setMemberNumbers(memberNumbers);
                filterEntries.add(newFilterEntry);
            }
        }
    }

    private static void mergeMappingDimensionFilterWithDataSourceFilters(List<DataSourceConfigModel.FilterEntry> filterEntries, Map<String, DataSourceConfigModel.FilterEntry> mappingDimensionFilterMap) {
        for (Map.Entry<String, DataSourceConfigModel.FilterEntry> mappingDimensionFilterEntry : mappingDimensionFilterMap.entrySet()) {
            String mappingDimensionNumber = mappingDimensionFilterEntry.getKey();
            DataSourceConfigModel.FilterEntry mappingDimensionFilter = mappingDimensionFilterEntry.getValue();
            DataSourceConfigModel.FilterEntry dataSourceFilterEntry = filterEntries.stream().filter(filter -> mappingDimensionNumber.equals(filter.getDimNumber())).findFirst().orElse(null);
            Set<String> mappingFilterMemberNumbers = mappingDimensionFilter.getMemberNumbers();
            if (dataSourceFilterEntry != null) {
                Set<String> dataSourceFilterMemberNumbers = dataSourceFilterEntry.getMemberNumbers();
                if (!CollectionUtils.isEmpty(dataSourceFilterMemberNumbers)) {
                    mappingFilterMemberNumbers.retainAll(dataSourceFilterMemberNumbers);
                }
                dataSourceFilterEntry.setMemberNumbers(mappingFilterMemberNumbers);
                continue;
            }
            DataSourceConfigModel.FilterEntry newFilterEntry = new DataSourceConfigModel.FilterEntry();
            newFilterEntry.setDimNumber(mappingDimensionNumber);
            newFilterEntry.setMemberNumbers(mappingFilterMemberNumbers);
            filterEntries.add(newFilterEntry);
        }
    }

    private static void translateQueryDimensionIdsToFilters(Map<String, Set<Long>> mappingDimensionFilterIds, Map<String, DataSourceConfigModel.FilterEntry> mappingDimensionFilterMap, DataSourceConfigModel dataSourceConfigModel, DynamicObjectCollection dimensionMappings) {
        for (Map.Entry<String, Set<Long>> dimensionFilterIdsEntry : mappingDimensionFilterIds.entrySet()) {
            String imDimensionNumber = dimensionFilterIdsEntry.getKey();
            Set<Long> dimensionFilterIds = dimensionFilterIdsEntry.getValue();
            Set<Object> importDimNumbers = new HashSet();
            if (!CollectionUtils.isEmpty(dimensionFilterIds)) {
                OlapFromServiceEnum olapFromServiceEnum = DataSourceTypeEnum.transImportEnumToOlapEnum(dataSourceConfigModel.getDataSourceTypeEnum());
                importDimNumbers = RequestFactoryBuilder.changeIdToNumber(olapFromServiceEnum, olapRequestParam -> {
                    OlapRequestParam newOlapRequestParam = dataSourceConfigModel.getOlapRequestParam();
                    Tuple dimIdAndMemberModelTuple = dimensionMappings.stream().filter(dimensionMapping -> imDimensionNumber.equals(dimensionMapping.getString("imdimnumber"))).map(dimensionMapping -> new Tuple((Object)dimensionMapping.getLong("imdimension"), (Object)dimensionMapping.getString("membermodel"))).findFirst().orElse(null);
                    if (dimIdAndMemberModelTuple != null) {
                        newOlapRequestParam.setDimId((Long)dimIdAndMemberModelTuple.item1);
                        newOlapRequestParam.setDimensionEntityName((String)dimIdAndMemberModelTuple.item2);
                    }
                    return newOlapRequestParam;
                }, dimensionFilterIds);
            }
            if (CollectionUtils.isEmpty(importDimNumbers)) continue;
            DataSourceConfigModel.FilterEntry filterEntry = mappingDimensionFilterMap.computeIfAbsent(imDimensionNumber, key -> {
                DataSourceConfigModel.FilterEntry newFilterEntry = new DataSourceConfigModel.FilterEntry();
                newFilterEntry.setDimNumber(imDimensionNumber);
                newFilterEntry.setMemberNumbers(new HashSet<String>(2));
                return newFilterEntry;
            });
            filterEntry.getMemberNumbers().addAll(importDimNumbers);
        }
    }

    public static MappingRelationShipDTO getMappingRelationShipDTO(String dimensionNumber, DynamicObject mappingRelationShipSchema) {
        if (mappingRelationShipSchema == null) {
            return null;
        }
        MappingRelationShipDTO mappingRelationShipDTO = new MappingRelationShipDTO();
        List<FAFMappingDimensionDTO> sourceMappingDimensionDTOs = FAFMappingRelationShipDataHelper.getMappingDimensionDTOsBySchema(mappingRelationShipSchema, RelationShipMappingDimensionEnum.SOURCE.getCode());
        List<String> sourceDimensionNumberOfCurrentMappingRelationShip = sourceMappingDimensionDTOs.stream().map(FAFMappingDimensionDTO::getNumber).collect(Collectors.toList());
        HashMap<List<Object>, Object> dimMembersIdMapping = new HashMap<List<Object>, Object>(16);
        for (DynamicObject mappingEntry : mappingRelationShipSchema.getDynamicObjectCollection("entryentity")) {
            LinkedHashMap sourceDimMap = (LinkedHashMap)JSON.parseObject((String)mappingEntry.getString("sourcedimtext"), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            LinkedHashMap targetDimMap = (LinkedHashMap)JSON.parseObject((String)mappingEntry.getString("targetdimtext"), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            dimMembersIdMapping.put(new ArrayList(sourceDimMap.values()), targetDimMap.get(dimensionNumber));
        }
        mappingRelationShipDTO.setSourceDimensionNumbers(sourceDimensionNumberOfCurrentMappingRelationShip);
        mappingRelationShipDTO.setTargetDimensionNumber(dimensionNumber);
        mappingRelationShipDTO.setDimMembersIdMapping(dimMembersIdMapping);
        return mappingRelationShipDTO;
    }

    private static String getCubeCateLog(DataSourceConfigModel dataSourceConfigModel, ImportSystemSourceTypeEnum importSystemSourceTypeEnum) {
        String cubeCateLog = null;
        switch (importSystemSourceTypeEnum) {
            case BCM: {
                cubeCateLog = ((BcmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam()).getCubeCatelog();
                break;
            }
            case EPM: {
                cubeCateLog = ((EpmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam()).getDatasetId() + "";
            }
        }
        return cubeCateLog;
    }

    private static Long getOrgView(DataSourceConfigModel dataSourceConfigModel, ImportSystemSourceTypeEnum importSystemSourceTypeEnum) {
        Long orgViewId = null;
        switch (importSystemSourceTypeEnum) {
            case BCM: {
                orgViewId = ((BcmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam()).getOrgViewId();
            }
        }
        return orgViewId;
    }

    private static Map<String, Set<Long>> getDimensionFilterIdMap(DynamicObjectCollection modelDimensionEntry, Set<Long> orgIds, Set<Long> analysisPeriods) {
        HashMap<String, Set<Long>> dimensionFilterIdMap = new HashMap<String, Set<Long>>();
        modelDimensionEntry.forEach(entry -> {
            DimensionNecessityEnum necessityEnum = DimensionNecessityEnum.getEnum(entry.getString("necessity_dim"));
            String number = entry.getDynamicObject("dimension").getString("number");
            if (necessityEnum != null) {
                switch (necessityEnum) {
                    case ORG: {
                        dimensionFilterIdMap.put(number, orgIds);
                        break;
                    }
                    case PERIOD: {
                        dimensionFilterIdMap.put(number, analysisPeriods);
                        break;
                    }
                }
            }
        });
        return dimensionFilterIdMap;
    }
}

