/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import com.alibaba.fastjson.JSONArray;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.enums.FAFStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.event.IWorkTaskStatusEvent;
import kd.macc.faf.util.IDataBeanUtil;
import kd.macc.faf.util.IDataValueUtil;

public class FAFSyncTaskLogHelper {
    private static final Log logger = LogFactory.getLog(FAFSyncTaskLogHelper.class);

    public static Long createSyncTask(Long dataSchemeId, String dataSchemeName, FAFWorkTaskTypeEnum taskType) {
        DynamicObject syncTask = BusinessDataServiceHelper.newDynamicObject((String)"pa_taskpreview");
        syncTask.set("syncdatascheme", (Object)dataSchemeId);
        syncTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        syncTask.set("createtime", (Object)new Date());
        syncTask.set("status", (Object)FAFStatusEnum.NEW.getCodeString());
        syncTask.set("tasktype", (Object)String.valueOf(taskType.getValue()));
        syncTask.set("syncschemename", (Object)dataSchemeName);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncTask});
        return (Long)syncTask.getPkValue();
    }

    public static DynamicObject createSyncLog(IWorkTaskTransLog<Long> transLog) {
        if (transLog instanceof FAFWorkTaskMeta) {
            FAFWorkTaskMeta meta = (FAFWorkTaskMeta)transLog;
            DynamicObject syncLog = BusinessDataServiceHelper.newDynamicObject((String)"pa_tasklog");
            syncLog.set("status", (Object)FAFStatusEnum.NEW.getCodeString());
            syncLog.set("datasynctask", (Object)meta.getTaskId());
            syncLog.set("syncdatascheme", (Object)meta.getDataSchemeId());
            syncLog.set("syncschemename", (Object)meta.getDataSchemeName());
            QFilter syncParamIdFilter = new QFilter("id", "=", (Object)meta.getDataSchemeId());
            DynamicObject schemeParam = QueryServiceHelper.queryOne((String)"pa_syncdataschema", (String)"datasource,analysismodel", (QFilter[])syncParamIdFilter.toArray());
            if (schemeParam != null) {
                syncLog.set("datasource", (Object)schemeParam.getLong("dataSource"));
                syncLog.set("analysismodel", (Object)schemeParam.getLong("analysismodel"));
            }
            syncLog.set("tasktype", (Object)String.valueOf(meta.getTaskType().getValue()));
            syncLog.set("createtime", (Object)new Date());
            OperationServiceImpl operationService = new OperationServiceImpl();
            OperationResult saveSyncLogResult = operationService.localInvokeOperation("save", new DynamicObject[]{syncLog}, OperateOption.create());
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u65b0\u589e\u540c\u6b65\u4efb\u52a1\u65e5\u5fd7: %s", saveSyncLogResult.isSuccess()));
                if (!saveSyncLogResult.isSuccess()) {
                    List allErrorInfo = saveSyncLogResult.getAllErrorInfo();
                    StringBuilder sb = new StringBuilder();
                    for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                        sb.append(operateErrorInfo.toString());
                    }
                    logger.info(String.format("\u65b0\u589e\u540c\u6b65\u4efb\u52a1\u65e5\u5fd7\u9519\u8bef\u65e5\u5fd7: %s", sb.toString()));
                }
            }
            if (saveSyncLogResult.isSuccess()) {
                Long logId = Long.parseLong(saveSyncLogResult.getSuccessPkIds().get(0).toString());
                syncLog.set("id", (Object)logId);
                return syncLog;
            }
        }
        return null;
    }

    public static IWorkTaskStatusEvent getCachedWorkTaskStatusEvent(String cacheStatusStr) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray(cacheStatusStr);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (IWorkTaskStatusEvent)IDataBeanUtil.getClassNewInstance(IDataBeanUtil.getClassByName(String.valueOf(jsonArray.get(0))), jsonArray);
    }
}

