/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;
import kd.macc.faf.dto.SourceToModelTableMappingDTO;
import kd.macc.faf.enums.FAFCollectStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.enums.OperationStatusEnum;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.rdb.RdbSQLInfo;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.FAFTableUtil;

public class FAFTableDataHelper {
    private static final Log logger = LogFactory.getLog(FAFTableDataHelper.class);

    public static DataSet fixDimStatistic(String entity, String[] groupByDim, boolean isCalculate, QFilter[] filters) {
        QFilter[] qfilters;
        if (filters == null || filters.length <= 0) {
            qfilters = new QFilter[]{FAFTableDataHelper.fixFilter(isCalculate)};
        } else {
            qfilters = new QFilter[filters.length + 1];
            System.arraycopy(filters, 0, qfilters, 0, filters.length);
            qfilters[filters.length] = FAFTableDataHelper.fixFilter(isCalculate);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fixDimStatistic", (String)entity, (String)FAFTableDataHelper.arrayToStr(groupByDim), (QFilter[])qfilters, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.distinct();
    }

    public static String arrayToStr(String[] array) {
        StringBuilder sb = new StringBuilder(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                sb.append(',').append(array[i]);
            }
        }
        return sb.toString();
    }

    public static DataSet queryByRdbSQLInfo(RdbSQLInfo rdbSQLInfo, String orderBys, int from, int length) {
        QFilter[] newFilters = FAFTableDataHelper.queryByRdbSQLInfoFilter(rdbSQLInfo, true);
        ORM orm = ORM.create();
        return orm.queryDataSet("queryByRdbSQLInfo", rdbSQLInfo.getEntityNumber(), rdbSQLInfo.getSelectFields(), newFilters, orderBys, from, length);
    }

    public static DataSet querySummaryByRdbSQLInfo(RdbSQLInfo rdbSQLInfo) {
        QFilter[] newFilters = FAFTableDataHelper.queryByRdbSQLInfoFilter(rdbSQLInfo, true);
        return QueryServiceHelper.queryDataSet((String)rdbSQLInfo.getRouteKey(), (String)rdbSQLInfo.getEntityNumber(), (String)rdbSQLInfo.getSelectFields(), (QFilter[])newFilters, null);
    }

    public static DataSet queryByRdbSQLInfoLimit(RdbSQLInfo rdbSQLInfo, int top) {
        QFilter[] newFilters = FAFTableDataHelper.queryByRdbSQLInfoFilter(rdbSQLInfo, false);
        return QueryServiceHelper.queryDataSet((String)rdbSQLInfo.getRouteKey(), (String)rdbSQLInfo.getEntityNumber(), (String)rdbSQLInfo.getSelectFields(), (QFilter[])newFilters, null, (int)top);
    }

    public static QFilter[] queryByRdbSQLInfoFilter(RdbSQLInfo rdbSQLInfo, boolean isCalculate) {
        QFilter[] filters = rdbSQLInfo.getFilters();
        QFilter[] newFilters = null;
        if (filters == null) {
            newFilters = new QFilter[]{FAFTableDataHelper.fixFilter(isCalculate)};
        } else {
            newFilters = new QFilter[filters.length + 1];
            System.arraycopy(filters, 0, newFilters, 0, filters.length);
            newFilters[filters.length] = FAFTableDataHelper.fixFilter(isCalculate);
        }
        return newFilters;
    }

    public static QFilter fixFilter(boolean isCalculate) {
        if (isCalculate) {
            return new QFilter("collectstatus", "=", (Object)FAFCollectStatusEnum.COLLECT.getCode());
        }
        QFilter filter = new QFilter("operationstatus", "=", (Object)OperationStatusEnum.UNUSED.getCode());
        filter.and("collectstatus", "=", (Object)FAFCollectStatusEnum.DETAIL.getCode());
        return filter;
    }

    public static Map<Object, List<Object>> queryDimensionData(FAFDimensionModel dimensionModel, String[] attrs, Collection<Object> idList) {
        String entityName = dimensionModel.getSource().getNumber();
        StringBuilder selectField = new StringBuilder("id");
        for (String attr : attrs) {
            selectField.append(',').append(attr);
        }
        HashMap<Object, List<Object>> classifyMap = new HashMap<Object, List<Object>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDimensionData", (String)entityName, (String)selectField.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);){
            for (Row row : dataSet) {
                StringBuilder keyBuild = new StringBuilder();
                for (String attr : attrs) {
                    keyBuild.append(row.get(attr));
                }
                String attrValue = keyBuild.toString();
                List classifyIdList = classifyMap.computeIfAbsent(attrValue, k -> new ArrayList(10));
                classifyIdList.add(row.get("id"));
            }
        }
        return classifyMap;
    }

    public static String[] dimToField(List<FAFDimensionModel> dimList) {
        String[] fields = new String[dimList.size()];
        int i = 0;
        for (FAFDimensionModel dimension : dimList) {
            fields[i] = dimension.getNumber();
            ++i;
        }
        return fields;
    }

    public static String selectField(FAFAnalysisModelModel analysisModelMode, boolean needCal) {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        for (FAFDimensionModel dimensionModel : analysisModelMode.getAllDim()) {
            sb.append(",").append(dimensionModel.getNumber());
        }
        for (FAFMeasureModel measureModel : analysisModelMode.getOrdinaryMeasure()) {
            sb.append(",").append(measureModel.getNumber());
        }
        if (needCal && analysisModelMode.getCalMeasure() != null) {
            for (FAFMeasureModel measureModel : analysisModelMode.getCalMeasure()) {
                sb.append(",").append(measureModel.getNumber());
            }
        }
        return sb.toString();
    }

    public static DynamicObjectCollection load(String entityNumber, String measureField, QFilter filter) {
        return QueryServiceHelper.query((String)entityNumber, (String)("id," + measureField), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection load(String entityNumber, String measureField, QFilter[] filters) {
        return QueryServiceHelper.query((String)entityNumber, (String)("id," + measureField), (QFilter[])filters);
    }

    public static void save(Collection<DynamicObject> dataList, boolean isInsert) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        int row = 0;
        Object[] dynamicObjects = new DynamicObject[1000];
        IDataEntityType dt = dataList.iterator().next().getDataEntityType();
        for (DynamicObject data : dataList) {
            dynamicObjects[row++] = data;
            if (row != dynamicObjects.length) continue;
            if (isInsert) {
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])dynamicObjects);
            } else {
                BusinessDataWriter.update((IDataEntityType)dt, (Object[])dynamicObjects);
            }
            dynamicObjects = new DynamicObject[1000];
            row = 0;
        }
        if (row > 0) {
            if (isInsert) {
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])Arrays.copyOf(dynamicObjects, row));
            } else {
                BusinessDataWriter.update((IDataEntityType)dt, (Object[])Arrays.copyOf(dynamicObjects, row));
            }
        }
    }

    public static void insert(Collection<DynamicObject> dataList) {
        FAFTableDataHelper.save(dataList, true);
    }

    public static void update(Collection<DynamicObject> dataList) {
        FAFTableDataHelper.save(dataList, false);
    }

    public static SourceToModelTableMappingDTO queryOneSourceToModelTableMapping(Long anaModelId, Long modelTableId) {
        DynamicObject modelDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)anaModelId, (String)"pa_analysismodel");
        String tableNumber = modelDynamicObject.getString("tablenumber");
        if (kd.bos.util.StringUtils.isEmpty((String)tableNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5df2\u88ab\u5220\u9664", (String)"FAFTableDataHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber(tableNumber);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType.getProperty("importbatch") != null) {
            DynamicObject modelTable = BusinessDataServiceHelper.loadSingleFromCache((Object)modelTableId, (String)entityNumber);
            if (modelTable == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664", (String)"FAFTableDataHelper_1", (String)"macc-faf-common", (Object[])new Object[0]));
            }
            String importBatch = modelTable.getString("importbatch");
            if (kd.bos.util.StringUtils.isNotEmpty((String)importBatch)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4e3a\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u524d\u5f80\u6a21\u578b\u7684\u6570\u636e\u8865\u5f55\u5217\u8868\u67e5\u770b\u3002", (String)"FAFTableDataHelper_2", (String)"macc-faf-common", (Object[])new Object[0]));
            }
        }
        return FAFTableDataHelper.queryOneSourceToModelTableMapping(anaModelId, true, modelTableId);
    }

    public static SourceToModelTableMappingDTO queryOneSourceToModelTableMapping(Long anaModelId, boolean throwException, Long modelTableId) {
        List<SourceToModelTableMappingDTO> sourceToModelTableMappingDTOS = FAFTableDataHelper.transformQuerySourceModelTable(anaModelId, throwException, modelTableId);
        return sourceToModelTableMappingDTOS.stream().findFirst().orElse(null);
    }

    public static List<SourceToModelTableMappingDTO> transformQuerySourceModelTable(Long anaModelId, boolean throwException, Long ... modelTableIds) {
        QFilter filter;
        String entityName;
        Map dynamicObjectMap;
        if (anaModelId == null || anaModelId <= 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u5206\u6790\u6a21\u578bId\u4e0d\u5408\u6cd5", (String)"FAFTableDataHelper_3", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (modelTableIds == null || modelTableIds.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5206\u6790\u6a21\u578b\u7684\u660e\u7ec6\u8bb0\u5f55", (String)"FAFTableDataHelper_4", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        ArrayList<SourceToModelTableMappingDTO> result = new ArrayList<SourceToModelTableMappingDTO>(1);
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)anaModelId, (String)"pa_analysismodel", (String)"tablenumber");
        if (analysisModelObj != null && StringUtils.isNotBlank((CharSequence)analysisModelObj.getString("tablenumber")) && (dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)(entityName = AnalysisModelUtil.buildDetailEntityNumber(analysisModelObj.getString("tablenumber"))), (String)"id,sourceformid,sourcebillid", (QFilter[])(filter = new QFilter("id", "in", (Object)modelTableIds)).toArray())) != null) {
            result = new ArrayList(dynamicObjectMap.size());
            for (Map.Entry objectDynamicObjectEntry : dynamicObjectMap.entrySet()) {
                DynamicObject obj = (DynamicObject)objectDynamicObjectEntry.getValue();
                result.add(SourceToModelTableMappingDTO.buildOf(anaModelId, obj.getLong("id"), obj.getString("sourceformid"), obj.getLong("sourcebillid")));
            }
            if (CollectionUtils.isEmpty(result) && throwException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u7684\u6e90\u5355\u8bb0\u5f55", (String)"FAFTableDataHelper_5", (String)"macc-faf-common", (Object[])new Object[0]));
            }
        }
        return result;
    }

    public static List<Object> delete(String entityName, QFilter[] qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        String pkProperty = dt.getPrimaryKey().getName();
        ArrayList<Object> pks = new ArrayList<Object>(50);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("fi.pa.PATableDataHelper" + entityName), (String)entityName, (String)pkProperty, (QFilter[])qFilters, null);){
            Iterator iter = ds.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks.toArray());
                    break;
                }
                pks.add(((Row)iter.next()).get(0));
            }
        }
        catch (Exception ex) {
            throw new KDBizException("delete erro" + ex.getMessage());
        }
        RecordSaveFormServiceHelper.recordSaveFormToCache((String)entityName);
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkAndRebuildEntity(Object analysisModelId, String tableNumber) {
        boolean exist;
        Long modelId;
        if (analysisModelId instanceof Long) {
            modelId = (Long)analysisModelId;
        } else {
            if (!(analysisModelId instanceof String)) return;
            modelId = Long.parseLong((String)analysisModelId);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)tableNumber) || (exist = MetadataDao.checkNumber((String)AnalysisModelUtil.buildDetailEntityNumber(tableNumber)))) return;
        Class<FAFTableDataHelper> clazz = FAFTableDataHelper.class;
        synchronized (FAFTableDataHelper.class) {
            if (MetadataDao.checkNumber((String)AnalysisModelUtil.buildDetailEntityNumber(tableNumber))) return;
            DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel", (String)"tablename");
            FAFTableUtil.createOrDropTable(modelId, FAFWorkTaskTypeEnum.Create_Table_Task, tableNumber, analysisModel.getString("tablename"), Boolean.FALSE);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkAndRebuildEntity(Object analysisModelId) {
        boolean exist;
        Long modelId;
        if (analysisModelId instanceof Long) {
            modelId = (Long)analysisModelId;
        } else {
            if (!(analysisModelId instanceof String)) return;
            modelId = Long.parseLong((String)analysisModelId);
        }
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel", (String)"tablenumber, tablename");
        String entityNumber = analysisModel.getString("tablenumber");
        if (kd.bos.util.StringUtils.isEmpty((String)entityNumber) || (exist = MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber(entityNumber)))) return;
        Class<FAFTableDataHelper> clazz = FAFTableDataHelper.class;
        synchronized (FAFTableDataHelper.class) {
            if (MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber(entityNumber))) return;
            FAFTableUtil.createOrDropTable(modelId, FAFWorkTaskTypeEnum.Create_Table_Task, entityNumber, analysisModel.getString("tablename"), Boolean.FALSE);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }
}

