/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.DimensionTypeEnum;

public class GLVoucherHelper {
    public static final String TYPE_BASEDATA = "1";

    public static Map<String, String> matchDimension(DimensionTypeEnum dimensionTypeEnum, String baseEntityId, Long assistantTypeId) {
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GLVoucherHelper.matchDimension", (String)"bd_asstacttype", (String)"number,name,flexfield,valuetype,valuesource,assistanttype", null, null);){
            for (Row row : dataSet) {
                String valueType = row.getString("valuetype");
                DimensionTypeEnum dataTypeEnum = DimensionTypeEnum.getEnum(valueType);
                if (dataTypeEnum != dimensionTypeEnum) continue;
                boolean isMatch = false;
                switch (dataTypeEnum) {
                    case DATABASE: {
                        String entityId = row.getString("valuesource");
                        isMatch = baseEntityId.equals(entityId);
                        break;
                    }
                    case ASSISTANTDATA: {
                        Long assistanttype = row.getLong("assistanttype");
                        isMatch = assistantTypeId.equals(assistanttype);
                        break;
                    }
                    case OTHER: {
                        isMatch = true;
                    }
                }
                if (!isMatch) continue;
                String flexField = row.getString("flexfield");
                String name = row.getString("name");
                dataMap.put(flexField, name);
            }
        }
        return dataMap;
    }

    public static Map<String, String> queryDimension() {
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GLVoucherHelper.matchDimension", (String)"bd_asstacttype", (String)"name,flexfield", null, null);){
            for (Row row : dataSet) {
                String flexField = row.getString("flexfield");
                String name = row.getString("name");
                dataMap.put(flexField, name);
            }
        }
        return dataMap;
    }

    public static Map<String, String> flexDimension(Map<String, String> flexField, Map<String, String> asstactTypeField) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(2 * asstactTypeField.size());
        for (Map.Entry<String, String> prefix : flexField.entrySet()) {
            for (Map.Entry<String, String> entry : asstactTypeField.entrySet()) {
                fieldMap.put(prefix.getKey() + "_" + entry.getKey(), prefix.getValue() + "_" + entry.getValue());
            }
        }
        return fieldMap;
    }

    public static String delFlexFieldPrefix(String sourceFiledName, String flexfield) {
        String prefix = flexfield + "_";
        return sourceFiledName.substring(prefix.length());
    }
}

