/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.enums.ModelUpgradeStatusEnum;
import kd.macc.faf.exception.ModelUpgradeException;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;

public class ModelUpgradeHelper {
    public static Map<Long, List<Long>> getCurrentEnableUpgradeModelIds() {
        HashMap<Long, List<Long>> ToUpgradeModelIdsGroupedBySystem = new HashMap<Long, List<Long>>();
        QFilter versionFilter = new QFilter("version", "!=", (Object)"1");
        QFilter tableNumberFilter = new QFilter("tablenumber", "!=", (Object)" ");
        DynamicObjectCollection oldVersionModelDys = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,analysis_system", (QFilter[])new QFilter[]{versionFilter, tableNumberFilter});
        if (!CollectionUtils.isEmpty((Collection)oldVersionModelDys)) {
            Map oldVersionModelIdsGroupedBySystem = oldVersionModelDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("analysis_system"), Collectors.mapping(dy -> dy.getLong("id"), Collectors.toList())));
            QFilter statusFilter = new QFilter("entryentity.upgradestatus", "in", (Object)new String[]{ModelUpgradeStatusEnum.TO_UPGRADE.getCode(), ModelUpgradeStatusEnum.UPGRADING.getCode(), ModelUpgradeStatusEnum.SUCCESS.getCode()});
            DynamicObjectCollection underUpgradingModelRecords = QueryServiceHelper.query((String)"faf_modelupgraderecord", (String)"id,anasystem,entryentity.anamodel", (QFilter[])statusFilter.toArray());
            if (!CollectionUtils.isEmpty((Collection)underUpgradingModelRecords)) {
                Map<Long, List<DynamicObject>> modelUnderUpgradingBySystem = underUpgradingModelRecords.stream().collect(Collectors.groupingBy(record -> record.getLong("anasystem")));
                for (Map.Entry oldVersionModelIdsEntry : oldVersionModelIdsGroupedBySystem.entrySet()) {
                    Long systemId = oldVersionModelIdsEntry.getKey();
                    List oldVersionModels = oldVersionModelIdsEntry.getValue();
                    List<DynamicObject> modelOfCurrentSystem = modelUnderUpgradingBySystem.get(systemId);
                    if (!CollectionUtils.isEmpty(modelOfCurrentSystem)) {
                        Set unableUpgradeModelIds = modelOfCurrentSystem.stream().map(dy -> dy.getLong("entryentity.anamodel")).collect(Collectors.toSet());
                        oldVersionModels.removeAll(unableUpgradeModelIds);
                    }
                    ToUpgradeModelIdsGroupedBySystem.put(systemId, oldVersionModels);
                }
            } else {
                ToUpgradeModelIdsGroupedBySystem.putAll(oldVersionModelIdsGroupedBySystem);
            }
        }
        return ToUpgradeModelIdsGroupedBySystem;
    }

    public static DynamicObject[] loadModelUpgradeRecordsByAnaSystemIds(Set<Long> anaSystemIds) {
        return BusinessDataServiceHelper.load((String)"faf_modelupgraderecord", (String)"id,anasystem,lastedtaskid,entryentity.anamodel,entryentity.upgradestatus,entryentity.summarytablenumber,entryentity.detailtablenumber,entryentity.upgradecountinpurpose,entryentity.upgradecountinfact,entryentity.taskid,entryentity.errormessage,entryentity.starttime,entryentity.endtime", (QFilter[])new QFilter("anasystem", "in", anaSystemIds).toArray());
    }

    public static DynamicObject loadModelUpgradeRecordsByAnaSystemId(Long anaSystemId) {
        return BusinessDataServiceHelper.loadSingle((String)"faf_modelupgraderecord", (String)"id,anasystem,lastedtaskid,entryentity.anamodel,entryentity.upgradestatus,entryentity.summarytablenumber,entryentity.detailtablenumber,entryentity.upgradecountinpurpose,entryentity.upgradecountinfact,entryentity.taskid,entryentity.errormessage,entryentity.starttime,entryentity.endtime", (QFilter[])new QFilter("anasystem", "=", (Object)anaSystemId).toArray());
    }

    public static Tuple<Boolean, String> cancelModelUpgrade(Long systemId, List<Long> modelIds) {
        boolean isTrue = ModelUpgradeHelper.assertModelUpgradeStatus(systemId, modelIds, modelUpgradeStatusEnum -> ModelUpgradeStatusEnum.TO_UPGRADE == modelUpgradeStatusEnum || ModelUpgradeStatusEnum.UPGRADING == modelUpgradeStatusEnum);
        if (!isTrue) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u53d6\u6d88\u5347\u7ea7\u72b6\u6001\u4e3a\uff1a\u3010\u65b0\u589e\u3011\u6216\u3010\u8fdb\u884c\u4e2d\u3011\u7684\u4efb\u52a1\u3002", (String)"ModelUpgradeHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        DynamicObject upgradeRecordDy = ModelUpgradeHelper.loadModelUpgradeRecordsByAnaSystemId(systemId);
        for (DynamicObject modelUpgradeRecord : upgradeRecordDy.getDynamicObjectCollection("entryentity")) {
            long modelId = modelUpgradeRecord.getLong("anamodel_id");
            if (!modelIds.contains(modelId)) continue;
            String detailTableEntityNumber = AnalysisModelUtil.getEntityNumberByTableNumber(modelUpgradeRecord.getString("detailtablenumber"));
            if (MetadataDao.checkNumber((String)detailTableEntityNumber)) {
                CustomizedDynamicFormBuilderUtil.deleteForm(detailTableEntityNumber, true);
            }
            modelUpgradeRecord.set("upgradestatus", (Object)ModelUpgradeStatusEnum.CANCEL_UPGRADE.getCode());
            modelUpgradeRecord.set("detailtablenumber", (Object)"");
        }
        SaveServiceHelper.update((DynamicObject)upgradeRecordDy);
        return new Tuple((Object)true, (Object)"");
    }

    private static boolean assertModelUpgradeStatus(Long systemId, List<Long> modelIds, Predicate<ModelUpgradeStatusEnum> predicate) {
        QFilter systemFilter = new QFilter("anasystem", "=", (Object)systemId);
        QFilter modelFilter = new QFilter("entryentity.anamodel", "in", modelIds);
        DataSet modelUpgradeRecord = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.helper.ModelUpgradeHelper", (String)"faf_modelupgraderecord", (String)"id,entryentity.upgradestatus", (QFilter[])new QFilter[]{systemFilter, modelFilter}, null);
        for (Row row : modelUpgradeRecord) {
            ModelUpgradeStatusEnum statusEnum = ModelUpgradeStatusEnum.getEnumByCode(row.getString("entryentity.upgradestatus"));
            if (predicate.test(statusEnum)) continue;
            return false;
        }
        return true;
    }

    public static void preExecuteUpgradeModel(Map<Long, List<Long>> toUpgradeSystemModelsMap) {
        boolean isValid = ModelUpgradeHelper.validateUpgradeModel(toUpgradeSystemModelsMap);
        if (!isValid) {
            throw new ModelUpgradeException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5b58\u5728\u3010\u65b0\u589e\u3011\uff0c\u3010\u8fdb\u884c\u4e2d\u3011\u6216\u3010\u6210\u529f\u3011\u7684\u6a21\u578b\u5347\u7ea7\u8bb0\u5f55\u72b6\u6001,\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u578b\u8fdb\u884c\u5347\u7ea7\u3002", (String)"ModelUpgradeHelper_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        ModelUpgradeHelper.createOrUpdateModelUpgradeRecords(toUpgradeSystemModelsMap);
    }

    private static boolean validateUpgradeModel(Map<Long, List<Long>> returnData) {
        Map<Long, List<Long>> currentEnableUpgradeModelIdsOfSystem = ModelUpgradeHelper.getCurrentEnableUpgradeModelIds();
        for (Map.Entry<Long, List<Long>> currentToUpgradeModelEntry : returnData.entrySet()) {
            Long systemId = currentToUpgradeModelEntry.getKey();
            List<Long> toUpgradeModelIds = currentToUpgradeModelEntry.getValue();
            List<Long> enableUpgradeModelIds = currentEnableUpgradeModelIdsOfSystem.get(systemId);
            if (CollectionUtils.isEmpty(enableUpgradeModelIds)) {
                return false;
            }
            ArrayList<Long> validateModelIds = new ArrayList<Long>(toUpgradeModelIds);
            validateModelIds.removeAll(enableUpgradeModelIds);
            if (CollectionUtils.isEmpty(validateModelIds)) continue;
            return false;
        }
        return true;
    }

    private static void createOrUpdateModelUpgradeRecords(Map<Long, List<Long>> toUpgradeSystemModelsMap) {
        Map<Long, DynamicObject> modelUpgradeRecordSystemMap = Stream.of(ModelUpgradeHelper.loadModelUpgradeRecordsByAnaSystemIds(toUpgradeSystemModelsMap.keySet())).collect(Collectors.toMap(dy -> dy.getLong("anasystem_id"), dy -> dy));
        Map<Object, DynamicObject> toBeUpgradedModelDyIdsMap = ModelUpgradeHelper.getToBeUpgradedModelDys(toUpgradeSystemModelsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        Queue systemPkIds = Arrays.stream(DB.genGlobalLongIds((int)toUpgradeSystemModelsMap.size())).boxed().collect(Collectors.toCollection(LinkedList::new));
        Queue modelPkIds = Arrays.stream(DB.genGlobalLongIds((int)toBeUpgradedModelDyIdsMap.size())).boxed().collect(Collectors.toCollection(LinkedList::new));
        ArrayList<DynamicObject> systemModelUpgradeRecords = new ArrayList<DynamicObject>(toUpgradeSystemModelsMap.size());
        for (Map.Entry<Long, List<Long>> systemIdAndModelIdsEntry : toUpgradeSystemModelsMap.entrySet()) {
            Long systemId = systemIdAndModelIdsEntry.getKey();
            List<Long> modelIdsGroupedSystem = systemIdAndModelIdsEntry.getValue();
            DynamicObject modelUpgradeRecordOfSystem = modelUpgradeRecordSystemMap.get(systemId);
            if (modelUpgradeRecordOfSystem == null) {
                modelUpgradeRecordOfSystem = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"faf_modelupgraderecord"));
                modelUpgradeRecordOfSystem.set("id", systemPkIds.poll());
                modelUpgradeRecordOfSystem.set("anasystem", (Object)systemId);
            }
            DynamicObjectCollection entryEntity = modelUpgradeRecordOfSystem.getDynamicObjectCollection("entryentity");
            for (Long modelId : modelIdsGroupedSystem) {
                DynamicObject modelRecordEntry;
                DynamicObject model = toBeUpgradedModelDyIdsMap.get(modelId);
                Optional<DynamicObject> any = entryEntity.stream().filter(dy -> modelId.longValue() == dy.getLong("anamodel_id")).findAny();
                if (any.isPresent()) {
                    modelRecordEntry = any.get();
                    modelRecordEntry.set("upgradestatus", (Object)ModelUpgradeStatusEnum.TO_UPGRADE.getCode());
                    modelRecordEntry.set("upgradecountinpurpose", (Object)0);
                    modelRecordEntry.set("upgradecountinfact", (Object)0);
                    modelRecordEntry.set("summarytablenumber", (Object)("t_" + AnalysisModelUtil.buildEntityNumber(model.getString("tablenumber"))));
                    modelRecordEntry.set("detailtablenumber", (Object)("t_" + AnalysisModelUtil.buildDetailEntityNumber(model.getString("tablenumber"))));
                    modelRecordEntry.set("errormessage", (Object)"");
                    modelRecordEntry.set("taskid", (Object)0L);
                    modelRecordEntry.set("starttime", null);
                    modelRecordEntry.set("endtime", null);
                    continue;
                }
                modelRecordEntry = new DynamicObject(entryEntity.getDynamicObjectType());
                modelRecordEntry.set("id", modelPkIds.poll());
                modelRecordEntry.set("anamodel", (Object)modelId);
                modelRecordEntry.set("upgradestatus", (Object)ModelUpgradeStatusEnum.TO_UPGRADE.getCode());
                modelRecordEntry.set("summarytablenumber", (Object)("t_" + AnalysisModelUtil.buildEntityNumber(model.getString("tablenumber"))));
                modelRecordEntry.set("detailtablenumber", (Object)("t_" + AnalysisModelUtil.buildDetailEntityNumber(model.getString("tablenumber"))));
                entryEntity.add((Object)modelRecordEntry);
            }
            systemModelUpgradeRecords.add(modelUpgradeRecordOfSystem);
        }
        SaveServiceHelper.save((DynamicObject[])systemModelUpgradeRecords.toArray(new DynamicObject[toUpgradeSystemModelsMap.size()]));
    }

    private static Map<Object, DynamicObject> getToBeUpgradedModelDys(Set<Long> anaModelIds) {
        if (CollectionUtils.isEmpty(anaModelIds)) {
            throw new ModelUpgradeException(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u5f85\u5347\u7ea7\u7684\u5206\u6790\u6a21\u578b", (String)"ModelUpgradeHelper_2", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        QFilter idFilter = new QFilter("id", "in", anaModelIds);
        QFilter versionFilter = new QFilter("version", "!=", (Object)"1");
        QFilter tableNumberFilter = new QFilter("tablenumber", "!=", (Object)" ");
        return BusinessDataServiceHelper.loadFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{idFilter, versionFilter, tableNumberFilter});
    }
}

