/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.helper;

import java.util.function.BiFunction;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.rdb.RdbSQLInfo;

public class QueryRDBHelper {
    private static final Log logger = LogFactory.getLog(QueryRDBHelper.class);

    public static DataSet queryDataSet(String algoKey, String entityName, String selectFields, QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.queryDataSet(algoKey, entityName, selectFields, filters);
    }

    public static long queryRDataBaseToDataSet(RdbSQLInfo rdbSQLInfo, QFilter[] qFilter, BiFunction<QFilter[], DataSet, Long> dataConsumer) {
        if (dataConsumer == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684DataSet\u6570\u636e\u5904\u7406\u5668", (String)"QueryRDBHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (rdbSQLInfo == null || !rdbSQLInfo.validate().booleanValue()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684DataSet\u67e5\u8be2\u4fe1\u606f\uff1a%s", (String)"QueryRDBHelper_1", (String)"macc-faf-common", (Object[])new Object[0]), rdbSQLInfo != null ? rdbSQLInfo.toString() : null));
        }
        try {
            DataSet dataSet = QueryRDBHelper.queryDataSet("kd.fi.pa.helper.QueryRDBHelper", rdbSQLInfo.getEntityNumber(), rdbSQLInfo.getSelectFields(), qFilter);
            if (!dataSet.hasNext()) {
                return 0L;
            }
            return dataConsumer.apply(qFilter, dataSet);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5173\u7cfb\u578b\u6570\u636e\u5e93 \u67e5\u8be2\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%1$s, rdbSQLInfo=%2$s", (String)"QueryRDBHelper_2", (String)"macc-faf-common", (Object[])new Object[0]), ex.getMessage(), rdbSQLInfo.toString())), new Object[0]);
        }
    }

    public static void batchUpdateDeleteMark(String targetEntityName, QFilter[] qFilters, Long token) {
        DynamicObject[] dynamicObjects;
        int pageSize = 2000;
        while ((dynamicObjects = BusinessDataServiceHelper.load((String)targetEntityName, (String)"del", (QFilter[])qFilters, null, (int)pageSize)) != null && dynamicObjects.length != 0) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject dynamicObject = dynamicObjects[i];
                dynamicObject.set("del", (Object)token);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            if (dynamicObjects.length > 0) continue;
        }
    }
}

