/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.model.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.model.impl.BasePropModel;
import kd.macc.faf.model.impl.IDataBaseModel;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.ParamBuilder;
import org.apache.commons.lang3.StringUtils;

public class DataSourceConfigModel
extends BasePropModel {
    DataSourceTypeEnum dataSourceTypeEnum;
    OlapRequestParam olapRequestParam;
    List<FilterEntry> filterEntries;

    @Override
    public void loadFromDynamicObject(DynamicObject sourceDynamicObject) {
        DynamicObjectCollection entryentity;
        super.loadFromDynamicObject(sourceDynamicObject);
        String type = sourceDynamicObject.getString("datasource_type");
        this.dataSourceTypeEnum = DataSourceTypeEnum.getEnum(type);
        String paramsrc_tag = sourceDynamicObject.getString("paramsrc_tag");
        if (StringUtils.isNotBlank((CharSequence)paramsrc_tag)) {
            this.olapRequestParam = ParamBuilder.getParam(OlapFromServiceEnum.getEnum(type), paramsrc_tag);
        }
        if ((entryentity = sourceDynamicObject.getDynamicObjectCollection("entryentity")).size() > 0) {
            this.filterEntries = new ArrayList<FilterEntry>(entryentity.size());
            for (DynamicObject dynamicObject : entryentity) {
                FilterEntry filterEntry = new FilterEntry();
                filterEntry.loadFromDynamicObject(dynamicObject);
                if (filterEntry.memberNumbers == null) continue;
                this.filterEntries.add(filterEntry);
            }
        } else {
            this.filterEntries = Collections.emptyList();
        }
    }

    public DataSourceTypeEnum getDataSourceTypeEnum() {
        return this.dataSourceTypeEnum;
    }

    public void setDataSourceTypeEnum(DataSourceTypeEnum dataSourceTypeEnum) {
        this.dataSourceTypeEnum = dataSourceTypeEnum;
    }

    public OlapRequestParam getOlapRequestParam() {
        return this.olapRequestParam;
    }

    public void setOlapRequestParam(OlapRequestParam olapRequestParam) {
        this.olapRequestParam = olapRequestParam;
    }

    public List<FilterEntry> getFilterEntries() {
        return this.filterEntries;
    }

    public void setFilterEntries(List<FilterEntry> filterEntries) {
        this.filterEntries = filterEntries;
    }

    public static class FilterEntry
    extends IDataBaseModel<Long, String, String> {
        String dimNumber;
        Set<String> memberNumbers;

        @Override
        public void loadFromDynamicObject(DynamicObject sourceDynamicObject) {
            super.loadFromDynamicObject(sourceDynamicObject);
            String dimensiontext_tag = sourceDynamicObject.getString("dimensiontext_tag");
            this.dimNumber = sourceDynamicObject.getString("dimensionnum");
            if (StringUtils.isNotBlank((CharSequence)dimensiontext_tag)) {
                JSONArray jsonArray = JSONArray.parseArray((String)dimensiontext_tag);
                this.memberNumbers = new HashSet<String>(jsonArray.size());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    this.memberNumbers.add(jsonObject.getString("number"));
                }
            }
        }

        public Set<String> getMemberNumbers() {
            return this.memberNumbers;
        }

        public void setMemberNumbers(Set<String> memberNumbers) {
            this.memberNumbers = memberNumbers;
        }

        public String getDimNumber() {
            return this.dimNumber;
        }

        public void setDimNumber(String dimNumber) {
            this.dimNumber = dimNumber;
        }
    }
}

