/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMeasureHelper;
import kd.macc.faf.model.impl.BasePropModel;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFAnalysisModelModel
extends BasePropModel {
    private static final long serialVersionUID = 2736669290109976384L;
    private static final int DIMENSION_TYPE_FIX = 1;
    private static final int DIMENSION_TYPE_OTHER = 2;
    private Map<Integer, List<FAFDimensionModel>> dimensionMap;
    private Map<Integer, List<FAFMeasureModel>> measureMap;
    private String modelEntity;
    private FAFDimensionModel orgDim;
    private FAFDimensionModel periodDim;

    @Override
    public void loadFromDynamicObject(DynamicObject sourceDynamicObject, boolean fetchBaseValue) {
        DynamicObject[] measureCols;
        DynamicObject[] dimensionCols;
        super.loadFromDynamicObject(sourceDynamicObject, fetchBaseValue);
        DynamicObjectCollection dimensionEntry = sourceDynamicObject.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntry = sourceDynamicObject.getDynamicObjectCollection("measure_entry");
        HashSet<String> necessityDimSet = new HashSet<String>(3);
        Object[] dimensionIds = new Object[dimensionEntry.size()];
        Object[] measureIds = new Object[measureEntry.size()];
        String orgNumber = "";
        String periodNumber = "";
        int i = 0;
        for (DynamicObject[] entry : dimensionEntry) {
            String necessityDim = entry.getString("necessity_dim");
            DynamicObject dimension = entry.getDynamicObject("dimension");
            dimensionIds[i] = dimension.getPkValue();
            if (StringUtils.isNotBlank((CharSequence)necessityDim)) {
                String dimNumber = dimension.getString("number");
                necessityDimSet.add(dimNumber);
                if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                    orgNumber = dimNumber;
                } else if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) {
                    periodNumber = dimNumber;
                }
            }
            ++i;
        }
        i = 0;
        for (DynamicObject[] entry : measureEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            measureIds[i] = measure.getPkValue();
            ++i;
        }
        for (DynamicObject dim : dimensionCols = FAFDimensionHelper.loadDimension(dimensionIds)) {
            String number = dim.getString("number");
            FAFDimensionModel dimensionModel = new FAFDimensionModel();
            dimensionModel.loadFromDynamicObject(dim, true);
            if (necessityDimSet.contains(number)) {
                this.addFixDim(dimensionModel);
                if (orgNumber.equals(number)) {
                    this.orgDim = dimensionModel;
                    continue;
                }
                if (!periodNumber.equals(number)) continue;
                this.periodDim = dimensionModel;
                continue;
            }
            this.addOtherDim(dimensionModel);
        }
        for (DynamicObject measure : measureCols = FAFMeasureHelper.loadMeasure(measureIds)) {
            FAFMeasureModel measureModel = new FAFMeasureModel();
            measureModel.loadFromDynamicObject(measure, true);
            MeasureTypeEnum measureType = measureModel.getMeasureType();
            if (MeasureTypeEnum.CALCULATION == measureType) {
                DynamicObject dimensionObject = measure.getDynamicObject("dimension");
                FAFDimensionModel dimensionModel = this.getDim(dimensionObject.getPkValue());
                measureModel.setDimension(dimensionModel);
            }
            this.addMeasure(measureType.getCode(), measureModel);
        }
        String tableNumber = sourceDynamicObject.getString("tablenumber");
        this.modelEntity = AnalysisModelUtil.buildEntityNumber(tableNumber);
    }

    public String getModelEntity() {
        return this.modelEntity;
    }

    public String getDetailEntityNumber() {
        return this.modelEntity + "_d";
    }

    public List<FAFDimensionModel> getOtherDim() {
        return this.dimensionMap.get(2);
    }

    public List<FAFDimensionModel> getFixDim() {
        return this.dimensionMap.get(1);
    }

    public List<FAFDimensionModel> getAllDim() {
        List<FAFDimensionModel> fixList;
        ArrayList<FAFDimensionModel> list = new ArrayList<FAFDimensionModel>(2);
        List<FAFDimensionModel> otherList = this.dimensionMap.get(2);
        if (otherList != null) {
            list.addAll(otherList);
        }
        if ((fixList = this.dimensionMap.get(1)) != null) {
            list.addAll(fixList);
        }
        return list;
    }

    public FAFDimensionModel getDim(Object id) {
        for (List<FAFDimensionModel> list : this.dimensionMap.values()) {
            for (FAFDimensionModel model : list) {
                if (!id.equals(model.getId())) continue;
                return model;
            }
        }
        return null;
    }

    public void addFixDim(FAFDimensionModel dimension) {
        this.addDim(1, dimension);
    }

    public void addOtherDim(FAFDimensionModel dimension) {
        this.addDim(2, dimension);
    }

    public void addDim(Integer dimensionType, FAFDimensionModel dimension) {
        List<FAFDimensionModel> list;
        if (this.dimensionMap == null) {
            this.dimensionMap = new HashMap<Integer, List<FAFDimensionModel>>(2);
        }
        if ((list = this.dimensionMap.get(dimensionType)) == null) {
            list = new ArrayList<FAFDimensionModel>(2);
            this.dimensionMap.put(dimensionType, list);
        }
        list.add(dimension);
    }

    public void addMeasure(Integer measureType, FAFMeasureModel measure) {
        List<FAFMeasureModel> list;
        if (this.measureMap == null) {
            this.measureMap = new HashMap<Integer, List<FAFMeasureModel>>(2);
        }
        if ((list = this.measureMap.get(measureType)) == null) {
            list = new ArrayList<FAFMeasureModel>(2);
            this.measureMap.put(measureType, list);
        }
        list.add(measure);
    }

    public List<FAFMeasureModel> getCalMeasure() {
        return this.measureMap.get(MeasureTypeEnum.CALCULATION.getCode());
    }

    public List<FAFMeasureModel> getOrdinaryMeasure() {
        return this.measureMap.get(MeasureTypeEnum.ORDINARY.getCode());
    }

    public FAFMeasureModel findOrdinaryMeasure(String number) {
        return this.findMeasureByNumber(MeasureTypeEnum.ORDINARY, number);
    }

    public FAFMeasureModel findCalMeasure(String number) {
        return this.findMeasureByNumber(MeasureTypeEnum.CALCULATION, number);
    }

    public FAFMeasureModel findMeasureByNumber(MeasureTypeEnum type, String number) {
        for (FAFMeasureModel measure : this.measureMap.get(type.getCode())) {
            if (!number.equals(measure.getNumber())) continue;
            return measure;
        }
        return null;
    }

    public List<FAFDimensionModel> getIndexDimList() {
        ArrayList<FAFDimensionModel> indexDimList = new ArrayList<FAFDimensionModel>(2);
        indexDimList.add(this.orgDim);
        indexDimList.add(this.periodDim);
        return indexDimList;
    }

    public FAFDimensionModel getOrgDim() {
        return this.orgDim;
    }

    public FAFDimensionModel getPeriodDim() {
        return this.periodDim;
    }
}

