/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.model.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.model.impl.BasePropModel;

public class FAFDimensionModel
extends BasePropModel {
    private static final long serialVersionUID = -3205289484341410814L;
    private DimensionTypeEnum dataType;
    private BasePropModel source;
    private long periodType;

    @Override
    public void loadFromDynamicObject(DynamicObject sourceDynamicObject, boolean fetchBaseValue) {
        super.loadFromDynamicObject(sourceDynamicObject, fetchBaseValue);
        this.dataType = DimensionTypeEnum.getCode(sourceDynamicObject.getString("dimensiontype"));
        this.source = new BasePropModel();
        String sourceField = this.getSourceField();
        if (StringUtils.isNotBlank((CharSequence)sourceField)) {
            DynamicObject periodTypeObj;
            this.source.loadFromDynamicObject(sourceDynamicObject.getDynamicObject(sourceField), fetchBaseValue);
            if ("bd_period".equals(this.source.getNumber()) && (periodTypeObj = sourceDynamicObject.getDynamicObject("group")) != null) {
                this.periodType = periodTypeObj.getLong("masterid");
            }
        }
    }

    private String getSourceField() {
        switch (this.dataType) {
            case DATABASE: 
            case PERIOD: {
                return "dimensionsource";
            }
            case ASSISTANTDATA: {
                return "assistantsource";
            }
        }
        return "";
    }

    public void setDataType(DimensionTypeEnum dataType) {
        this.dataType = dataType;
    }

    public void setSource(BasePropModel source) {
        this.source = source;
    }

    public BasePropModel getSource() {
        return this.source;
    }

    public DimensionTypeEnum getDataType() {
        return this.dataType;
    }

    public String valueToString(Object data) {
        if (data == null) {
            return "";
        }
        return this.dataType.readData(data);
    }

    public long getPeriodType() {
        return this.periodType;
    }
}

